/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AELog;
import appeng.crafting.CraftBranchFailure;
import appeng.crafting.CraftingCalculationFailure;
import appeng.crafting.CraftingTreeNode;
import appeng.crafting.MECraftingInventory;
import appeng.hooks.TickHandler;
import com.google.common.base.Stopwatch;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class CraftingJob
implements Runnable,
ICraftingJob {
    IAEItemStack output;
    final IItemList<IAEItemStack> storage;
    final HashSet<IAEItemStack> prophecies;
    boolean simulate = false;
    final MECraftingInventory original;
    MECraftingInventory availableCheck;
    public CraftingTreeNode tree;
    private BaseActionSource actionSrc;
    private ICraftingCallback callback;
    long bytes = 0L;
    final World world;
    final IItemList<IAEItemStack> crafting = AEApi.instance().storage().createItemList();
    final IItemList<IAEItemStack> missing = AEApi.instance().storage().createItemList();
    final HashMap<String, TwoIntegers> opsAndMultiplier = new HashMap();
    private boolean running = false;
    private boolean done = false;
    private final Object monitor = new Object();
    private final Stopwatch watch = Stopwatch.createUnstarted();
    private int time = 5;
    private int incTime = Integer.MAX_VALUE;

    @Override
    public IAEItemStack getOutput() {
        return this.output;
    }

    public CraftingJob(World w, NBTTagCompound data) {
        this.world = this.wrapWorld(w);
        this.storage = AEApi.instance().storage().createItemList();
        this.prophecies = new HashSet();
        this.original = null;
        this.availableCheck = null;
    }

    public void refund(IAEItemStack o) {
        this.availableCheck.injectItems(o, Actionable.MODULATE, this.actionSrc);
    }

    public IAEItemStack checkUse(IAEItemStack available) {
        return this.availableCheck.extractItems(available, Actionable.MODULATE, this.actionSrc);
    }

    public CraftingJob(World w, IGrid grid, BaseActionSource actionSrc, IAEItemStack what, ICraftingCallback callback) {
        this.world = this.wrapWorld(w);
        this.output = what.copy();
        this.storage = AEApi.instance().storage().createItemList();
        this.prophecies = new HashSet();
        this.actionSrc = actionSrc;
        this.callback = callback;
        ICraftingGrid cc = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        IStorageGrid sg = (IStorageGrid)grid.getCache(IStorageGrid.class);
        this.original = new MECraftingInventory(sg.getItemInventory(), actionSrc, false, false, false);
        this.tree = this.getCraftingTree(cc, what);
        this.availableCheck = null;
    }

    private World wrapWorld(World w) {
        return w;
    }

    private CraftingTreeNode getCraftingTree(ICraftingGrid cc, IAEItemStack what) {
        return new CraftingTreeNode(cc, this, what, null, -1, 0);
    }

    @Override
    public long getByteTotal() {
        return this.bytes;
    }

    public void writeToNBT(NBTTagCompound out) {
    }

    public void addTask(IAEItemStack what, long crafts, ICraftingPatternDetails details, int depth) {
        if (crafts > 0L) {
            what = what.copy();
            what.setStackSize(what.getStackSize() * crafts);
            this.crafting.add(what);
        }
    }

    public void addMissing(IAEItemStack what) {
        what = what.copy();
        this.missing.add(what);
    }

    @Override
    public void run() {
        try {
            try {
                TickHandler.instance.registerCraftingSimulation(this.world, this);
                this.handlePausing();
                Stopwatch timer = Stopwatch.createStarted();
                MECraftingInventory craftingInventory = new MECraftingInventory(this.original, true, false, true);
                craftingInventory.ignore(this.output);
                this.availableCheck = new MECraftingInventory(this.original, false, false, false);
                this.tree.request(craftingInventory, this.output.getStackSize(), this.actionSrc);
                this.tree.dive(this);
                for (String s : this.opsAndMultiplier.keySet()) {
                    TwoIntegers ti = this.opsAndMultiplier.get(s);
                    StringBuilder stringBuilder = new StringBuilder().append(s).append(" * ");
                    ti.getClass();
                    StringBuilder stringBuilder2 = stringBuilder.append(0L).append(" = ");
                    ti.getClass();
                    ti.getClass();
                    AELog.crafting(stringBuilder2.append(0L * 0L).toString(), new Object[0]);
                }
                AELog.crafting("------------- " + this.getByteTotal() + "b real" + timer.elapsed(TimeUnit.MILLISECONDS) + "ms", new Object[0]);
            }
            catch (CraftBranchFailure e) {
                this.simulate = true;
                try {
                    Stopwatch timer = Stopwatch.createStarted();
                    MECraftingInventory craftingInventory = new MECraftingInventory(this.original, true, false, true);
                    craftingInventory.ignore(this.output);
                    this.availableCheck = new MECraftingInventory(this.original, false, false, false);
                    this.tree.setSimulate();
                    this.tree.request(craftingInventory, this.output.getStackSize(), this.actionSrc);
                    this.tree.dive(this);
                    for (String s : this.opsAndMultiplier.keySet()) {
                        TwoIntegers ti = this.opsAndMultiplier.get(s);
                        StringBuilder stringBuilder = new StringBuilder().append(s).append(" * ");
                        ti.getClass();
                        StringBuilder stringBuilder3 = stringBuilder.append(0L).append(" = ");
                        ti.getClass();
                        ti.getClass();
                        AELog.crafting(stringBuilder3.append(0L * 0L).toString(), new Object[0]);
                    }
                    AELog.crafting("------------- " + this.getByteTotal() + "b simulate" + timer.elapsed(TimeUnit.MILLISECONDS) + "ms", new Object[0]);
                }
                catch (CraftBranchFailure e1) {
                    AELog.error(e1);
                }
                catch (CraftingCalculationFailure f) {
                    AELog.error(f);
                }
                catch (InterruptedException e1) {
                    AELog.crafting("Crafting calculation canceled.", new Object[0]);
                    this.finish();
                    return;
                }
            }
            catch (CraftingCalculationFailure f) {
                AELog.error(f);
            }
            catch (InterruptedException e1) {
                AELog.crafting("Crafting calculation canceled.", new Object[0]);
                this.finish();
                return;
            }
            this.log("crafting job now done");
        }
        catch (Throwable t) {
            this.finish();
            throw new RuntimeException(t);
        }
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (this.callback != null) {
            this.callback.calculationComplete(this);
        }
        this.availableCheck = null;
        Object object = this.monitor;
        synchronized (object) {
            this.running = false;
            this.done = true;
            this.monitor.notify();
        }
    }

    @Override
    public boolean isSimulation() {
        return this.simulate;
    }

    public boolean isDone() {
        return this.done;
    }

    public World getWorld() {
        return this.world;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean simulateFor(int milli) {
        this.time = milli;
        Object object = this.monitor;
        synchronized (object) {
            if (this.isDone()) {
                return false;
            }
            this.watch.reset();
            this.watch.start();
            this.running = true;
            this.log("main thread is now going to sleep");
            this.monitor.notify();
            while (this.running) {
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.log("main thread is now active");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePausing() throws InterruptedException {
        if (this.incTime++ > 100) {
            this.incTime = 0;
            Object object = this.monitor;
            synchronized (object) {
                if (this.watch.elapsed(TimeUnit.MICROSECONDS) > (long)this.time) {
                    this.running = false;
                    this.watch.stop();
                    this.monitor.notify();
                }
                if (!this.running) {
                    this.log("crafting job will now sleep");
                    while (!this.running) {
                        this.monitor.wait();
                    }
                    this.log("crafting job now active");
                }
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
        }
    }

    private void log(String string) {
    }

    public void addBytes(long crafts) {
        this.bytes += crafts;
    }

    @Override
    public void populatePlan(IItemList<IAEItemStack> plan) {
        if (this.tree != null) {
            this.tree.getPlan(plan);
        }
    }

    static class TwoIntegers {
        public final long perOp = 0L;
        public final long times = 0L;

        TwoIntegers() {
        }
    }
}

