/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.features.IWirelessTermHandler;
import appeng.api.features.IWirelessTermRegistry;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.GuiBridge;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class WirelessRegistry
implements IWirelessTermRegistry {
    final List<IWirelessTermHandler> handlers = new ArrayList<IWirelessTermHandler>();

    @Override
    public void registerWirelessHandler(IWirelessTermHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
    }

    @Override
    public boolean isWirelessTerminal(ItemStack is) {
        for (IWirelessTermHandler h : this.handlers) {
            if (!h.canHandle(is)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IWirelessTermHandler getWirelessTerminalHandler(ItemStack is) {
        for (IWirelessTermHandler h : this.handlers) {
            if (!h.canHandle(is)) continue;
            return h;
        }
        return null;
    }

    @Override
    public void openWirelessTerminalGui(ItemStack item, World w, EntityPlayer player) {
        if (Platform.isClient()) {
            return;
        }
        IWirelessTermHandler handler = this.getWirelessTerminalHandler(item);
        if (handler == null) {
            player.func_145747_a((IChatComponent)new ChatComponentText("Item is not a wireless terminal."));
            return;
        }
        if (handler.hasPower(player, 0.5, item)) {
            Platform.openGUI(player, null, null, GuiBridge.GUI_WIRELESS_TERM);
        } else {
            player.func_145747_a(PlayerMessages.DeviceNotPowered.get());
        }
    }
}

