/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.features.IRecipeHandlerRegistry;
import appeng.api.recipes.ICraftHandler;
import appeng.api.recipes.IRecipeHandler;
import appeng.api.recipes.ISubItemResolver;
import appeng.core.AELog;
import appeng.recipes.RecipeHandler;
import java.util.HashMap;
import java.util.LinkedList;

public class RecipeHandlerRegistry
implements IRecipeHandlerRegistry {
    final HashMap<String, Class<? extends ICraftHandler>> handlers = new HashMap();
    final LinkedList<ISubItemResolver> resolvers = new LinkedList();

    @Override
    public void addNewCraftHandler(String name, Class<? extends ICraftHandler> handler) {
        this.handlers.put(name.toLowerCase(), handler);
    }

    @Override
    public ICraftHandler getCraftHandlerFor(String name) {
        Class<? extends ICraftHandler> clz = this.handlers.get(name);
        if (clz == null) {
            return null;
        }
        try {
            return clz.newInstance();
        }
        catch (Throwable e) {
            AELog.severe("Error Caused when trying to construct " + clz.getName(), new Object[0]);
            AELog.error(e);
            this.handlers.put(name, null);
            return null;
        }
    }

    @Override
    public IRecipeHandler createNewRecipehandler() {
        return new RecipeHandler();
    }

    @Override
    public void addNewSubItemResolver(ISubItemResolver sir) {
        this.resolvers.add(sir);
    }

    @Override
    public Object resolveItem(String nameSpace, String itemName) {
        for (ISubItemResolver sir : this.resolvers) {
            Object rr = null;
            try {
                rr = sir.resolveItemByName(nameSpace, itemName);
            }
            catch (Throwable t) {
                AELog.error(t);
            }
            if (rr == null) continue;
            return rr;
        }
        return null;
    }
}

