/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import com.google.common.base.Optional;

public class FeatureNameExtractor {
    private final Class<?> clazz;
    private final Optional<String> subName;

    public FeatureNameExtractor(Class<?> clazz, Optional<String> subName) {
        this.clazz = clazz;
        this.subName = subName;
    }

    public String get() {
        String name = this.clazz.getSimpleName();
        if (name.startsWith("ItemMultiPart")) {
            name = name.replace("ItemMultiPart", "ItemPart");
        } else if (name.startsWith("ItemMultiMaterial")) {
            name = name.replace("ItemMultiMaterial", "ItemMaterial");
        }
        if (this.subName.isPresent()) {
            String subName = (String)this.subName.get();
            if (subName.startsWith("P2PTunnel")) {
                return "ItemPart.P2PTunnel";
            }
            if (subName.equals("CertusQuartzTools")) {
                return name.replace("Quartz", "CertusQuartz");
            }
            if (subName.equals("NetherQuartzTools")) {
                return name.replace("Quartz", "NetherQuartz");
            }
            name = name + '.' + subName;
        }
        return name;
    }
}

