/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.util.AEItemDefinition;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseItemBlock;
import appeng.core.CommonHelper;
import appeng.core.CreativeTab;
import appeng.core.features.AEBlockDefinition;
import appeng.core.features.AEFeature;
import appeng.core.features.FeatureNameExtractor;
import appeng.core.features.FeaturedActiveChecker;
import appeng.core.features.IFeatureHandler;
import appeng.util.Platform;
import com.google.common.base.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.EnumSet;
import net.minecraft.block.Block;

public class AEBlockFeatureHandler
implements IFeatureHandler {
    private final EnumSet<AEFeature> features;
    private final AEBaseBlock featured;
    private final FeatureNameExtractor extractor;
    private final boolean enabled;
    private final AEBlockDefinition definition;

    public AEBlockFeatureHandler(EnumSet<AEFeature> features, AEBaseBlock featured, Optional<String> subName) {
        this.features = features;
        this.featured = featured;
        this.extractor = new FeatureNameExtractor(featured.getClass(), subName);
        this.enabled = new FeaturedActiveChecker(features).get();
        this.definition = new AEBlockDefinition(featured, this.enabled);
    }

    @Override
    public boolean isFeatureAvailable() {
        return this.enabled;
    }

    @Override
    public EnumSet<AEFeature> getFeatures() {
        return this.features;
    }

    @Override
    public AEItemDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public void register() {
        if (this.enabled) {
            String name = this.extractor.get();
            this.featured.func_149647_a(CreativeTab.instance);
            this.featured.func_149663_c("appliedenergistics2." + name);
            this.featured.func_149658_d("appliedenergistics2:" + name);
            if (Platform.isClient()) {
                CommonHelper.proxy.bindTileEntitySpecialRenderer(this.featured.getTileEntityClass(), this.featured);
            }
            Class<? extends AEBaseItemBlock> itemBlockClass = this.featured.getItemBlockClass();
            GameRegistry.registerBlock((Block)this.featured, itemBlockClass, (String)("tile." + name));
        }
    }
}

