/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.api;

import appeng.api.parts.CableRenderMode;
import appeng.api.parts.IPartHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.LayerBase;
import appeng.client.render.BusRenderer;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.CommonHelper;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IFMP;
import appeng.parts.PartPlacement;
import appeng.tile.networking.TileCableBus;
import appeng.util.Platform;
import com.google.common.base.Joiner;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ApiPart
implements IPartHelper {
    private final Map<String, Class> tileImplementations = new HashMap<String, Class>();
    private final Map<Class<?>, String> interfaces2Layer = new HashMap();
    private final Map<String, Class> roots = new HashMap<String, Class>();
    private final List<String> desc = new LinkedList<String>();

    public void initFMPSupport() {
        for (Class<?> layerInterface : this.interfaces2Layer.keySet()) {
            if (!AppEng.instance.isIntegrationEnabled(IntegrationType.FMP)) continue;
            ((IFMP)AppEng.instance.getIntegration(IntegrationType.FMP)).registerPassThrough(layerInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClass(String Name, byte[] b) {
        Class clazz = null;
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Class<ClassLoader> root = ClassLoader.class;
            Class<?> cls = loader.getClass();
            Method defineClassMethod = root.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            Method runTransformersMethod = cls.getDeclaredMethod("runTransformers", String.class, String.class, byte[].class);
            runTransformersMethod.setAccessible(true);
            defineClassMethod.setAccessible(true);
            try {
                Object[] argsA = new Object[]{Name, Name, b};
                b = (byte[])runTransformersMethod.invoke((Object)loader, argsA);
                Object[] args = new Object[]{Name, b, 0, b.length};
                clazz = (Class)defineClassMethod.invoke((Object)loader, args);
            }
            finally {
                runTransformersMethod.setAccessible(false);
                defineClassMethod.setAccessible(false);
            }
        }
        catch (Exception e) {
            AELog.error(e);
            throw new RuntimeException("Unable to manage part API.", e);
        }
        return clazz;
    }

    public ClassNode getReader(String name) {
        try {
            String path = '/' + name.replace(".", "/") + ".class";
            InputStream is = this.getClass().getResourceAsStream(path);
            ClassReader cr = new ClassReader(is);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 8);
            return cn;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error loading " + name, t);
        }
    }

    public Class getCombinedInstance(String base) {
        Class myCLass;
        if (this.desc.size() == 0) {
            try {
                return Class.forName(base);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        String description = base + ':' + Joiner.on((String)";").skipNulls().join(this.desc.iterator());
        if (this.tileImplementations.get(description) != null) {
            try {
                return this.tileImplementations.get(description);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        String f = base;
        String Addendum = "";
        try {
            Addendum = Class.forName(base).getSimpleName();
        }
        catch (ClassNotFoundException e) {
            AELog.error(e);
        }
        try {
            myCLass = Class.forName(f);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        String path = f;
        for (String name : this.desc) {
            try {
                String newPath = path + ';' + name;
                myCLass = this.getClassByDesc(Addendum, newPath, f, this.interfaces2Layer.get(Class.forName(name)));
                path = newPath;
            }
            catch (Throwable t) {
                AELog.warning("Error loading " + name, new Object[0]);
                AELog.error(t);
            }
            f = myCLass.getName();
        }
        this.tileImplementations.put(description, myCLass);
        try {
            return myCLass;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public Class getClassByDesc(String Addendum, String fullPath, String root, String next) {
        if (this.roots.get(fullPath) != null) {
            return this.roots.get(fullPath);
        }
        ClassWriter cw = new ClassWriter(1);
        ClassNode n = this.getReader(next);
        String originalName = n.name;
        try {
            n.name = n.name + '_' + Addendum;
            n.superName = Class.forName(root).getName().replace(".", "/");
        }
        catch (Throwable t) {
            AELog.error(t);
        }
        for (MethodNode mn : n.methods) {
            ListIterator i = mn.instructions.iterator();
            while (i.hasNext()) {
                this.processNode((AbstractInsnNode)i.next(), n.superName);
            }
        }
        DefaultPackageClassNameRemapper remapper = new DefaultPackageClassNameRemapper();
        remapper.inputOutput.put("appeng/api/parts/LayerBase", n.superName);
        remapper.inputOutput.put(originalName, n.name);
        n.accept((ClassVisitor)new RemappingClassAdapter((ClassVisitor)cw, (Remapper)remapper));
        byte[] byteArray = cw.toByteArray();
        int size = byteArray.length;
        Class clazz = this.loadClass(n.name.replace("/", "."), byteArray);
        try {
            Object fish = clazz.newInstance();
            Class<?> rootC = Class.forName(root);
            boolean hasError = false;
            if (!rootC.isInstance(fish)) {
                hasError = true;
                AELog.severe("Error, Expected layer to implement " + root + " did not.", new Object[0]);
            }
            if (fish instanceof LayerBase) {
                hasError = true;
                AELog.severe("Error, Expected layer to NOT implement LayerBase but it DID.", new Object[0]);
            }
            if (!fullPath.contains(".fmp.")) {
                if (!(fish instanceof TileCableBus)) {
                    hasError = true;
                    AELog.severe("Error, Expected layer to implement TileCableBus did not.", new Object[0]);
                }
                if (!(fish instanceof TileEntity)) {
                    hasError = true;
                    AELog.severe("Error, Expected layer to implement TileEntity did not.", new Object[0]);
                }
            }
            if (!hasError) {
                AELog.info("Layer: " + n.name + " loaded successfully - " + size + " bytes", new Object[0]);
            }
        }
        catch (Throwable t) {
            AELog.severe("Layer: " + n.name + " Failed.", new Object[0]);
            AELog.error(t);
        }
        this.roots.put(fullPath, clazz);
        return clazz;
    }

    private void processNode(AbstractInsnNode next, String nePar) {
        if (next instanceof MethodInsnNode) {
            MethodInsnNode min = (MethodInsnNode)next;
            if (min.owner.equals("appeng/api/parts/LayerBase")) {
                min.owner = nePar;
            }
        }
    }

    @Override
    public void setItemBusRenderer(IPartItem i) {
        if (Platform.isClient() && i instanceof Item) {
            MinecraftForgeClient.registerItemRenderer((Item)((Item)i), (IItemRenderer)BusRenderer.instance);
        }
    }

    @Override
    public boolean placeBus(ItemStack is, int x, int y, int z, int side, EntityPlayer player, World w) {
        return PartPlacement.place(is, x, y, z, side, player, w, PartPlacement.PlaceType.PLACE_ITEM, 0);
    }

    @Override
    public boolean registerNewLayer(String layer, String layerInterface) {
        try {
            Class<?> layerInterfaceClass = Class.forName(layerInterface);
            if (this.interfaces2Layer.get(layerInterfaceClass) == null) {
                this.interfaces2Layer.put(layerInterfaceClass, layer);
                this.desc.add(layerInterface);
                return true;
            }
            AELog.info("Layer " + layer + " not registered, " + layerInterface + " already has a layer.", new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public CableRenderMode getCableRenderMode() {
        return CommonHelper.proxy.getRenderMode();
    }

    static class DefaultPackageClassNameRemapper
    extends Remapper {
        public final HashMap<String, String> inputOutput = new HashMap();

        DefaultPackageClassNameRemapper() {
        }

        public String map(String typeName) {
            String o = this.inputOutput.get(typeName);
            if (o == null) {
                return typeName;
            }
            return o;
        }
    }
}

