/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.api.AEApi;
import appeng.api.storage.ICellHandler;
import appeng.api.util.AEColor;
import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.texture.ExtraBlockTextures;
import appeng.client.texture.FlippableIcon;
import appeng.client.texture.OffsetIcon;
import appeng.tile.storage.TileChest;
import appeng.util.Platform;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderMEChest
extends BaseBlockRender {
    public RenderMEChest() {
        super(false, 0.0);
    }

    @Override
    public void renderInventory(AEBaseBlock block, ItemStack is, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
        Tessellator.field_78398_a.func_78380_c(0);
        renderer.field_147840_d = ExtraBlockTextures.getMissing();
        this.renderInvBlock(EnumSet.of(ForgeDirection.SOUTH), block, is, Tessellator.field_78398_a, 0, renderer);
        renderer.field_147840_d = ExtraBlockTextures.MEChest.getIcon();
        this.renderInvBlock(EnumSet.of(ForgeDirection.UP), block, is, Tessellator.field_78398_a, this.adjustBrightness(AEColor.Transparent.whiteVariant, 0.7), renderer);
        renderer.field_147840_d = null;
        super.renderInventory(block, is, renderer, type, obj);
    }

    @Override
    public boolean renderInWorld(AEBaseBlock imb, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        TileChest sp = (TileChest)imb.getTileEntity(world, x, y, z);
        renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        ForgeDirection up = sp.getUp();
        ForgeDirection forward = sp.getForward();
        ForgeDirection west = Platform.crossProduct(forward, up);
        this.preRenderInWorld(imb, world, x, y, z, renderer);
        int stat = sp.getCellStatus(0);
        boolean result = renderer.func_147784_q((Block)imb, x, y, z);
        this.selectFace(renderer, west, up, forward, 5, 11, 9, 12);
        int offsetU = -4;
        int offsetV = 8;
        if (stat == 0) {
            offsetV = 3;
        }
        int b = world.func_72802_i(x + forward.offsetX, y + forward.offsetY, z + forward.offsetZ, 0);
        Tessellator.field_78398_a.func_78380_c(b);
        Tessellator.field_78398_a.func_78378_d(0xFFFFFF);
        FlippableIcon flippableIcon = new FlippableIcon(new OffsetIcon(ExtraBlockTextures.MEStorageCellTextures.getIcon(), offsetU, offsetV));
        if (forward == ForgeDirection.EAST && (up == ForgeDirection.NORTH || up == ForgeDirection.SOUTH)) {
            flippableIcon.setFlip(true, false);
        } else if (forward == ForgeDirection.NORTH && up == ForgeDirection.EAST) {
            flippableIcon.setFlip(false, true);
        } else if (forward == ForgeDirection.NORTH && up == ForgeDirection.WEST) {
            flippableIcon.setFlip(true, false);
        } else if (forward == ForgeDirection.DOWN && up == ForgeDirection.EAST) {
            flippableIcon.setFlip(false, true);
        } else if (forward == ForgeDirection.DOWN) {
            flippableIcon.setFlip(true, false);
        }
        this.renderFace(x, y, z, (Block)imb, flippableIcon, renderer, forward);
        if (stat != 0) {
            b = 0;
            if (sp.isPowered()) {
                b = 0xF000F0;
            }
            Tessellator.field_78398_a.func_78380_c(b);
            if (stat == 1) {
                Tessellator.field_78398_a.func_78378_d(65280);
            }
            if (stat == 2) {
                Tessellator.field_78398_a.func_78378_d(0xFFAA00);
            }
            if (stat == 3) {
                Tessellator.field_78398_a.func_78378_d(0xFF0000);
            }
            this.selectFace(renderer, west, up, forward, 9, 10, 11, 12);
            this.renderFace(x, y, z, (Block)imb, ExtraBlockTextures.White.getIcon(), renderer, forward);
        }
        b = world.func_72802_i(x + up.offsetX, y + up.offsetY, z + up.offsetZ, 0);
        if (sp.isPowered()) {
            b = 0xF000F0;
        }
        Tessellator.field_78398_a.func_78380_c(b);
        Tessellator.field_78398_a.func_78378_d(0xFFFFFF);
        renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        ICellHandler ch = AEApi.instance().registries().cell().getHandler(sp.getStorageType());
        Tessellator.field_78398_a.func_78378_d(sp.getColor().whiteVariant);
        IIcon ico = ch == null ? null : ch.getTopTexture_Light();
        this.renderFace(x, y, z, (Block)imb, ico == null ? ExtraBlockTextures.MEChest.getIcon() : ico, renderer, up);
        if (ico != null) {
            Tessellator.field_78398_a.func_78378_d(sp.getColor().mediumVariant);
            ico = ch == null ? null : ch.getTopTexture_Medium();
            this.renderFace(x, y, z, (Block)imb, ico == null ? ExtraBlockTextures.MEChest.getIcon() : ico, renderer, up);
            Tessellator.field_78398_a.func_78378_d(sp.getColor().blackVariant);
            ico = ch == null ? null : ch.getTopTexture_Dark();
            this.renderFace(x, y, z, (Block)imb, ico == null ? ExtraBlockTextures.MEChest.getIcon() : ico, renderer, up);
        }
        renderer.field_147840_d = null;
        this.postRenderInWorld(renderer);
        return result;
    }
}

