/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.parts.ISimplifiedBundle;
import appeng.core.AELog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class RenderBlocksWorkaround
extends RenderBlocks {
    public boolean calculations = true;
    public EnumSet<ForgeDirection> renderFaces = EnumSet.allOf(ForgeDirection.class);
    public EnumSet<ForgeDirection> faces = EnumSet.allOf(ForgeDirection.class);
    private LightingCache lightState = new LightingCache();
    public boolean isFacade = false;
    public boolean useTextures = true;
    Field fBrightness;
    Field fColor;
    final int[] lightHashTmp = new int[27];
    public float opacity = 1.0f;

    public int getCurrentColor() {
        try {
            if (this.fColor == null) {
                try {
                    this.fColor = Tessellator.class.getDeclaredField("color");
                }
                catch (Throwable t) {
                    this.fColor = Tessellator.class.getDeclaredField("field_78402_m");
                }
                this.fColor.setAccessible(true);
            }
            return (Integer)this.fColor.get(Tessellator.field_78398_a);
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public int getCurrentBrightness() {
        try {
            if (this.fBrightness == null) {
                try {
                    this.fBrightness = Tessellator.class.getDeclaredField("brightness");
                }
                catch (Throwable t) {
                    this.fBrightness = Tessellator.class.getDeclaredField("field_78401_l");
                }
                this.fBrightness.setAccessible(true);
            }
            return (Integer)this.fBrightness.get(Tessellator.field_78398_a);
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public void setTexture(IIcon ico) {
        this.lightState.rZPos = this.lightState.rZNeg = ico;
        this.lightState.rYNeg = this.lightState.rZNeg;
        this.lightState.rYPos = this.lightState.rZNeg;
        this.lightState.rXNeg = this.lightState.rZNeg;
        this.lightState.rXPos = this.lightState.rZNeg;
    }

    public void setTexture(IIcon rYNeg, IIcon rYPos, IIcon rZNeg, IIcon rZPos, IIcon rXNeg, IIcon rXPos) {
        this.lightState.rXPos = rXPos;
        this.lightState.rXNeg = rXNeg;
        this.lightState.rYPos = rYPos;
        this.lightState.rYNeg = rYNeg;
        this.lightState.rZPos = rZPos;
        this.lightState.rZNeg = rZNeg;
    }

    public boolean renderStandardBlockNoCalculations(Block b, int x, int y, int z) {
        Tessellator.field_78398_a.func_78380_c(this.lightState.bXPos);
        this.restoreAO(this.lightState.aoXPos, this.lightState.foXPos);
        this.func_147764_f(b, x, y, z, this.useTextures ? this.lightState.rXPos : this.func_147793_a(b, this.field_147845_a, x, y, z, ForgeDirection.EAST.ordinal()));
        Tessellator.field_78398_a.func_78380_c(this.lightState.bXNeg);
        this.restoreAO(this.lightState.aoXNeg, this.lightState.foXNeg);
        this.func_147798_e(b, x, y, z, this.useTextures ? this.lightState.rXNeg : this.func_147793_a(b, this.field_147845_a, x, y, z, ForgeDirection.WEST.ordinal()));
        Tessellator.field_78398_a.func_78380_c(this.lightState.bYPos);
        this.restoreAO(this.lightState.aoYPos, this.lightState.foYPos);
        this.func_147806_b(b, x, y, z, this.useTextures ? this.lightState.rYPos : this.func_147793_a(b, this.field_147845_a, x, y, z, ForgeDirection.UP.ordinal()));
        Tessellator.field_78398_a.func_78380_c(this.lightState.bYNeg);
        this.restoreAO(this.lightState.aoYNeg, this.lightState.foYNeg);
        this.func_147768_a(b, x, y, z, this.useTextures ? this.lightState.rYNeg : this.func_147793_a(b, this.field_147845_a, x, y, z, ForgeDirection.DOWN.ordinal()));
        Tessellator.field_78398_a.func_78380_c(this.lightState.bZPos);
        this.restoreAO(this.lightState.aoZPos, this.lightState.foZPos);
        this.func_147734_d(b, x, y, z, this.useTextures ? this.lightState.rZPos : this.func_147793_a(b, this.field_147845_a, x, y, z, ForgeDirection.SOUTH.ordinal()));
        Tessellator.field_78398_a.func_78380_c(this.lightState.bZNeg);
        this.restoreAO(this.lightState.aoZNeg, this.lightState.foZNeg);
        this.func_147761_c(b, x, y, z, this.useTextures ? this.lightState.rZNeg : this.func_147793_a(b, this.field_147845_a, x, y, z, ForgeDirection.NORTH.ordinal()));
        return true;
    }

    private void restoreAO(int[] z, float[] c) {
        this.field_147874_am = z[0];
        this.field_147876_an = z[1];
        this.field_147864_al = z[2];
        this.field_147870_ao = z[3];
        Tessellator.field_78398_a.func_78384_a(z[4], (int)(this.opacity * 255.0f));
        this.field_147872_ap = c[0];
        this.field_147846_at = c[1];
        this.field_147854_ax = c[2];
        this.field_147852_aq = c[3];
        this.field_147860_au = c[4];
        this.field_147841_ay = c[5];
        this.field_147850_ar = c[6];
        this.field_147858_av = c[7];
        this.field_147839_az = c[8];
        this.field_147848_as = c[9];
        this.field_147856_aw = c[10];
        this.field_147833_aA = c[11];
    }

    private void saveAO(int[] z, float[] c) {
        z[0] = this.field_147874_am;
        z[1] = this.field_147876_an;
        z[2] = this.field_147864_al;
        z[3] = this.field_147870_ao;
        z[4] = this.getCurrentColor();
        c[0] = this.field_147872_ap;
        c[1] = this.field_147846_at;
        c[2] = this.field_147854_ax;
        c[3] = this.field_147852_aq;
        c[4] = this.field_147860_au;
        c[5] = this.field_147841_ay;
        c[6] = this.field_147850_ar;
        c[7] = this.field_147858_av;
        c[8] = this.field_147839_az;
        c[9] = this.field_147848_as;
        c[10] = this.field_147856_aw;
        c[11] = this.field_147833_aA;
    }

    public boolean func_147784_q(Block blk, int x, int y, int z) {
        try {
            if (this.calculations) {
                this.lightState.lightHash = this.getLightingHash(blk, this.field_147845_a, x, y, z);
                return super.func_147784_q(blk, x, y, z);
            }
            this.field_147863_w = this.lightState.isAO;
            boolean out = this.renderStandardBlockNoCalculations(blk, x, y, z);
            this.field_147863_w = false;
            return out;
        }
        catch (Throwable t) {
            AELog.error(t);
            return false;
        }
    }

    public void func_147798_e(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        if (this.faces.contains(ForgeDirection.WEST)) {
            if (!this.renderFaces.contains(ForgeDirection.WEST)) {
                return;
            }
            if (this.isFacade) {
                Tessellator tessellator = Tessellator.field_78398_a;
                double d3 = par8Icon.func_94214_a(this.field_147851_l * 16.0);
                double d4 = par8Icon.func_94214_a(this.field_147853_m * 16.0);
                double d5 = par8Icon.func_94207_b(16.0 - this.field_147857_k * 16.0);
                double d6 = par8Icon.func_94207_b(16.0 - this.field_147855_j * 16.0);
                double d11 = par2 + this.field_147859_h;
                double d12 = par4 + this.field_147855_j;
                double d13 = par4 + this.field_147857_k;
                double d14 = par6 + this.field_147851_l;
                double d15 = par6 + this.field_147853_m;
                if (this.field_147863_w) {
                    this.partialLightingColoring(this.field_147857_k, this.field_147853_m);
                    tessellator.func_78374_a(d11, d13, d15, d4, d5);
                    this.partialLightingColoring(this.field_147857_k, this.field_147851_l);
                    tessellator.func_78374_a(d11, d13, d14, d3, d5);
                    this.partialLightingColoring(this.field_147855_j, this.field_147851_l);
                    tessellator.func_78374_a(d11, d12, d14, d3, d6);
                    this.partialLightingColoring(this.field_147855_j, this.field_147853_m);
                    tessellator.func_78374_a(d11, d12, d15, d4, d6);
                } else {
                    tessellator.func_78374_a(d11, d13, d15, d4, d5);
                    tessellator.func_78374_a(d11, d13, d14, d3, d5);
                    tessellator.func_78374_a(d11, d12, d14, d3, d6);
                    tessellator.func_78374_a(d11, d12, d15, d4, d6);
                }
            } else {
                super.func_147798_e(par1Block, par2, par4, par6, par8Icon);
            }
        } else {
            this.lightState.isAO = this.field_147863_w;
            this.lightState.rXNeg = par8Icon;
            this.saveAO(this.lightState.aoXNeg, this.lightState.foXNeg);
            this.lightState.bXNeg = this.getCurrentBrightness();
        }
    }

    public void func_147764_f(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        if (this.faces.contains(ForgeDirection.EAST)) {
            if (!this.renderFaces.contains(ForgeDirection.EAST)) {
                return;
            }
            if (this.isFacade) {
                Tessellator tessellator = Tessellator.field_78398_a;
                double d3 = par8Icon.func_94214_a(16.0 - this.field_147851_l * 16.0);
                double d4 = par8Icon.func_94214_a(16.0 - this.field_147853_m * 16.0);
                double d5 = par8Icon.func_94207_b(16.0 - this.field_147857_k * 16.0);
                double d6 = par8Icon.func_94207_b(16.0 - this.field_147855_j * 16.0);
                double d11 = par2 + this.field_147861_i;
                double d12 = par4 + this.field_147855_j;
                double d13 = par4 + this.field_147857_k;
                double d14 = par6 + this.field_147851_l;
                double d15 = par6 + this.field_147853_m;
                if (this.field_147863_w) {
                    this.partialLightingColoring(1.0 - this.field_147855_j, this.field_147853_m);
                    tessellator.func_78374_a(d11, d12, d15, d4, d6);
                    this.partialLightingColoring(1.0 - this.field_147855_j, this.field_147851_l);
                    tessellator.func_78374_a(d11, d12, d14, d3, d6);
                    this.partialLightingColoring(1.0 - this.field_147857_k, this.field_147851_l);
                    tessellator.func_78374_a(d11, d13, d14, d3, d5);
                    this.partialLightingColoring(1.0 - this.field_147857_k, this.field_147853_m);
                    tessellator.func_78374_a(d11, d13, d15, d4, d5);
                } else {
                    tessellator.func_78374_a(d11, d12, d15, d4, d6);
                    tessellator.func_78374_a(d11, d12, d14, d3, d6);
                    tessellator.func_78374_a(d11, d13, d14, d3, d5);
                    tessellator.func_78374_a(d11, d13, d15, d4, d5);
                }
            } else {
                super.func_147764_f(par1Block, par2, par4, par6, par8Icon);
            }
        } else {
            this.lightState.isAO = this.field_147863_w;
            this.lightState.rXPos = par8Icon;
            this.saveAO(this.lightState.aoXPos, this.lightState.foXPos);
            this.lightState.bXPos = this.getCurrentBrightness();
        }
    }

    private void partialLightingColoring(double u, double v) {
        double rA = (double)this.field_147872_ap * u + (1.0 - u) * (double)this.field_147848_as;
        double rB = (double)this.field_147852_aq * u + (1.0 - u) * (double)this.field_147850_ar;
        float r = (float)(rA * v + rB * (1.0 - v));
        double gA = (double)this.field_147846_at * u + (1.0 - u) * (double)this.field_147856_aw;
        double gB = (double)this.field_147860_au * u + (1.0 - u) * (double)this.field_147858_av;
        float g = (float)(gA * v + gB * (1.0 - v));
        double bA = (double)this.field_147854_ax * u + (1.0 - u) * (double)this.field_147833_aA;
        double bB = (double)this.field_147841_ay * u + (1.0 - u) * (double)this.field_147839_az;
        float b = (float)(bA * v + bB * (1.0 - v));
        double highA = (double)(this.field_147864_al >> 16 & 0xFF) * u + (1.0 - u) * (double)(this.field_147870_ao >> 16 & 0xFF);
        double highB = (double)(this.field_147874_am >> 16 & 0xFF) * u + (1.0 - u) * (double)(this.field_147876_an >> 16 & 0xFF);
        int high = (int)(highA * v + highB * (1.0 - v)) & 0xFF;
        double lowA = (double)(this.field_147864_al & 0xFF) * u + (1.0 - u) * (double)(this.field_147870_ao & 0xFF);
        double lowB = (double)(this.field_147874_am & 0xFF) * u + (1.0 - u) * (double)(this.field_147876_an & 0xFF);
        int low = (int)(lowA * v + lowB * (1.0 - v)) & 0xFF;
        int out = high << 16 | low;
        Tessellator.field_78398_a.func_78369_a(r, g, b, this.opacity);
        Tessellator.field_78398_a.func_78380_c(out);
    }

    public void func_147768_a(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        if (this.faces.contains(ForgeDirection.DOWN)) {
            if (!this.renderFaces.contains(ForgeDirection.DOWN)) {
                return;
            }
            if (this.isFacade) {
                Tessellator tessellator = Tessellator.field_78398_a;
                double d3 = par8Icon.func_94214_a(this.field_147859_h * 16.0);
                double d4 = par8Icon.func_94214_a(this.field_147861_i * 16.0);
                double d5 = par8Icon.func_94207_b(this.field_147851_l * 16.0);
                double d6 = par8Icon.func_94207_b(this.field_147853_m * 16.0);
                double d11 = par2 + this.field_147859_h;
                double d12 = par2 + this.field_147861_i;
                double d13 = par4 + this.field_147855_j;
                double d14 = par6 + this.field_147851_l;
                double d15 = par6 + this.field_147853_m;
                if (this.field_147863_w) {
                    this.partialLightingColoring(1.0 - this.field_147859_h, this.field_147853_m);
                    tessellator.func_78374_a(d11, d13, d15, d3, d6);
                    this.partialLightingColoring(1.0 - this.field_147859_h, this.field_147851_l);
                    tessellator.func_78374_a(d11, d13, d14, d3, d5);
                    this.partialLightingColoring(1.0 - this.field_147861_i, this.field_147851_l);
                    tessellator.func_78374_a(d12, d13, d14, d4, d5);
                    this.partialLightingColoring(1.0 - this.field_147861_i, this.field_147853_m);
                    tessellator.func_78374_a(d12, d13, d15, d4, d6);
                } else {
                    tessellator.func_78374_a(d11, d13, d15, d3, d6);
                    tessellator.func_78374_a(d11, d13, d14, d3, d5);
                    tessellator.func_78374_a(d12, d13, d14, d4, d5);
                    tessellator.func_78374_a(d12, d13, d15, d4, d6);
                }
            } else {
                super.func_147768_a(par1Block, par2, par4, par6, par8Icon);
            }
        } else {
            this.lightState.isAO = this.field_147863_w;
            this.lightState.rYNeg = par8Icon;
            this.saveAO(this.lightState.aoYNeg, this.lightState.foYNeg);
            this.lightState.bYNeg = this.getCurrentBrightness();
        }
    }

    public void func_147806_b(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        if (this.faces.contains(ForgeDirection.UP)) {
            if (!this.renderFaces.contains(ForgeDirection.UP)) {
                return;
            }
            if (this.isFacade) {
                Tessellator tessellator = Tessellator.field_78398_a;
                double d3 = par8Icon.func_94214_a(this.field_147859_h * 16.0);
                double d4 = par8Icon.func_94214_a(this.field_147861_i * 16.0);
                double d5 = par8Icon.func_94207_b(this.field_147851_l * 16.0);
                double d6 = par8Icon.func_94207_b(this.field_147853_m * 16.0);
                double d11 = par2 + this.field_147859_h;
                double d12 = par2 + this.field_147861_i;
                double d13 = par4 + this.field_147857_k;
                double d14 = par6 + this.field_147851_l;
                double d15 = par6 + this.field_147853_m;
                if (this.field_147863_w) {
                    this.partialLightingColoring(this.field_147861_i, this.field_147853_m);
                    tessellator.func_78374_a(d12, d13, d15, d4, d6);
                    this.partialLightingColoring(this.field_147861_i, this.field_147851_l);
                    tessellator.func_78374_a(d12, d13, d14, d4, d5);
                    this.partialLightingColoring(this.field_147859_h, this.field_147851_l);
                    tessellator.func_78374_a(d11, d13, d14, d3, d5);
                    this.partialLightingColoring(this.field_147859_h, this.field_147853_m);
                    tessellator.func_78374_a(d11, d13, d15, d3, d6);
                } else {
                    tessellator.func_78374_a(d12, d13, d15, d4, d6);
                    tessellator.func_78374_a(d12, d13, d14, d4, d5);
                    tessellator.func_78374_a(d11, d13, d14, d3, d5);
                    tessellator.func_78374_a(d11, d13, d15, d3, d6);
                }
            } else {
                super.func_147806_b(par1Block, par2, par4, par6, par8Icon);
            }
        } else {
            this.lightState.isAO = this.field_147863_w;
            this.lightState.rYPos = par8Icon;
            this.saveAO(this.lightState.aoYPos, this.lightState.foYPos);
            this.lightState.bYPos = this.getCurrentBrightness();
        }
    }

    public void func_147761_c(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        if (this.faces.contains(ForgeDirection.NORTH)) {
            if (!this.renderFaces.contains(ForgeDirection.NORTH)) {
                return;
            }
            if (this.isFacade) {
                Tessellator tessellator = Tessellator.field_78398_a;
                double d3 = par8Icon.func_94214_a(16.0 - this.field_147859_h * 16.0);
                double d4 = par8Icon.func_94214_a(16.0 - this.field_147861_i * 16.0);
                double d5 = par8Icon.func_94207_b(16.0 - this.field_147857_k * 16.0);
                double d6 = par8Icon.func_94207_b(16.0 - this.field_147855_j * 16.0);
                double d11 = par2 + this.field_147859_h;
                double d12 = par2 + this.field_147861_i;
                double d13 = par4 + this.field_147855_j;
                double d14 = par4 + this.field_147857_k;
                double d15 = par6 + this.field_147851_l;
                if (this.field_147863_w) {
                    this.partialLightingColoring(this.field_147857_k, 1.0 - this.field_147859_h);
                    tessellator.func_78374_a(d11, d14, d15, d3, d5);
                    this.partialLightingColoring(this.field_147857_k, 1.0 - this.field_147861_i);
                    tessellator.func_78374_a(d12, d14, d15, d4, d5);
                    this.partialLightingColoring(this.field_147855_j, 1.0 - this.field_147861_i);
                    tessellator.func_78374_a(d12, d13, d15, d4, d6);
                    this.partialLightingColoring(this.field_147855_j, 1.0 - this.field_147859_h);
                    tessellator.func_78374_a(d11, d13, d15, d3, d6);
                } else {
                    tessellator.func_78374_a(d11, d14, d15, d3, d5);
                    tessellator.func_78374_a(d12, d14, d15, d4, d5);
                    tessellator.func_78374_a(d12, d13, d15, d4, d6);
                    tessellator.func_78374_a(d11, d13, d15, d3, d6);
                }
            } else {
                super.func_147761_c(par1Block, par2, par4, par6, par8Icon);
            }
        } else {
            this.lightState.isAO = this.field_147863_w;
            this.lightState.rZNeg = par8Icon;
            this.saveAO(this.lightState.aoZNeg, this.lightState.foZNeg);
            this.lightState.bZNeg = this.getCurrentBrightness();
        }
    }

    public void func_147734_d(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        if (this.faces.contains(ForgeDirection.SOUTH)) {
            if (!this.renderFaces.contains(ForgeDirection.SOUTH)) {
                return;
            }
            if (this.isFacade) {
                Tessellator tessellator = Tessellator.field_78398_a;
                double d3 = par8Icon.func_94214_a(this.field_147859_h * 16.0);
                double d4 = par8Icon.func_94214_a(this.field_147861_i * 16.0);
                double d5 = par8Icon.func_94207_b(16.0 - this.field_147857_k * 16.0);
                double d6 = par8Icon.func_94207_b(16.0 - this.field_147855_j * 16.0);
                double d11 = par2 + this.field_147859_h;
                double d12 = par2 + this.field_147861_i;
                double d13 = par4 + this.field_147855_j;
                double d14 = par4 + this.field_147857_k;
                double d15 = par6 + this.field_147853_m;
                if (this.field_147863_w) {
                    this.partialLightingColoring(1.0 - this.field_147859_h, this.field_147857_k);
                    tessellator.func_78374_a(d11, d14, d15, d3, d5);
                    this.partialLightingColoring(1.0 - this.field_147859_h, this.field_147855_j);
                    tessellator.func_78374_a(d11, d13, d15, d3, d6);
                    this.partialLightingColoring(1.0 - this.field_147861_i, this.field_147855_j);
                    tessellator.func_78374_a(d12, d13, d15, d4, d6);
                    this.partialLightingColoring(1.0 - this.field_147861_i, this.field_147857_k);
                    tessellator.func_78374_a(d12, d14, d15, d4, d5);
                } else {
                    tessellator.func_78374_a(d11, d14, d15, d3, d5);
                    tessellator.func_78374_a(d11, d13, d15, d3, d6);
                    tessellator.func_78374_a(d12, d13, d15, d4, d6);
                    tessellator.func_78374_a(d12, d14, d15, d4, d5);
                }
            } else {
                super.func_147734_d(par1Block, par2, par4, par6, par8Icon);
            }
        } else {
            this.lightState.isAO = this.field_147863_w;
            this.lightState.rZPos = par8Icon;
            this.saveAO(this.lightState.aoZPos, this.lightState.foZPos);
            this.lightState.bZPos = this.getCurrentBrightness();
        }
    }

    public boolean similarLighting(Block blk, IBlockAccess w, int x, int y, int z, ISimplifiedBundle sim) {
        int lh = this.getLightingHash(blk, w, x, y, z);
        return ((LightingCache)sim).lightHash == lh;
    }

    private int getLightingHash(Block blk, IBlockAccess w, int x, int y, int z) {
        int o = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    this.lightHashTmp[o++] = blk.func_149677_c(this.field_147845_a, x + i, y + j, z + k);
                }
            }
        }
        return Arrays.hashCode(this.lightHashTmp);
    }

    public void populate(ISimplifiedBundle sim) {
        this.lightState = new LightingCache((LightingCache)sim);
    }

    public ISimplifiedBundle getLightingCache() {
        return new LightingCache(this.lightState);
    }

    private static class LightingCache
    implements ISimplifiedBundle {
        public IIcon rXPos;
        public IIcon rXNeg;
        public IIcon rYPos;
        public IIcon rYNeg;
        public IIcon rZPos;
        public IIcon rZNeg;
        public boolean isAO;
        public int bXPos;
        public int bXNeg;
        public int bYPos;
        public int bYNeg;
        public int bZPos;
        public int bZNeg;
        public final int[] aoXPos;
        public final int[] aoXNeg;
        public final int[] aoYPos;
        public final int[] aoYNeg;
        public final int[] aoZPos;
        public final int[] aoZNeg;
        public final float[] foXPos;
        public final float[] foXNeg;
        public final float[] foYPos;
        public final float[] foYNeg;
        public final float[] foZPos;
        public final float[] foZNeg;
        public int lightHash;

        public LightingCache(LightingCache secondCSrc) {
            this.rXPos = secondCSrc.rXPos;
            this.rXNeg = secondCSrc.rXNeg;
            this.rYPos = secondCSrc.rYPos;
            this.rYNeg = secondCSrc.rYNeg;
            this.rZPos = secondCSrc.rZPos;
            this.rZNeg = secondCSrc.rZNeg;
            this.isAO = secondCSrc.isAO;
            this.bXPos = secondCSrc.bXPos;
            this.bXNeg = secondCSrc.bXNeg;
            this.bYPos = secondCSrc.bYPos;
            this.bYNeg = secondCSrc.bYNeg;
            this.bZPos = secondCSrc.bZPos;
            this.bZNeg = secondCSrc.bZNeg;
            this.aoXPos = (int[])secondCSrc.aoXPos.clone();
            this.aoXNeg = (int[])secondCSrc.aoXNeg.clone();
            this.aoYPos = (int[])secondCSrc.aoYPos.clone();
            this.aoYNeg = (int[])secondCSrc.aoYNeg.clone();
            this.aoZPos = (int[])secondCSrc.aoZPos.clone();
            this.aoZNeg = (int[])secondCSrc.aoZNeg.clone();
            this.foXPos = (float[])secondCSrc.foXPos.clone();
            this.foXNeg = (float[])secondCSrc.foXNeg.clone();
            this.foYPos = (float[])secondCSrc.foYPos.clone();
            this.foYNeg = (float[])secondCSrc.foYNeg.clone();
            this.foZPos = (float[])secondCSrc.foZPos.clone();
            this.foZNeg = (float[])secondCSrc.foZNeg.clone();
            this.lightHash = secondCSrc.lightHash;
        }

        public LightingCache() {
            this.rXPos = null;
            this.rXNeg = null;
            this.rYPos = null;
            this.rYNeg = null;
            this.rZPos = null;
            this.rZNeg = null;
            this.isAO = false;
            this.bXPos = 0;
            this.bXNeg = 0;
            this.bYPos = 0;
            this.bYNeg = 0;
            this.bZPos = 0;
            this.bZNeg = 0;
            this.aoXPos = new int[5];
            this.aoXNeg = new int[5];
            this.aoYPos = new int[5];
            this.aoYNeg = new int[5];
            this.aoZPos = new int[5];
            this.aoZNeg = new int[5];
            this.foXPos = new float[12];
            this.foXNeg = new float[12];
            this.foYPos = new float[12];
            this.foYNeg = new float[12];
            this.foZPos = new float[12];
            this.foZNeg = new float[12];
            this.lightHash = 0;
        }
    }
}

