/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.me;

import appeng.api.AEApi;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.config.YesNo;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.core.AEConfig;
import appeng.items.storage.ItemViewCell;
import appeng.util.ItemSorters;
import appeng.util.Platform;
import appeng.util.prioitylist.IPartitionList;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;

public class ItemRepo {
    private final IItemList<IAEItemStack> list = AEApi.instance().storage().createItemList();
    private final ArrayList<IAEItemStack> view = new ArrayList();
    private final ArrayList<ItemStack> dsp = new ArrayList();
    private final IScrollSource src;
    private final ISortSource sortSrc;
    public int rowSize = 9;
    public String searchString = "";
    private String innerSearch = "";
    IPartitionList<IAEItemStack> myPartitionList;
    private String NEIWord = null;
    private boolean hasPower;

    public ItemRepo(IScrollSource src, ISortSource sortSrc) {
        this.src = src;
        this.sortSrc = sortSrc;
    }

    public IAEItemStack getReferenceItem(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.view.size()) {
            return null;
        }
        return this.view.get(idx);
    }

    public ItemStack getItem(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.dsp.size()) {
            return null;
        }
        return this.dsp.get(idx);
    }

    void setSearch(String search) {
        this.searchString = search == null ? "" : search;
    }

    public void postUpdate(IAEItemStack is) {
        IAEItemStack st = this.list.findPrecise(is);
        if (st != null) {
            st.reset();
            st.add(is);
        } else {
            this.list.add(is);
        }
    }

    public void setViewCell(ItemStack[] list) {
        this.myPartitionList = ItemViewCell.createFilter(list);
        this.updateView();
    }

    private void updateNEI(String filter) {
        try {
            if (this.NEIWord == null || !this.NEIWord.equals(filter)) {
                Class c = ReflectionHelper.getClass((ClassLoader)this.getClass().getClassLoader(), (String[])new String[]{"codechicken.nei.LayoutManager"});
                Field fldSearchField = c.getField("searchField");
                Object searchField = fldSearchField.get(c);
                Method a = searchField.getClass().getMethod("setText", String.class);
                Method b = searchField.getClass().getMethod("onTextChange", String.class);
                this.NEIWord = filter;
                a.invoke(searchField, filter);
                b.invoke(searchField, "");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void updateView() {
        this.view.clear();
        this.dsp.clear();
        this.view.ensureCapacity(this.list.size());
        this.dsp.ensureCapacity(this.list.size());
        Enum viewMode = this.sortSrc.getSortDisplay();
        Enum searchMode = AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE);
        if (searchMode == SearchBoxMode.NEI_AUTOSEARCH || searchMode == SearchBoxMode.NEI_MANUAL_SEARCH) {
            this.updateNEI(this.searchString);
        }
        this.innerSearch = this.searchString;
        boolean terminalSearchToolTips = AEConfig.instance.settings.getSetting(Settings.SEARCH_TOOLTIPS) != YesNo.NO;
        boolean searchMod = false;
        if (this.innerSearch.startsWith("@")) {
            searchMod = true;
            this.innerSearch = this.innerSearch.substring(1);
        }
        Pattern m = null;
        try {
            m = Pattern.compile(this.innerSearch.toLowerCase(), 2);
        }
        catch (Throwable ignore) {
            try {
                m = Pattern.compile(Pattern.quote(this.innerSearch.toLowerCase()), 2);
            }
            catch (Throwable __) {
                return;
            }
        }
        boolean notDone = false;
        block4: for (IAEItemStack is : this.list) {
            if (this.myPartitionList != null && !this.myPartitionList.isListed(is) || viewMode == ViewItems.CRAFTABLE && !is.isCraftable()) continue;
            if (viewMode == ViewItems.CRAFTABLE) {
                is = is.copy();
                is.setStackSize(0L);
            }
            if (viewMode == ViewItems.STORED && is.getStackSize() == 0L) continue;
            String dspName = searchMod ? Platform.getModId(is) : Platform.getItemDisplayName(is);
            notDone = true;
            if (m.matcher(dspName.toLowerCase()).find()) {
                this.view.add(is);
                notDone = false;
            }
            if (!terminalSearchToolTips || !notDone) continue;
            for (Object lp : Platform.getTooltip(is)) {
                if (!(lp instanceof String) || !m.matcher((String)lp).find()) continue;
                this.view.add(is);
                notDone = false;
                continue block4;
            }
        }
        Enum SortBy = this.sortSrc.getSortBy();
        Enum SortDir2 = this.sortSrc.getSortDir();
        ItemSorters.Direction = (SortDir)SortDir2;
        ItemSorters.init();
        if (SortBy == SortOrder.MOD) {
            Collections.sort(this.view, ItemSorters.ConfigBased_SortByMod);
        } else if (SortBy == SortOrder.AMOUNT) {
            Collections.sort(this.view, ItemSorters.ConfigBased_SortBySize);
        } else if (SortBy == SortOrder.INVTWEAKS) {
            Collections.sort(this.view, ItemSorters.ConfigBased_SortByInvTweaks);
        } else {
            Collections.sort(this.view, ItemSorters.ConfigBased_SortByName);
        }
        for (IAEItemStack is : this.view) {
            this.dsp.add(is.getItemStack());
        }
    }

    public int size() {
        return this.view.size();
    }

    public void clear() {
        this.list.resetStatus();
    }

    public boolean hasPower() {
        return this.hasPower;
    }

    public void setPower(boolean hasPower) {
        this.hasPower = hasPower;
    }
}

