/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.guiobjects.INetworkTool;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.me.ItemRepo;
import appeng.client.me.SlotME;
import appeng.container.implementations.ContainerNetworkStatus;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiNetworkStatus
extends AEBaseGui
implements ISortSource {
    final ItemRepo repo;
    GuiImgButton units;
    final int rows = 4;
    int tooltip = -1;

    public GuiNetworkStatus(InventoryPlayer inventoryPlayer, INetworkTool te) {
        super(new ContainerNetworkStatus(inventoryPlayer, te));
        this.field_147000_g = 153;
        this.field_146999_f = 195;
        this.myScrollBar = new GuiScrollbar();
        this.repo = new ItemRepo(this.myScrollBar, this);
        this.repo.rowSize = 5;
    }

    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        if (btn == this.units) {
            AEConfig.instance.nextPowerUnit(backwards);
            this.units.set(AEConfig.instance.selectedPowerUnit());
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.units = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 8, Settings.POWER_UNITS, AEConfig.instance.selectedPowerUnit());
        this.field_146292_n.add(this.units);
    }

    public void postUpdate(List<IAEItemStack> list) {
        this.repo.clear();
        for (IAEItemStack is : list) {
            this.repo.postUpdate(is);
        }
        this.repo.updateView();
        this.setScrollBar();
    }

    private void setScrollBar() {
        int size = this.repo.size();
        this.myScrollBar.setTop(39).setLeft(175).setHeight(78);
        this.myScrollBar.setRange(0, (size + 4) / 5 - this.rows, 1);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/networkstatus.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void func_73863_a(int mouse_x, int mouse_y, float btn) {
        int x = 0;
        int y = 0;
        int gx = (this.field_146294_l - this.field_146999_f) / 2;
        int gy = (this.field_146295_m - this.field_147000_g) / 2;
        this.tooltip = -1;
        for (int z = 0; z <= 20; ++z) {
            int minX = gx + 14 + x * 31;
            int minY = gy + 41 + y * 18;
            if (minX < mouse_x && minX + 28 > mouse_x && minY < mouse_y && minY + 20 > mouse_y) {
                this.tooltip = z;
                break;
            }
            if (++x <= 4) continue;
            ++y;
            x = 0;
        }
        super.func_73863_a(mouse_x, mouse_y, btn);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        ContainerNetworkStatus ns = (ContainerNetworkStatus)this.field_147002_h;
        this.field_146289_q.func_78276_b(GuiText.NetworkDetails.getLocal(), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.StoredPower.getLocal() + ": " + Platform.formatPowerLong(ns.currentPower, false), 13, 16, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.MaxPower.getLocal() + ": " + Platform.formatPowerLong(ns.maxPower, false), 13, 26, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.PowerInputRate.getLocal() + ": " + Platform.formatPowerLong(ns.avgAddition, true), 13, 133, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.PowerUsageRate.getLocal() + ": " + Platform.formatPowerLong(ns.powerUsage, true), 13, 123, 0x404040);
        int sectionLength = 30;
        int x = 0;
        int y = 0;
        int xo = 12;
        int yo = 42;
        int viewStart = 0;
        int viewEnd = viewStart + 20;
        String ToolTip = "";
        int toolPosX = 0;
        int toolPosY = 0;
        for (int z = viewStart; z < Math.min(viewEnd, this.repo.size()); ++z) {
            IAEItemStack refStack = this.repo.getReferenceItem(z);
            if (refStack == null) continue;
            GL11.glPushMatrix();
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            String str = Long.toString(refStack.getStackSize());
            if (refStack.getStackSize() >= 10000L) {
                str = Long.toString(refStack.getStackSize() / 1000L) + 'k';
            }
            int w = this.field_146289_q.func_78256_a(str);
            this.field_146289_q.func_78276_b(str, (int)(((double)(x * sectionLength + xo + sectionLength - 19) - (double)w * 0.5) * 2.0), (y * 18 + yo + 6) * 2, 0x404040);
            GL11.glPopMatrix();
            int posX = x * sectionLength + xo + sectionLength - 18;
            int posY = y * 18 + yo;
            if (this.tooltip == z - viewStart) {
                ToolTip = Platform.getItemDisplayName(this.repo.getItem(z));
                ToolTip = ToolTip + '\n' + GuiText.Installed.getLocal() + ": " + refStack.getStackSize();
                if (refStack.getCountRequestable() > 0L) {
                    ToolTip = ToolTip + '\n' + GuiText.EnergyDrain.getLocal() + ": " + Platform.formatPowerLong(refStack.getCountRequestable(), true);
                }
                toolPosX = x * sectionLength + xo + sectionLength - 8;
                toolPosY = y * 18 + yo;
            }
            this.drawItem(posX, posY, this.repo.getItem(z));
            if (++x <= 4) continue;
            ++y;
            x = 0;
        }
        if (this.tooltip >= 0 && ToolTip.length() > 0) {
            GL11.glPushAttrib((int)1048575);
            this.drawTooltip(toolPosX, toolPosY + 10, 0, ToolTip);
            GL11.glPopAttrib();
        }
    }

    public List<String> handleItemTooltip(ItemStack stack, int mouseX, int mouseY, List<String> currentToolTip) {
        Slot s;
        if (stack != null && (s = this.getSlot(mouseX, mouseY)) instanceof SlotME) {
            IAEItemStack myStack = null;
            try {
                SlotME theSlotField = (SlotME)s;
                myStack = theSlotField.getAEStack();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (myStack != null) {
                while (currentToolTip.size() > 1) {
                    currentToolTip.remove(1);
                }
            }
        }
        return currentToolTip;
    }

    protected void drawItemStackTooltip(ItemStack stack, int x, int y) {
        Slot s = this.getSlot(x, y);
        if (s instanceof SlotME && stack != null) {
            IAEItemStack myStack = null;
            try {
                SlotME theSlotField = (SlotME)s;
                myStack = theSlotField.getAEStack();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (myStack != null) {
                List currentToolTip = stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
                while (currentToolTip.size() > 1) {
                    currentToolTip.remove(1);
                }
                currentToolTip.add(GuiText.Installed.getLocal() + ": " + myStack.getStackSize());
                currentToolTip.add(GuiText.EnergyDrain.getLocal() + ": " + Platform.formatPowerLong(myStack.getCountRequestable(), true));
                this.drawTooltip(x, y, 0, GuiNetworkStatus.join(currentToolTip, "\n"));
            }
        }
    }

    @Override
    public Enum getSortBy() {
        return SortOrder.NAME;
    }

    @Override
    public Enum getSortDir() {
        return SortDir.ASCENDING;
    }

    @Override
    public Enum getSortDisplay() {
        return ViewItems.ALL;
    }
}

