/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.solids;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseBlock;
import appeng.core.AppEng;
import appeng.core.WorldSettings;
import appeng.core.features.AEFeature;
import appeng.helpers.LocationRotation;
import appeng.helpers.NullRotation;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IRB;
import appeng.util.Platform;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import rblocks.api.RotatableBlockEnable;

@RotatableBlockEnable
public class BlockSkyStone
extends AEBaseBlock
implements IOrientableBlock {
    @SideOnly(value=Side.CLIENT)
    IIcon Block;
    @SideOnly(value=Side.CLIENT)
    IIcon Brick;
    @SideOnly(value=Side.CLIENT)
    IIcon SmallBrick;

    @SubscribeEvent
    public void breakFaster(PlayerEvent.BreakSpeed Ev) {
        if (Ev.block == this && Ev.entityPlayer != null) {
            ItemStack is = Ev.entityPlayer.field_71071_by.func_70448_g();
            int level = -1;
            if (is != null) {
                level = is.func_77973_b().getHarvestLevel(is, "pickaxe");
            }
            if (Ev.metadata > 0 || level >= 3 || (double)Ev.originalSpeed > 7.0) {
                Ev.newSpeed = (float)((double)Ev.newSpeed / 0.1);
            }
        }
    }

    public BlockSkyStone() {
        super(BlockSkyStone.class, Material.field_151576_e);
        this.setFeature(EnumSet.of(AEFeature.Core));
        this.func_149711_c(50.0f);
        this.hasSubtypes = true;
        this.field_149781_w = 150.0f;
        this.setHarvestLevel("pickaxe", 3, 0);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @Override
    public String getUnlocalizedName(ItemStack is) {
        if (is.func_77960_j() == 1) {
            return this.func_149739_a() + ".Block";
        }
        if (is.func_77960_j() == 2) {
            return this.func_149739_a() + ".Brick";
        }
        if (is.func_77960_j() == 3) {
            return this.func_149739_a() + ".SmallBrick";
        }
        return this.func_149739_a();
    }

    @Override
    public IOrientable getOrientable(IBlockAccess w, int x, int y, int z) {
        IOrientable out;
        TileEntity te;
        if (AppEng.instance.isIntegrationEnabled(IntegrationType.RB) && (te = w.func_147438_o(x, y, z)) != null && (out = ((IRB)AppEng.instance.getIntegration(IntegrationType.RB)).getOrientable(te)) != null) {
            return out;
        }
        if (w.func_72805_g(x, y, z) == 0) {
            return new LocationRotation(w, x, y, z);
        }
        return new NullRotation();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        super.func_149651_a(ir);
        this.Block = ir.func_94245_a(this.func_149641_N() + ".Block");
        this.Brick = ir.func_94245_a(this.func_149641_N() + ".Brick");
        this.SmallBrick = ir.func_94245_a(this.func_149641_N() + ".SmallBrick");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int direction, int metadata) {
        if (metadata == 1) {
            return this.Block;
        }
        if (metadata == 2) {
            return this.Brick;
        }
        if (metadata == 3) {
            return this.SmallBrick;
        }
        return super.func_149691_a(direction, metadata);
    }

    @Override
    public void setRenderStateByMeta(int metadata) {
        this.getRendererInstance().setTemporaryRenderIcon(this.func_149691_a(0, metadata));
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack is = super.getPickBlock(target, world, x, y, z);
        is.func_77964_b(world.func_72805_g(x, y, z));
        return is;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getCheckedSubBlocks(Item item, CreativeTabs tabs, List<ItemStack> itemStacks) {
        super.getCheckedSubBlocks(item, tabs, itemStacks);
        itemStacks.add(new ItemStack(item, 1, 1));
        itemStacks.add(new ItemStack(item, 1, 2));
        itemStacks.add(new ItemStack(item, 1, 3));
    }

    public void func_149726_b(World w, int x, int y, int z) {
        super.func_149726_b(w, x, y, z);
        if (Platform.isServer()) {
            WorldSettings.getInstance().getCompass().updateArea(w, x, y, z);
        }
    }

    @Override
    public void func_149749_a(World w, int x, int y, int z, Block b, int WTF) {
        super.func_149749_a(w, x, y, z, b, WTF);
        if (Platform.isServer()) {
            WorldSettings.getInstance().getCompass().updateArea(w, x, y, z);
        }
    }

    int getRealRenderType() {
        return this.func_149645_b();
    }

    @Override
    public boolean usesMetadata() {
        return false;
    }
}

