/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartItemStack;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AEColor;
import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.BusRenderHelper;
import appeng.client.render.blocks.RendererCableBus;
import appeng.client.texture.ExtraBlockTextures;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.helpers.AEGlassMaterial;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IFMP;
import appeng.parts.CableBusContainer;
import appeng.parts.ICableBusContainer;
import appeng.parts.NullCableBusContainer;
import appeng.tile.AEBaseTile;
import appeng.tile.networking.TileCableBus;
import appeng.tile.networking.TileCableBusTESR;
import appeng.transformer.annotations.integration;
import appeng.util.Platform;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.IRedNetConnection;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.RedNetConnectionType;

@integration.Interface(iface="powercrystals.minefactoryreloaded.api.rednet.connectivity.IRedNetConnection", iname="MFR")
public class BlockCableBus
extends AEBaseBlock
implements IRedNetConnection {
    private static final ICableBusContainer nullCB = new NullCableBusContainer();
    public static Class<? extends TileEntity> noTesrTile;
    public static Class<? extends TileEntity> tesrTile;
    boolean ImmibisMicroblocks_TransformableBlockMarker = true;
    int myColorMultiplier = 0xFFFFFF;

    @Override
    public <T extends TileEntity> T getTileEntity(IBlockAccess w, int x, int y, int z) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (noTesrTile.isInstance(te)) {
            return (T)te;
        }
        if (tesrTile != null && tesrTile.isInstance(te)) {
            return (T)te;
        }
        return null;
    }

    public BlockCableBus() {
        super(BlockCableBus.class, AEGlassMaterial.instance);
        this.setFeature(EnumSet.of(AEFeature.Core));
        this.func_149713_g(0);
        this.isOpaque = false;
        this.isFullSize = false;
    }

    public int func_149701_w() {
        if (AEConfig.instance.isFeatureEnabled(AEFeature.AlphaPass)) {
            return 1;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        ICableBusContainer object = this.cb((IBlockAccess)world, target.field_72311_b, target.field_72312_c, target.field_72309_d);
        if (object instanceof IPartHost) {
            IPartHost host = (IPartHost)((Object)object);
            for (ForgeDirection side : ForgeDirection.values()) {
                IPart p = host.getPart(side);
                IIcon ico = this.getIcon(p);
                if (ico == null) continue;
                int b0 = Platform.getRandomInt() % 2 == 0 ? 1 : 0;
                for (int i1 = 0; i1 < b0; ++i1) {
                    for (int j1 = 0; j1 < b0; ++j1) {
                        for (int k1 = 0; k1 < b0; ++k1) {
                            double d0 = (double)target.field_72311_b + ((double)i1 + 0.5) / (double)b0;
                            double d1 = (double)target.field_72312_c + ((double)j1 + 0.5) / (double)b0;
                            double d2 = (double)target.field_72309_d + ((double)k1 + 0.5) / (double)b0;
                            double dd0 = target.field_72307_f.field_72450_a;
                            double dd1 = target.field_72307_f.field_72448_b;
                            double dd2 = target.field_72307_f.field_72449_c;
                            EntityDiggingFX fx = new EntityDiggingFX(world, dd0, dd1, dd2, d0 - (double)target.field_72311_b - 0.5, d1 - (double)target.field_72312_c - 0.5, d2 - (double)target.field_72309_d - 0.5, (Block)this, 0).func_70596_a(target.field_72311_b, target.field_72312_c, target.field_72309_d);
                            fx.func_110125_a(ico);
                            effectRenderer.func_78873_a((EntityFX)fx);
                        }
                    }
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        ICableBusContainer object = this.cb((IBlockAccess)world, x, y, z);
        if (object instanceof IPartHost) {
            IPartHost host = (IPartHost)((Object)object);
            for (ForgeDirection side : ForgeDirection.values()) {
                IPart p = host.getPart(side);
                IIcon ico = this.getIcon(p);
                if (ico == null) continue;
                int b0 = 3;
                for (int i1 = 0; i1 < b0; ++i1) {
                    for (int j1 = 0; j1 < b0; ++j1) {
                        for (int k1 = 0; k1 < b0; ++k1) {
                            double d0 = (double)x + ((double)i1 + 0.5) / (double)b0;
                            double d1 = (double)y + ((double)j1 + 0.5) / (double)b0;
                            double d2 = (double)z + ((double)k1 + 0.5) / (double)b0;
                            EntityDiggingFX fx = new EntityDiggingFX(world, d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, (Block)this, meta).func_70596_a(x, y, z);
                            fx.func_110125_a(ico);
                            effectRenderer.func_78873_a((EntityFX)fx);
                        }
                    }
                }
            }
        }
        return true;
    }

    private IIcon getIcon(IPart p) {
        if (p == null) {
            return null;
        }
        try {
            IIcon ico = p.getBreakingTexture();
            if (ico != null) {
                return ico;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        ItemStack is = p.getItemStack(PartItemStack.Network);
        if (is == null || is.func_77973_b() == null) {
            return null;
        }
        return is.func_77973_b().getIcon(is, 0);
    }

    public boolean canRenderInPass(int pass) {
        BusRenderHelper.instance.setPass(pass);
        if (AEConfig.instance.isFeatureEnabled(AEFeature.AlphaPass)) {
            return true;
        }
        return pass == 0;
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return this.cb(world, x, y, z).isLadder(entity);
    }

    @Override
    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        return this.recolourBlock(world, x, y, z, side, colour, null);
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour, EntityPlayer who) {
        try {
            return this.cb((IBlockAccess)world, x, y, z).recolourBlock(side, AEColor.values()[colour], who);
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public void func_149734_b(World world, int x, int y, int z, Random r) {
        this.cb((IBlockAccess)world, x, y, z).randomDisplayTick(world, x, y, z, r);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != null && block != this) {
            return block.getLightValue(world, x, y, z);
        }
        if (block == null) {
            return 0;
        }
        return this.cb(world, x, y, z).getLightValue();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Vec3 v3 = target.field_72307_f.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        SelectedPart sp = this.cb((IBlockAccess)world, x, y, z).selectPart(v3);
        if (sp.part != null) {
            return sp.part.getItemStack(PartItemStack.Pick);
        }
        if (sp.facade != null) {
            return sp.facade.getItemStack();
        }
        return null;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return this.cb(world, x, y, z).isEmpty();
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        AEBaseTile tile;
        if (player.field_71075_bZ.field_75098_d && (tile = (AEBaseTile)this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            tile.disableDrops();
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    @Override
    public IIcon func_149673_e(IBlockAccess w, int x, int y, int z, int s) {
        return this.func_149691_a(s, 0);
    }

    @Override
    public IIcon func_149691_a(int direction, int metadata) {
        IIcon i = super.func_149691_a(direction, metadata);
        if (i != null) {
            return i;
        }
        return ExtraBlockTextures.BlockQuartzGlassB.getIcon();
    }

    @Override
    protected Class<? extends BaseBlockRender> getRenderer() {
        return RendererCableBus.class;
    }

    @Override
    public void func_149651_a(IIconRegister iconRegistry) {
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean isSideSolid(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        return this.cb(w, x, y, z).isSolidOnSide(side);
    }

    public void func_149695_a(World w, int x, int y, int z, Block meh) {
        this.cb((IBlockAccess)w, x, y, z).onNeighborChanged();
    }

    public void onNeighborChange(IBlockAccess w, int x, int y, int z, int tileX, int tileY, int tileZ) {
        if (Platform.isServer()) {
            this.cb(w, x, y, z).onNeighborChanged();
        }
    }

    public Item func_149650_a(int i, Random r, int k) {
        return null;
    }

    @Override
    public boolean onActivated(World w, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return this.cb((IBlockAccess)w, x, y, z).activate(player, Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ));
    }

    public void func_149670_a(World w, int x, int y, int z, Entity e) {
        this.cb((IBlockAccess)w, x, y, z).onEntityCollision(e);
    }

    public boolean canConnectRedstone(IBlockAccess w, int x, int y, int z, int side) {
        switch (side) {
            case -1: 
            case 4: {
                return this.cb(w, x, y, z).canConnectRedstone(EnumSet.of(ForgeDirection.UP, ForgeDirection.DOWN));
            }
            case 0: {
                return this.cb(w, x, y, z).canConnectRedstone(EnumSet.of(ForgeDirection.NORTH));
            }
            case 1: {
                return this.cb(w, x, y, z).canConnectRedstone(EnumSet.of(ForgeDirection.EAST));
            }
            case 2: {
                return this.cb(w, x, y, z).canConnectRedstone(EnumSet.of(ForgeDirection.SOUTH));
            }
            case 3: {
                return this.cb(w, x, y, z).canConnectRedstone(EnumSet.of(ForgeDirection.WEST));
            }
        }
        return false;
    }

    public int func_149709_b(IBlockAccess w, int x, int y, int z, int side) {
        return this.cb(w, x, y, z).isProvidingWeakPower(ForgeDirection.getOrientation((int)side).getOpposite());
    }

    public int func_149748_c(IBlockAccess w, int x, int y, int z, int side) {
        return this.cb(w, x, y, z).isProvidingStrongPower(ForgeDirection.getOrientation((int)side).getOpposite());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getCheckedSubBlocks(Item item, CreativeTabs tabs, List<ItemStack> itemStacks) {
    }

    public void setupTile() {
        noTesrTile = Api.instance.partHelper.getCombinedInstance(TileCableBus.class.getName());
        this.setTileEntity(noTesrTile);
        if (Platform.isClient()) {
            tesrTile = Api.instance.partHelper.getCombinedInstance(TileCableBusTESR.class.getName());
            GameRegistry.registerTileEntity(tesrTile, (String)"ClientOnly_TESR_CableBus");
            CommonHelper.proxy.bindTileEntitySpecialRenderer(tesrTile, this);
        }
    }

    private ICableBusContainer cb(IBlockAccess w, int x, int y, int z) {
        TileEntity te = w.func_147438_o(x, y, z);
        CableBusContainer out = null;
        if (te instanceof TileCableBus) {
            out = ((TileCableBus)te).cb;
        } else if (AppEng.instance.isIntegrationEnabled(IntegrationType.FMP)) {
            out = ((IFMP)AppEng.instance.getIntegration(IntegrationType.FMP)).getCableContainer(te);
        }
        return out == null ? nullCB : out;
    }

    @integration.Method(iname="MFR")
    public RedNetConnectionType getConnectionType(World world, int x, int y, int z, ForgeDirection side) {
        return this.cb((IBlockAccess)world, x, y, z).canConnectRedstone(EnumSet.allOf(ForgeDirection.class)) ? RedNetConnectionType.CableSingle : RedNetConnectionType.None;
    }

    public void setRenderColor(int color) {
        this.myColorMultiplier = color;
    }

    public int func_149720_d(IBlockAccess p_149720_1_, int p_149720_2_, int p_149720_3_, int p_149720_4_) {
        return this.myColorMultiplier;
    }
}

