/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.worldgen;

import com.rwtema.extrautils.worldgen.WorldGenBedrockTree;
import com.rwtema.extrautils.worldgen.WorldGenBigHole;
import com.rwtema.extrautils.worldgen.WorldGenCastle;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderFlat;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;

public class ChunkProviderUnderdark
extends ChunkProviderFlat
implements IChunkProvider {
    public static final int cavern_height = 55;
    public static boolean denyDecor = false;
    private static double population = 0.25;
    private final boolean mapFeaturesEnabled;
    Random r = new Random();
    private Random rand;
    private MapGenCaves caveGenerator = new MapGenCaves();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private MapGenVillage villageGenerator = new MapGenVillage();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private MapGenRavine ravineGenerator = new MapGenRavine();
    private WorldGenBigHole holes_gen = new WorldGenBigHole();
    private WorldGenCastle castle_gen = new WorldGenCastle();
    private WorldGenBedrockTree tree_gen = new WorldGenBedrockTree();
    private World worldObj;
    private Block[] base_array = new Block[65536];

    public ChunkProviderUnderdark(World par1World, long par2, boolean par4) {
        super(par1World, par2, par4, "2;7,80x1,4,69x0,100x1,7;3;stronghold,dungeon,mineshaft,decoration");
        this.worldObj = par1World;
        this.mapFeaturesEnabled = par4;
        this.rand = new Random(par2);
        for (int i = 0; i < this.base_array.length; ++i) {
            this.base_array[i] = Blocks.field_150350_a;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y <= 83; ++y) {
                    this.base_array[(x * 16 + z) * 128 + y] = Blocks.field_150348_b;
                }
            }
        }
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int par2, int par3) {
        super.func_73153_a(par1IChunkProvider, par2, par3);
        int k = par2 * 16;
        int l = par3 * 16;
        this.mineshaftGenerator.func_75051_a(this.worldObj, this.r, par2, par3);
        denyDecor = true;
        this.worldObj.func_72807_a(k, l).func_76728_a(this.worldObj, this.rand, k, l);
        GameRegistry.generateWorld((int)par2, (int)par3, (World)this.worldObj, (IChunkProvider)this, (IChunkProvider)par1IChunkProvider);
        denyDecor = false;
        this.holes_gen.func_76484_a(this.worldObj, this.rand, k + 8, 0, l + 8);
        this.castle_gen.func_76484_a(this.worldObj, this.rand, k + 8, 82, l + 8);
        this.tree_gen.func_76484_a(this.worldObj, this.rand, k + 8, 82, l + 8);
    }

    public Chunk func_73154_d(int par1, int par2) {
        Chunk chunk = new Chunk(this.worldObj, par1, par2);
        Block[] arr = (Block[])this.base_array.clone();
        this.caveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, arr);
        this.ravineGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, arr);
        this.r.setSeed(this.worldObj.func_72905_C() + (long)((par1 >> 2) * 65535) + (long)(par2 >> 2));
        int spire_x = (par1 >> 2 << 2) * 16 + 6 + this.r.nextInt(52) - par1 * 16;
        int spire_z = (par2 >> 2 << 2) * 16 + 6 + this.r.nextInt(52) - par2 * 16;
        int spire_rad = 4 + this.r.nextInt(6);
        this.r.setSeed(this.worldObj.func_72905_C() + (long)(par1 * 65535) + (long)par2);
        Block stone_type = Blocks.field_150348_b;
        boolean stalegtites = false;
        boolean stalegmites = false;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                stalegtites = false;
                stalegmites = false;
                float rs = (spire_x - x) * (spire_x - x) + (spire_z - z) * (spire_z - z);
                for (int y = 0; y < 255; ++y) {
                    int l = y >> 4;
                    ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[l];
                    if (extendedblockstorage == null) {
                        chunk.func_76587_i()[l] = extendedblockstorage = new ExtendedBlockStorage(y, !this.worldObj.field_73011_w.field_76576_e);
                    }
                    Block id = Blocks.field_150350_a;
                    if (y <= 83 && arr[(x * 16 + z) * 128 + y] != Blocks.field_150348_b) {
                        id = arr[(x * 16 + z) * 128 + y];
                    } else if (y == 0) {
                        id = Blocks.field_150357_h;
                    } else if (y < 71) {
                        id = stone_type;
                    } else if (y < 81) {
                        if (stalegmites) {
                            id = Blocks.field_150347_e;
                        } else {
                            id = stone_type;
                            stalegmites = this.r.nextInt(82 - y) == 0;
                        }
                    } else if (y >= 81 && y < 136) {
                        if (!stalegtites && y > 108 && y < 136) {
                            boolean bl = stalegtites = this.r.nextInt(1 + (136 - y) * (136 - y) * (136 - y)) == 0;
                        }
                        id = stalegtites || y == 81 || y == 82 && this.r.nextInt(8) == 0 || y == 135 || rs < 4.0f || (double)rs < 5.5 && this.r.nextBoolean() || this.r.nextDouble() < (double)(32 - (y - 81)) - 8.0 * Math.sqrt(rs) || this.r.nextDouble() < (double)(32 - (136 - y)) - 8.0 * Math.sqrt(rs) ? Blocks.field_150347_e : Blocks.field_150350_a;
                    } else {
                        id = y == 136 ? Blocks.field_150347_e : (y < 254 ? Blocks.field_150348_b : Blocks.field_150357_h);
                    }
                    if (id == null) {
                        id = Blocks.field_150350_a;
                    }
                    extendedblockstorage.func_150818_a(x, y & 0xF, z, id);
                    extendedblockstorage.func_76654_b(x, y & 0xF, z, 0);
                }
            }
        }
        chunk.func_76603_b();
        BiomeGenBase[] abiomegenbase = this.worldObj.func_72959_q().func_76933_b(null, par1 * 16, par2 * 16, 16, 16);
        byte[] abyte = chunk.func_76605_m();
        for (int k1 = 0; k1 < abyte.length; ++k1) {
            abyte[k1] = (byte)abiomegenbase[k1].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }
}

