/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.generator;

import com.rwtema.extrautils.dynamicgui.DynamicContainer;
import com.rwtema.extrautils.dynamicgui.WidgetEnergy;
import com.rwtema.extrautils.dynamicgui.WidgetSlot;
import com.rwtema.extrautils.dynamicgui.WidgetTank;
import com.rwtema.extrautils.dynamicgui.WidgetText;
import com.rwtema.extrautils.dynamicgui.WidgetTextData;
import com.rwtema.extrautils.tileentity.generator.BlockGenerator;
import com.rwtema.extrautils.tileentity.generator.TileEntityGenerator;
import com.rwtema.extrautils.tileentity.generator.TileEntityGeneratorFurnace;
import invtweaks.api.container.InventoryContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@InventoryContainer
public class DynamicContainerGenerator
extends DynamicContainer {
    TileEntityGenerator gen;
    public TileEntityGeneratorFurnace genFurnace = null;

    public DynamicContainerGenerator(IInventory player, TileEntityGenerator gen) {
        this.gen = gen;
        if (this.gen instanceof TileEntityGeneratorFurnace) {
            this.genFurnace = (TileEntityGeneratorFurnace)this.gen;
        }
        this.widgets.add(new WidgetText(5, 5, BlockGenerator.names[gen.func_145832_p()] + " Generator", 162));
        int x = 5;
        int y = 19;
        if (gen instanceof IInventory) {
            IInventory inv = (IInventory)gen;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                WidgetSlot widg = new WidgetSlot(inv, i, x, y);
                this.widgets.add(widg);
                x += widg.getW() + 5;
            }
        }
        if (gen instanceof IFluidHandler) {
            FluidTankInfo[] tanks;
            for (FluidTankInfo tank : tanks = gen.getTankInfo(null)) {
                WidgetTank widg = new WidgetTank(tank, x, y, 2);
                this.widgets.add(widg);
                x += widg.getW() + 5;
            }
        }
        WidgetTextCooldown w = new WidgetTextCooldown(gen, x, y, 120);
        this.widgets.add(w);
        this.widgets.add(new WidgetEnergy(gen, ForgeDirection.UP, x += w.getW() + 5, y));
        this.cropAndAddPlayerSlots(player);
        this.validate();
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public class WidgetTextCooldown
    extends WidgetTextData {
        TileEntityGenerator gen;

        public WidgetTextCooldown(TileEntityGenerator gen, int x, int y, int w) {
            super(x, y, w);
            this.gen = gen;
        }

        @Override
        public int getNumParams() {
            return 2;
        }

        @Override
        public Object[] getData() {
            return new Object[]{(long)(10.0 * this.gen.coolDown), (long)Math.ceil(10.0 * this.gen.genLevel() * (double)this.gen.getMultiplier())};
        }

        @Override
        public String getConstructedText() {
            double t2;
            double t;
            if (this.curData == null || this.curData[0] == null) {
                return "";
            }
            try {
                t = (double)((Long)this.curData[0]).longValue() / 200.0;
                t2 = (double)((Long)this.curData[1]).longValue() / 10.0;
            }
            catch (Exception e) {
                return "";
            }
            return this.gen.getBlurb(t, t2);
        }
    }
}

