/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.multipart.microblock;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.IMicroMaterialRender;
import codechicken.microblock.ISidedHollowConnect;
import codechicken.microblock.MicroMaterialRegistry;
import codechicken.microblock.MicroblockRender;
import codechicken.multipart.IconHitEffects;
import codechicken.multipart.JIconHitEffects;
import codechicken.multipart.JPartialOcclusion;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.rwtema.extrautils.multipart.microblock.IMicroBlock;
import com.rwtema.extrautils.multipart.microblock.ItemMicroBlock;
import com.rwtema.extrautils.multipart.microblock.PartMicroBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class PartPipeJacket
extends PartMicroBlock
implements JIconHitEffects,
IMicroMaterialRender,
IMicroBlock,
JPartialOcclusion {
    public static final String type = "extrautils:pipeJacket";
    public static Cuboid6[] axisCubes = null;
    public MicroMaterialRegistry.IMicroMaterial mat = null;
    public int connectionMask = 0;
    public double pipeSize = 0.3;
    public TMultiPart centerPart = null;
    int material;
    private MicroMaterialRegistry.IMicroMaterial wool;

    public PartPipeJacket() {
    }

    public PartPipeJacket(int material) {
        this.material = material;
    }

    @Override
    public void harvest(MovingObjectPosition hit, EntityPlayer player) {
        super.harvest(hit, player);
    }

    @Override
    public boolean occlusionTest(TMultiPart npart) {
        return !npart.getClass().equals(this.getClass());
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        packet.writeInt(this.material);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        this.material = packet.readInt();
    }

    @Override
    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74778_a("mat", MicroMaterialRegistry.materialName((int)this.material));
    }

    @Override
    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.material = MicroMaterialRegistry.materialID((String)tag.func_74779_i("mat"));
    }

    @Override
    public String getType() {
        return type;
    }

    public Cuboid6 getBounds() {
        return new Cuboid6(0.5 - this.pipeSize, 0.5 - this.pipeSize, 0.5 - this.pipeSize, 0.5 + this.pipeSize, 0.5 + this.pipeSize, 0.5 + this.pipeSize);
    }

    @Override
    public Iterable<Cuboid6> getCollisionBoxes() {
        ArrayList<Cuboid6> boxes = new ArrayList<Cuboid6>();
        if (this.isEthereal()) {
            return boxes;
        }
        boxes.add(this.getRenderBounds());
        for (int i = 0; i < 6; ++i) {
            if ((this.connectionMask & 1 << i) == 0) continue;
            boxes.add(new Cuboid6(0.5 - this.pipeSize, 0.5 + this.pipeSize, 0.5 - this.pipeSize, 0.5 + this.pipeSize, 1.0, 0.5 + this.pipeSize).apply(Rotation.sideRotations[Facing.field_71588_a[i]].at(new Vector3(0.5, 0.5, 0.5))));
        }
        return boxes;
    }

    @Override
    public ItemStack getItemDrop() {
        ItemStack item = new ItemStack((Item)ItemMicroBlock.instance, 1);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("mat", MicroMaterialRegistry.materialName((int)this.material));
        item.func_77982_d(tag);
        return item;
    }

    @Override
    public Iterable<ItemStack> getDrops() {
        return Arrays.asList(this.getItemDrop());
    }

    @Override
    public ItemStack pickItem(MovingObjectPosition hit) {
        return this.getItemDrop();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getBreakingIcon(Object subPart, int side) {
        return this.getBrokenIcon(side);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getBrokenIcon(int side) {
        if (this.mat != null) {
            return this.mat.getBreakingIcon(side);
        }
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHitEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addHitEffects((JIconHitEffects)this, (MovingObjectPosition)hit, (EffectRenderer)effectRenderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDestroyEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addDestroyEffects((JIconHitEffects)this, (EffectRenderer)effectRenderer, (boolean)false);
    }

    @Override
    public Cuboid6 getRenderBounds() {
        return this.getBounds();
    }

    @Override
    public int getLightValue() {
        return MicroMaterialRegistry.getMaterial((int)this.material).getLightValue();
    }

    @Override
    public void onNeighborChanged() {
        if (!this.world().field_72995_K) {
            this.dropIfCantStay();
        } else {
            this.reloadShape();
        }
    }

    public boolean canStay() {
        return this.tile().partMap(6) != null;
    }

    public boolean dropIfCantStay() {
        if (!this.canStay()) {
            this.drop();
            return true;
        }
        this.reloadShape();
        return false;
    }

    @Override
    public void drop() {
        TileMultipart.dropItem((ItemStack)this.getItemDrop(), (World)this.world(), (Vector3)Vector3.fromTileEntityCenter((TileEntity)this.tile()));
        this.tile().remPart((TMultiPart)this);
    }

    @Override
    public void onPartChanged(TMultiPart part) {
        if (!this.world().field_72995_K) {
            this.dropIfCantStay();
        }
    }

    @Override
    public Iterable<IndexedCuboid6> getSubParts() {
        ArrayList<IndexedCuboid6> boxes = new ArrayList<IndexedCuboid6>();
        this.overEthereal = true;
        for (Cuboid6 cuboid6 : this.getCollisionBoxes()) {
            boxes.add(new IndexedCuboid6((Object)0, cuboid6));
        }
        this.overEthereal = false;
        return boxes;
    }

    @Override
    public void onWorldJoin() {
        this.reloadShape();
        super.onWorldJoin();
    }

    @Override
    public void reloadShape() {
        int prevMask = this.connectionMask;
        this.centerPart = this.tile().partMap(6);
        double prevSize = this.pipeSize;
        this.pipeSize = 0.26;
        this.connectionMask = 0;
        if (this.centerPart != null) {
            if (this.centerPart instanceof ISidedHollowConnect) {
                for (int side = 0; side < 6; ++side) {
                    this.pipeSize = Math.max(this.pipeSize, (double)((float)(((ISidedHollowConnect)this.centerPart).getHollowSize(side) + 1) / 32.0f));
                }
            }
            for (int i = 0; i < 6; ++i) {
                for (Cuboid6 cuboid6 : this.centerPart.getCollisionBoxes()) {
                    if (!cuboid6.intersects(new Cuboid6(this.pipeSize, 0.0, this.pipeSize, 1.0 - this.pipeSize, 0.01, 1.0 - this.pipeSize).apply(Rotation.sideRotations[i].at(new Vector3(0.5, 0.5, 0.5))))) continue;
                    this.connectionMask |= 1 << i;
                }
            }
        }
        if (prevMask != this.connectionMask || prevSize != this.pipeSize) {
            this.tile().notifyPartChange((TMultiPart)this);
            this.tile().markRender();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vector3 pos, int pass) {
        this.reloadShape();
        if (this.mat == null) {
            this.mat = MicroMaterialRegistry.getMaterial((int)this.material);
        }
        if (this.mat != null && this.mat.canRenderInPass(pass)) {
            MicroblockRender.renderCuboid((Vector3)new Vector3((double)this.x(), (double)this.y(), (double)this.z()), (MicroMaterialRegistry.IMicroMaterial)this.mat, (int)pass, (Cuboid6)this.getRenderBounds(), (int)this.connectionMask);
            for (int i = 0; i < 6; ++i) {
                if ((this.connectionMask & 1 << i) == 0) continue;
                MicroblockRender.renderCuboid((Vector3)new Vector3((double)this.x(), (double)this.y(), (double)this.z()), (MicroMaterialRegistry.IMicroMaterial)this.mat, (int)pass, (Cuboid6)new Cuboid6(0.5 - this.pipeSize, 0.5 + this.pipeSize, 0.5 - this.pipeSize, 0.5 + this.pipeSize, 1.0, 0.5 + this.pipeSize).apply(Rotation.sideRotations[Facing.field_71588_a[i]].at(new Vector3(0.5, 0.5, 0.5))), (int)(1 << Facing.field_71588_a[i]));
            }
            return true;
        }
        return false;
    }

    @Override
    public void render(Vector3 pos, int pass) {
    }

    @Override
    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        return this.getMaterial().getStrength(player) * 4.0f;
    }

    @Override
    public int getMetadata() {
        return 0;
    }

    @Override
    public TMultiPart newPart(boolean client) {
        return new PartPipeJacket();
    }

    @Override
    public TMultiPart placePart(ItemStack stack, EntityPlayer player, World world, BlockCoord pos, int side, Vector3 arg5, int materialID) {
        TileMultipart tile = TileMultipart.getOrConvertTile((World)world, (BlockCoord)new BlockCoord(pos.x, pos.y, pos.z));
        if (tile == null) {
            return null;
        }
        TMultiPart part = tile.partMap(6);
        if (part != null) {
            return new PartPipeJacket(materialID);
        }
        return null;
    }

    @Override
    public void registerPassThroughs() {
    }

    @Override
    public void renderItem(ItemStack item, MicroMaterialRegistry.IMicroMaterial material) {
        if (this.wool == null) {
            this.wool = MicroMaterialRegistry.getMaterial((String)Blocks.field_150325_L.func_149739_a());
        }
        MicroblockRender.renderCuboid((Vector3)new Vector3(0.0, 0.0, 0.0), (MicroMaterialRegistry.IMicroMaterial)this.wool, (int)-1, (Cuboid6)new Cuboid6(0.1995, 0.4, 0.4, 0.8005, 0.6, 0.6), (int)15);
        MicroblockRender.renderCuboid((Vector3)new Vector3(0.0, 0.0, 0.0), (MicroMaterialRegistry.IMicroMaterial)material, (int)-1, (Cuboid6)new Cuboid6(0.2, 0.25, 0.25, 0.8, 0.75, 0.75), (int)0);
    }

    @Override
    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(new Object[0]);
    }

    public Iterable<Cuboid6> getPartialOcclusionBoxes() {
        return Arrays.asList(new Object[0]);
    }

    public boolean allowCompleteOcclusion() {
        return true;
    }
}

