/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import jds.bibliocraft.BiblioEnums;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.PaintingUtil;
import jds.bibliocraft.models.ModelPainting;
import jds.bibliocraft.tileentities.TileEntityPainting;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TileEntityPaintingRenderer
extends TileEntitySpecialRenderer {
    private ModelPainting model = new ModelPainting();
    private TileEntityPainting tile;
    private int angle = 0;
    private int style = 0;
    private int meta = 0;
    private int degreeAngle = 0;
    private boolean connectedTop = false;
    private boolean connectedLeft = false;
    private boolean connectedBottom = false;
    private boolean connectedRight = false;
    private boolean showTLCorner = true;
    private boolean showTRCorner = true;
    private boolean showBRCorner = true;
    private boolean showBLCorner = true;
    private int paintingMasterCorner = 0;
    private int paintingScale = 1;
    private int paintingAspectRatio = 0;
    private int paintingPixelRes = 0;
    private int paintingRotation = 0;
    private EntityPainting.EnumArt[] vanillaArtList = EntityPainting.EnumArt.values();
    private BiblioEnums.EnumBiblioPaintings[] biblioArtList = BiblioEnums.EnumBiblioPaintings.values();
    private int paintingType = 0;
    private String paintingTitle = "blank";
    public int customPaintingAspectX = 1;
    public int customPaintingAspectY = 1;
    private Tessellator tess = Tessellator.field_78398_a;

    public void func_147500_a(TileEntity tileEntity, double i, double j, double k, float tick) {
        this.tile = (TileEntityPainting)tileEntity;
        this.angle = this.tile.getAngle();
        this.style = this.tile.getFrameStyle();
        this.meta = this.tile.func_145832_p();
        this.paintingType = this.tile.getPaintingType();
        this.paintingTitle = this.tile.getPaintingTitle();
        this.connectedTop = this.tile.getConnectTop();
        this.connectedLeft = this.tile.getConnectLeft();
        this.connectedBottom = this.tile.getConnectBottom();
        this.connectedRight = this.tile.getConnectRight();
        this.paintingRotation = this.tile.getPaintingRotation();
        this.paintingMasterCorner = this.tile.getPaintingCorner();
        this.paintingScale = this.tile.getPaintingScale();
        this.paintingPixelRes = this.tile.getPaintingRes();
        this.paintingAspectRatio = this.tile.getPaintingAspectRatio();
        this.customPaintingAspectX = this.tile.getCustomPaintingAspectX();
        this.customPaintingAspectY = this.tile.getCustomPaintingAspectY();
        this.showTLCorner = this.tile.getShowTLCorner();
        this.showTRCorner = this.tile.getShowTRCorner();
        this.showBRCorner = this.tile.getShowBRCorner();
        this.showBLCorner = this.tile.getShowBLCorner();
        GL11.glPushMatrix();
        double adjusti = 0.0;
        double adjustk = 0.0;
        switch (this.angle) {
            case 0: {
                this.degreeAngle = 180;
                adjusti = 1.0;
                break;
            }
            case 1: {
                this.degreeAngle = 90;
                adjusti = 1.0;
                adjustk = 1.0;
                break;
            }
            case 2: {
                this.degreeAngle = 0;
                adjustk = 1.0;
                break;
            }
            case 3: {
                this.degreeAngle = -90;
                break;
            }
        }
        GL11.glTranslated((double)(i + adjusti), (double)j, (double)(k + adjustk));
        GL11.glRotatef((float)this.degreeAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)0.5, (double)-0.5);
        this.func_147499_a(this.getVanillaWoodTexture(this.meta));
        this.model.renderBack();
        if (!this.connectedTop) {
            if (this.connectedLeft && !this.connectedRight) {
                this.model.renderTop(this.style, 2);
            } else if (!this.connectedLeft && this.connectedRight) {
                this.model.renderTop(this.style, 1);
            } else if (this.connectedLeft && this.connectedRight) {
                this.model.renderTop(this.style, 0);
            } else {
                this.model.renderTop(this.style, 3);
            }
        }
        if (!this.connectedLeft) {
            if (this.connectedTop && !this.connectedBottom) {
                this.model.renderLeft(this.style, 2);
            } else if (!this.connectedTop && this.connectedBottom) {
                this.model.renderLeft(this.style, 1);
            } else if (this.connectedTop && this.connectedBottom) {
                this.model.renderLeft(this.style, 0);
            } else {
                this.model.renderLeft(this.style, 3);
            }
        }
        if (!this.connectedRight) {
            if (this.connectedTop && !this.connectedBottom) {
                this.model.renderRight(this.style, 2);
            } else if (!this.connectedTop && this.connectedBottom) {
                this.model.renderRight(this.style, 1);
            } else if (this.connectedTop && this.connectedBottom) {
                this.model.renderRight(this.style, 0);
            } else {
                this.model.renderRight(this.style, 3);
            }
        }
        if (!this.connectedBottom) {
            if (this.connectedLeft && !this.connectedRight) {
                this.model.renderBottom(this.style, 1);
            } else if (!this.connectedLeft && this.connectedRight) {
                this.model.renderBottom(this.style, 2);
            } else if (this.connectedLeft && this.connectedRight) {
                this.model.renderBottom(this.style, 0);
            } else {
                this.model.renderBottom(this.style, 3);
            }
        }
        if (this.showTLCorner && this.connectedLeft && this.connectedTop) {
            this.model.renderCorner(this.style, 1);
        }
        if (this.showTRCorner && this.connectedTop && this.connectedRight) {
            this.model.renderCorner(this.style, 2);
        }
        if (this.showBRCorner && this.connectedRight && this.connectedBottom) {
            this.model.renderCorner(this.style, 3);
        }
        if (this.showBLCorner && this.connectedBottom && this.connectedLeft) {
            this.model.renderCorner(this.style, 0);
        }
        this.model.renderWoodInner();
        if (this.tile.hasPainting()) {
            this.func_147499_a(CommonProxy.PAINTINGCANVAS);
            GL11.glRotatef((float)(-this.paintingRotation * 90), (float)1.0f, (float)0.0f, (float)0.0f);
            block6 : switch (this.paintingMasterCorner) {
                case 0: {
                    switch (this.paintingRotation) {
                        case 1: {
                            this.paintingMasterCorner = 3;
                            break;
                        }
                        case 2: {
                            this.paintingMasterCorner = 2;
                            break;
                        }
                        case 3: {
                            this.paintingMasterCorner = 1;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.paintingRotation) {
                        case 1: {
                            this.paintingMasterCorner = 0;
                            break;
                        }
                        case 2: {
                            this.paintingMasterCorner = 3;
                            break;
                        }
                        case 3: {
                            this.paintingMasterCorner = 2;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.paintingRotation) {
                        case 1: {
                            this.paintingMasterCorner = 1;
                            break;
                        }
                        case 2: {
                            this.paintingMasterCorner = 0;
                            break;
                        }
                        case 3: {
                            this.paintingMasterCorner = 3;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (this.paintingRotation) {
                        case 1: {
                            this.paintingMasterCorner = 2;
                            break block6;
                        }
                        case 2: {
                            this.paintingMasterCorner = 1;
                            break block6;
                        }
                        case 3: {
                            this.paintingMasterCorner = 0;
                        }
                    }
                }
            }
            switch (this.paintingType) {
                case 0: {
                    for (int x = 0; x < this.biblioArtList.length; ++x) {
                        if (!this.paintingTitle.contentEquals(this.biblioArtList[x].title)) continue;
                        this.func_147499_a(this.biblioArtList[x].paintingTextures[this.paintingAspectRatio][this.paintingPixelRes]);
                        switch (this.paintingMasterCorner) {
                            case 0: {
                                GL11.glTranslated((double)0.0, (double)(-0.5 + 0.5 * (double)this.biblioArtList[x].sizeY[this.paintingAspectRatio] * (double)this.paintingScale), (double)(0.5 - 0.5 * (double)this.biblioArtList[x].sizeX[this.paintingAspectRatio] * (double)this.paintingScale));
                                break;
                            }
                            case 1: {
                                GL11.glTranslated((double)0.0, (double)(0.5 - 0.5 * (double)this.biblioArtList[x].sizeY[this.paintingAspectRatio] * (double)this.paintingScale), (double)(0.5 - 0.5 * (double)this.biblioArtList[x].sizeX[this.paintingAspectRatio] * (double)this.paintingScale));
                                break;
                            }
                            case 2: {
                                GL11.glTranslated((double)0.0, (double)(0.5 - 0.5 * (double)this.biblioArtList[x].sizeY[this.paintingAspectRatio] * (double)this.paintingScale), (double)(-0.5 + 0.5 * (double)this.biblioArtList[x].sizeX[this.paintingAspectRatio] * (double)this.paintingScale));
                                break;
                            }
                            case 3: {
                                GL11.glTranslated((double)0.0, (double)(-0.5 + 0.5 * (double)this.biblioArtList[x].sizeY[this.paintingAspectRatio] * (double)this.paintingScale), (double)(-0.5 + 0.5 * (double)this.biblioArtList[x].sizeX[this.paintingAspectRatio] * (double)this.paintingScale));
                            }
                        }
                        GL11.glScaled((double)1.0, (double)(1.0 * (double)this.biblioArtList[x].sizeY[this.paintingAspectRatio] * (double)this.paintingScale), (double)(1.0 * (double)this.biblioArtList[x].sizeX[this.paintingAspectRatio] * (double)this.paintingScale));
                    }
                    break;
                }
                case 1: {
                    for (int x = 0; x < this.vanillaArtList.length; ++x) {
                        if (!this.paintingTitle.contentEquals(this.vanillaArtList[x].field_75702_A)) continue;
                        double aspectDiff = (double)this.vanillaArtList[x].field_75703_B * 1.0 / ((double)this.vanillaArtList[x].field_75704_C * 1.0);
                        switch (this.paintingMasterCorner) {
                            case 0: {
                                GL11.glTranslated((double)0.0, (double)(-0.5 + 0.5 * ((double)this.paintingScale * ((double)this.vanillaArtList[x].field_75704_C / 16.0))), (double)(0.5 - 0.5 * ((double)this.paintingScale * ((double)this.vanillaArtList[x].field_75703_B / 16.0))));
                                break;
                            }
                            case 1: {
                                GL11.glTranslated((double)0.0, (double)(0.5 - (double)this.vanillaArtList[x].field_75704_C / 16.0 * (double)this.paintingScale + 0.5 * ((double)this.paintingScale * ((double)this.vanillaArtList[x].field_75704_C / 16.0))), (double)(0.5 - 0.5 * ((double)this.paintingScale * ((double)this.vanillaArtList[x].field_75703_B / 16.0))));
                                break;
                            }
                            case 2: {
                                GL11.glTranslated((double)0.0, (double)(0.5 - (double)this.vanillaArtList[x].field_75704_C / 16.0 * (double)this.paintingScale + 0.5 * ((double)this.paintingScale * ((double)this.vanillaArtList[x].field_75704_C / 16.0))), (double)(-0.5 + (double)this.vanillaArtList[x].field_75703_B / 16.0 * (double)this.paintingScale - 0.5 * ((double)this.paintingScale * ((double)this.vanillaArtList[x].field_75703_B / 16.0))));
                                break;
                            }
                            case 3: {
                                GL11.glTranslated((double)0.0, (double)(-0.5 + 0.5 * ((double)this.paintingScale * ((double)this.vanillaArtList[x].field_75704_C / 16.0))), (double)(-0.5 + (double)this.vanillaArtList[x].field_75703_B / 16.0 * (double)this.paintingScale - 0.5 * ((double)this.paintingScale * ((double)this.vanillaArtList[x].field_75703_B / 16.0))));
                            }
                        }
                        GL11.glScaled((double)1.0, (double)(1.0 * ((double)this.paintingScale * ((double)this.vanillaArtList[x].field_75704_C / 16.0))), (double)(1.0 * ((double)this.paintingScale * ((double)this.vanillaArtList[x].field_75703_B / 16.0))));
                        this.func_147499_a(CommonProxy.PAINTINGSHEET);
                        this.renderVanillaPainting(x);
                    }
                    break;
                }
                case 2: {
                    boolean foundMatch = false;
                    if (PaintingUtil.customArtNames != null && PaintingUtil.customArtNames.length > 0 && PaintingUtil.customArtResources != null) {
                        for (int x = 0; x < PaintingUtil.customArtNames.length; ++x) {
                            if (!this.paintingTitle.contentEquals(PaintingUtil.customArtNames[x])) continue;
                            this.func_147499_a(PaintingUtil.customArtResources[x]);
                            switch (this.paintingMasterCorner) {
                                case 0: {
                                    GL11.glTranslated((double)0.0, (double)(-0.5 + 0.5 * (double)this.paintingScale * (double)this.customPaintingAspectY), (double)(0.5 - 0.5 * (double)this.paintingScale * (double)this.customPaintingAspectX));
                                    break;
                                }
                                case 1: {
                                    GL11.glTranslated((double)0.0, (double)(0.5 - 0.5 * (double)this.paintingScale * (double)this.customPaintingAspectY), (double)(0.5 - 0.5 * (double)this.paintingScale * (double)this.customPaintingAspectX));
                                    break;
                                }
                                case 2: {
                                    GL11.glTranslated((double)0.0, (double)(0.5 - 0.5 * (double)this.paintingScale * (double)this.customPaintingAspectY), (double)(-0.5 + 0.5 * (double)this.paintingScale * (double)this.customPaintingAspectX));
                                    break;
                                }
                                case 3: {
                                    GL11.glTranslated((double)0.0, (double)(-0.5 + 0.5 * (double)this.paintingScale * (double)this.customPaintingAspectY), (double)(-0.5 + 0.5 * (double)this.paintingScale * (double)this.customPaintingAspectX));
                                }
                            }
                            GL11.glScaled((double)1.0, (double)(1.0 * (double)this.paintingScale * (double)this.customPaintingAspectY), (double)(1.0 * (double)this.paintingScale * (double)this.customPaintingAspectX));
                            foundMatch = true;
                        }
                    }
                    if (foundMatch) break;
                    this.func_147499_a(CommonProxy.PAINTINGNOTFOUND);
                    break;
                }
            }
            if (!(this.connectedBottom || this.connectedLeft || this.connectedRight || this.connectedTop || this.style == 4 || this.paintingType == 1 || this.paintingScale != 1 || this.paintingAspectRatio != 0)) {
                this.model.renderCanvas();
            } else if (this.paintingType != 1) {
                this.model.renderLargeCanvas();
            }
        }
        GL11.glPopMatrix();
    }

    private void renderVanillaPainting(int x) {
        GL11.glDisable((int)2896);
        float x1 = (float)this.vanillaArtList[x].field_75699_D / 256.0f;
        float x2 = (float)(this.vanillaArtList[x].field_75699_D + this.vanillaArtList[x].field_75703_B) / 256.0f;
        float y1 = (float)this.vanillaArtList[x].field_75700_E / 256.0f;
        float y2 = (float)(this.vanillaArtList[x].field_75700_E + this.vanillaArtList[x].field_75704_C) / 256.0f;
        this.tess.func_78382_b();
        this.tess.func_78374_a(0.035, -0.5, -0.5, (double)x2, (double)y2);
        this.tess.func_78374_a(0.035, 0.5, -0.5, (double)x2, (double)y1);
        this.tess.func_78374_a(0.035, 0.5, 0.5, (double)x1, (double)y1);
        this.tess.func_78374_a(0.035, -0.5, 0.5, (double)x1, (double)y2);
        this.tess.func_78381_a();
        GL11.glEnable((int)2896);
    }

    public ResourceLocation getVanillaWoodTexture(int meta) {
        switch (meta) {
            case 0: {
                return CommonProxy.PLANKSOAK;
            }
            case 1: {
                return CommonProxy.PLANKSSPRUCE;
            }
            case 2: {
                return CommonProxy.PLANKSBIRCH;
            }
            case 3: {
                return CommonProxy.PLANKSJUNGLE;
            }
            case 4: {
                return CommonProxy.PLANKSACACIA;
            }
            case 5: {
                return CommonProxy.PLANKSOLDOAK;
            }
        }
        return CommonProxy.PLANKSOAK;
    }
}

