/*
 * Decompiled with CFR 0.152.
 */
package openblocks.integration;

import com.google.common.base.Preconditions;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.lang.ref.WeakReference;
import net.minecraft.entity.Entity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.Config;
import openblocks.common.entity.EntityMagnet;
import openblocks.integration.ITickingTurtle;
import openperipheral.api.Alias;
import openperipheral.api.Arg;
import openperipheral.api.IMultiReturn;
import openperipheral.api.IWorldProvider;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaReturnType;
import openperipheral.api.MultiReturn;
import openperipheral.api.PeripheralTypeId;

@PeripheralTypeId(value="openblocks_magnet")
public class MagnetControlAdapter
implements ITickingTurtle,
IWorldProvider {
    private final TurtleSide side;
    private final ITurtleAccess turtle;
    private WeakReference<EntityMagnet> magnet = new WeakReference<Object>(null);
    private Owner magnetOwner;
    private int fuelTick = 0;

    public MagnetControlAdapter(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = turtle;
        this.side = side;
    }

    public World getWorld() {
        return this.turtle.getWorld();
    }

    protected boolean consumeFuel(int amount) {
        return this.turtle.consumeFuel(amount);
    }

    protected SpawnSide getSpawnSide() {
        switch (this.side) {
            case Left: {
                return SpawnSide.Left;
            }
        }
        return SpawnSide.Right;
    }

    protected ForgeDirection getTurtleFacing() {
        return ForgeDirection.getOrientation((int)this.turtle.getDirection());
    }

    protected Vec3 getTurtlePosition() {
        ChunkCoordinates coord = this.turtle.getPosition();
        return Vec3.func_72443_a((double)coord.field_71574_a, (double)coord.field_71572_b, (double)coord.field_71573_c);
    }

    @LuaCallable(description="Activate magnet")
    public void activate() {
        EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
        Preconditions.checkState((magnet == null || magnet.field_70128_L ? 1 : 0) != 0, (Object)"Magnet already active");
        World world = this.getWorld();
        Preconditions.checkNotNull((Object)world, (Object)"Trying to spawn magnet, but turtle is unloaded");
        Preconditions.checkState((boolean)this.canSpawn(world), (Object)"Can't deploy magnet");
        Preconditions.checkState((boolean)this.consumeFuel(5), (Object)"No fuel");
        this.magnetOwner = new Owner();
        ((Owner)this.magnetOwner).target.field_72449_c = this.getSpawnSide() == SpawnSide.Left ? -1.0 : 1.0;
        magnet = new EntityMagnet(world, this.magnetOwner, true);
        world.func_72838_d((Entity)magnet);
        magnet.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        this.magnet = new WeakReference<EntityMagnet>(magnet);
    }

    @LuaCallable(description="Deactive magnet")
    public void deactivate() {
        this.despawnMagnet(true);
    }

    @LuaCallable(description="Set target for magnet")
    public void setTarget(@Arg(name="x") double x, @Arg(name="y") double y, @Arg(name="z") double z) {
        Preconditions.checkNotNull((Object)this.magnetOwner, (Object)"Magnet not active");
        Preconditions.checkArgument((boolean)MagnetControlAdapter.checkTargetRange(x, y, z), (Object)"Target out of range");
        this.magnetOwner.setTarget(x, y, z);
    }

    @LuaCallable(returnTypes={LuaReturnType.NUMBER, LuaReturnType.NUMBER, LuaReturnType.NUMBER}, description="Get turtle position")
    public IMultiReturn getPosition() {
        EntityMagnet magnet = this.getMagnet();
        Vec3 rotated = this.getRelativeDistance(magnet);
        return MultiReturn.wrap((Object[])new Object[]{rotated.field_72450_a, rotated.field_72448_b, rotated.field_72449_c});
    }

    @LuaCallable(returnTypes={LuaReturnType.BOOLEAN}, description="Is magnet above grabbable entity")
    public boolean isAboveEntity() {
        return this.getMagnet().isAboveTarget();
    }

    @Alias(value={"toggle"})
    @LuaCallable(returnTypes={LuaReturnType.BOOLEAN}, description="Grab or release entity/block under magnet")
    public boolean toggleMagnet() {
        return this.getMagnet().toggleMagnet();
    }

    @LuaCallable(returnTypes={LuaReturnType.BOOLEAN}, description="Is magnet currently grabbing block or entity")
    public boolean isGrabbing() {
        return this.getMagnet().isLocked();
    }

    @Alias(value={"distance"})
    @LuaCallable(returnTypes={LuaReturnType.NUMBER, LuaReturnType.NUMBER, LuaReturnType.NUMBER})
    public IMultiReturn getDistanceToTarget() {
        EntityMagnet magnet = this.getMagnet();
        Vec3 current = this.getRelativeDistance(magnet);
        Vec3 target = this.magnetOwner.target;
        return MultiReturn.wrap((Object[])new Object[]{current.field_72450_a - target.field_72450_a, current.field_72448_b - target.field_72448_b, current.field_72449_c - target.field_72449_c});
    }

    @Override
    public void onPeripheralTick() {
        EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
        if (magnet != null && !magnet.field_70128_L && ++this.fuelTick >= 20) {
            int fuel;
            this.fuelTick = 0;
            int n = fuel = magnet.isLocked() ? 2 : 1;
            if (!this.consumeFuel(fuel)) {
                this.despawnMagnet(false);
            }
        }
    }

    private static boolean checkTargetRange(double x, double y, double z) {
        return Math.abs(x) <= Config.turtleMagnetRange && Math.abs(y) <= Config.turtleMagnetRange && Math.abs(z) <= Config.turtleMagnetRange;
    }

    private Vec3 getRelativeDistance(EntityMagnet magnet) {
        Vec3 magnetPos = Vec3.func_72443_a((double)magnet.field_70165_t, (double)magnet.field_70163_u, (double)magnet.field_70161_v);
        Vec3 turtlePos = this.getTurtlePosition().func_72441_c(0.5, 0.5, 0.5);
        Vec3 dist = turtlePos.func_72444_a(magnetPos);
        ForgeDirection side = this.getTurtleFacing();
        switch (side) {
            case NORTH: {
                return Vec3.func_72443_a((double)(-dist.field_72449_c), (double)dist.field_72448_b, (double)dist.field_72450_a);
            }
            case SOUTH: {
                return Vec3.func_72443_a((double)dist.field_72449_c, (double)dist.field_72448_b, (double)(-dist.field_72450_a));
            }
            case EAST: {
                return Vec3.func_72443_a((double)dist.field_72450_a, (double)dist.field_72448_b, (double)dist.field_72449_c);
            }
            case WEST: {
                return Vec3.func_72443_a((double)(-dist.field_72450_a), (double)dist.field_72448_b, (double)(-dist.field_72449_c));
            }
        }
        return dist;
    }

    private boolean canSpawn(World world) {
        ForgeDirection facing = this.getTurtleFacing();
        Vec3 position = this.getTurtlePosition();
        SpawnSide side = this.getSpawnSide();
        ForgeDirection spawnSide = facing.getRotation(side == SpawnSide.Left ? ForgeDirection.DOWN : ForgeDirection.UP);
        int x = MathHelper.func_76128_c((double)position.field_72450_a) + spawnSide.offsetX;
        int y = MathHelper.func_76128_c((double)position.field_72448_b) + spawnSide.offsetY;
        int z = MathHelper.func_76128_c((double)position.field_72449_c) + spawnSide.offsetZ;
        return world.func_147437_c(x, y, z);
    }

    private EntityMagnet getMagnet() {
        EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
        Preconditions.checkState((magnet != null && !magnet.field_70128_L ? 1 : 0) != 0, (Object)"Magnet not active");
        return magnet;
    }

    private void despawnMagnet(boolean checkPosition) {
        EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
        Preconditions.checkNotNull((Object)((Object)magnet), (Object)"Magnet not active");
        Vec3 magnetPos = Vec3.func_72443_a((double)magnet.field_70165_t, (double)magnet.field_70163_u, (double)magnet.field_70161_v);
        Vec3 turtlePos = this.getTurtlePosition().func_72441_c(0.5, 0.5, 0.5);
        Preconditions.checkState((!checkPosition || MagnetControlAdapter.canOperateOnMagnet(magnetPos, turtlePos) ? 1 : 0) != 0, (Object)"Magnet too far");
        magnet.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        magnet.func_70106_y();
        this.magnet.clear();
        this.magnetOwner = null;
    }

    private static boolean canOperateOnMagnet(Vec3 magnetPos, Vec3 turtlePos) {
        return magnetPos.func_72436_e(turtlePos) <= Config.turtleMagnetRangeDeactivate * Config.turtleMagnetRangeDeactivate;
    }

    public boolean isValid() {
        EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
        return magnet != null && magnet.field_70175_ag;
    }

    public static enum SpawnSide {
        Left,
        Right;

    }

    public class Owner
    implements EntityMagnet.IOwner {
        private final Vec3 target = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);

        public synchronized void setTarget(double x, double y, double z) {
            this.target.field_72450_a = x;
            this.target.field_72448_b = y;
            this.target.field_72449_c = z;
        }

        public synchronized Vec3 getTarget(Vec3 pos, ForgeDirection side) {
            pos.field_72448_b += this.target.field_72448_b;
            switch (side) {
                case NORTH: {
                    pos.field_72450_a += this.target.field_72449_c;
                    pos.field_72449_c -= this.target.field_72450_a;
                    break;
                }
                case SOUTH: {
                    pos.field_72450_a -= this.target.field_72449_c;
                    pos.field_72449_c += this.target.field_72450_a;
                    break;
                }
                case WEST: {
                    pos.field_72450_a -= this.target.field_72450_a;
                    pos.field_72449_c -= this.target.field_72449_c;
                    break;
                }
                case EAST: {
                    pos.field_72450_a += this.target.field_72450_a;
                    pos.field_72449_c += this.target.field_72449_c;
                    break;
                }
            }
            return pos.func_72441_c(0.5, 0.5, 0.5);
        }

        @Override
        public boolean isValid(EntityMagnet magnet) {
            return MagnetControlAdapter.this.turtle != null && MagnetControlAdapter.this.turtle.getWorld() != null;
        }

        @Override
        public Vec3 getTarget() {
            return this.getTarget(MagnetControlAdapter.this.getTurtlePosition(), MagnetControlAdapter.this.getTurtleFacing());
        }
    }
}

