/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiPaintMixer;
import openblocks.common.container.ContainerPaintMixer;
import openblocks.common.item.ItemPaintCan;
import openblocks.rpc.IColorChanger;
import openmods.api.IHasGui;
import openmods.api.IInventoryCallback;
import openmods.api.IValueProvider;
import openmods.gamelogic.WorkerLogic;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableFloat;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.ColorUtils;
import openmods.utils.MiscUtils;
import org.apache.commons.lang3.ArrayUtils;

public class TileEntityPaintMixer
extends SyncedTileEntity
implements IInventoryProvider,
IHasGui,
IInventoryCallback,
IExtendable,
IColorChanger {
    private static final ItemStack PAINT_CAN = new ItemStack((Block)OpenBlocks.Blocks.paintCan);
    private static final ItemStack MILK_BUCKET = new ItemStack(Items.field_151117_aB);
    public static final int PROGRESS_TICKS = 300;
    private static EnumMap<Slots, Integer> ALLOWED_COLORS = Maps.newEnumMap(Slots.class);
    private SyncableInt canColor;
    private SyncableInt color;
    private SyncableInt progress;
    private SyncableFlags flags;
    private final WorkerLogic logic;
    public SyncableFloat lvlCyan;
    public SyncableFloat lvlMagenta;
    public SyncableFloat lvlYellow;
    public SyncableFloat lvlBlack;
    private GenericInventory inventory;

    public TileEntityPaintMixer() {
        this.logic = new WorkerLogic(this.progress, 300);
        this.inventory = new GenericInventory("paintmixer", true, 6){

            public boolean func_94041_b(int slotId, ItemStack stack) {
                Slots[] values = Slots.values();
                if (stack == null || slotId < 0 || slotId > values.length) {
                    return false;
                }
                Slots slot = values[slotId];
                if (slot == Slots.paint) {
                    return PAINT_CAN.func_77969_a(stack) || MILK_BUCKET.func_77969_a(stack);
                }
                return TileEntityPaintMixer.isValidForSlot(slot, stack);
            }
        };
        this.inventory.addCallback((IInventoryCallback)this);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.logic.isWorking()) {
                if (!this.hasValidInput() || !this.hasSufficientInk()) {
                    this.logic.reset();
                } else if (this.logic.update()) {
                    this.consumeInk();
                    ItemStack output = ItemPaintCan.createStack(this.color.get(), 30);
                    this.inventory.func_70299_a(Slots.paint.ordinal(), output);
                    this.canColor.set(this.color.get());
                }
            }
            this.checkAutoConsumption();
            this.sync();
        }
    }

    private void checkAutoConsumption() {
        if (this.lvlCyan.get() <= 1.0f && this.tryUseInk(Slots.dyeCyan, 1)) {
            this.lvlCyan.set(this.lvlCyan.get() + 1.0f);
        }
        if (this.lvlMagenta.get() <= 1.0f && this.tryUseInk(Slots.dyeMagenta, 1)) {
            this.lvlMagenta.set(this.lvlMagenta.get() + 1.0f);
        }
        if (this.lvlYellow.get() <= 1.0f && this.tryUseInk(Slots.dyeYellow, 1)) {
            this.lvlYellow.set(this.lvlYellow.get() + 1.0f);
        }
        if (this.lvlBlack.get() <= 1.0f && this.tryUseInk(Slots.dyeBlack, 1)) {
            this.lvlBlack.set(this.lvlBlack.get() + 1.0f);
        }
    }

    private void consumeInk() {
        ColorUtils.CYMK cymk = new ColorUtils.RGB(this.color.get()).toCYMK();
        this.lvlCyan.set(this.lvlCyan.get() - cymk.getCyan());
        this.lvlBlack.set(this.lvlBlack.get() - cymk.getKey());
        this.lvlYellow.set(this.lvlYellow.get() - cymk.getYellow());
        this.lvlMagenta.set(this.lvlMagenta.get() - cymk.getMagenta());
    }

    private boolean hasSufficientInk() {
        ColorUtils.CYMK cymk = new ColorUtils.RGB(this.color.get()).toCYMK();
        if (cymk.getCyan() > this.lvlCyan.get()) {
            if (this.tryUseInk(Slots.dyeCyan, 1)) {
                this.lvlCyan.set(this.lvlCyan.get() + 1.0f);
            } else {
                return false;
            }
        }
        if (cymk.getYellow() > this.lvlYellow.get()) {
            if (this.tryUseInk(Slots.dyeYellow, 1)) {
                this.lvlYellow.set(this.lvlYellow.get() + 1.0f);
            } else {
                return false;
            }
        }
        if (cymk.getMagenta() > this.lvlMagenta.get()) {
            if (this.tryUseInk(Slots.dyeMagenta, 1)) {
                this.lvlMagenta.set(this.lvlMagenta.get() + 1.0f);
            } else {
                return false;
            }
        }
        if (cymk.getKey() > this.lvlBlack.get()) {
            if (this.tryUseInk(Slots.dyeBlack, 1)) {
                this.lvlBlack.set(this.lvlBlack.get() + 1.0f);
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean tryUseInk(Slots slot, int consume) {
        ItemStack stack = this.inventory.getStackInSlot((Enum)slot);
        return TileEntityPaintMixer.isValidForSlot(slot, stack) && this.inventory.func_70298_a(slot.ordinal(), consume) != null;
    }

    private static boolean isValidForSlot(Slots slot, ItemStack stack) {
        Integer allowedColor = ALLOWED_COLORS.get((Object)slot);
        if (allowedColor == null || stack == null) {
            return false;
        }
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)stack);
        return ArrayUtils.contains((int[])oreIds, (int)allowedColor);
    }

    protected void createSyncedFields() {
        this.color = new SyncableInt(0xFF0000);
        this.flags = SyncableFlags.create((int)Flags.values().length);
        this.progress = new SyncableInt();
        this.lvlBlack = new SyncableFloat();
        this.lvlCyan = new SyncableFloat();
        this.lvlMagenta = new SyncableFloat();
        this.lvlYellow = new SyncableFloat();
        this.canColor = new SyncableInt(0xFFFFFF);
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerPaintMixer((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiPaintMixer(new ContainerPaintMixer((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    @Override
    public void changeColor(int requestedColor) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.logic.isWorking()) {
                if (requestedColor != this.color.get()) {
                    this.logic.reset();
                } else {
                    return;
                }
            }
            this.color.set(requestedColor);
            this.logic.start();
        }
    }

    public IValueProvider<Integer> getProgress() {
        return this.progress;
    }

    public IValueProvider<Integer> getColor() {
        return this.color;
    }

    public IValueProvider<Float> getDyeSlot(DyeSlot slot) {
        switch (slot) {
            case black: {
                return this.lvlBlack;
            }
            case cyan: {
                return this.lvlCyan;
            }
            case magenta: {
                return this.lvlMagenta;
            }
            case yellow: {
                return this.lvlYellow;
            }
        }
        throw MiscUtils.unhandledEnum((Enum)slot);
    }

    public boolean hasPaint() {
        return this.flags.get((Enum)Flags.hasPaint);
    }

    public int getCanColor() {
        return this.canColor.get();
    }

    public boolean isEnabled() {
        return this.progress.get() > 0;
    }

    public boolean hasValidInput() {
        return this.hasStack(Slots.paint, PAINT_CAN) || this.hasStack(Slots.paint, MILK_BUCKET);
    }

    private static Integer getColor(ItemStack stack, boolean canColor) {
        if (stack.func_77969_a(PAINT_CAN)) {
            return ItemPaintCan.getColorFromStack(stack);
        }
        if (canColor && stack.func_77969_a(MILK_BUCKET)) {
            return 0xFFFFFF;
        }
        return null;
    }

    public void onInventoryChanged(IInventory invent, int slotNumber) {
        if (!this.field_145850_b.field_72995_K) {
            boolean hasPaint = false;
            ItemStack can = this.inventory.getStackInSlot((Enum)Slots.paint);
            if (can != null) {
                Integer canColor;
                Integer pickerColor = TileEntityPaintMixer.getColor(can, false);
                if (pickerColor != null && !this.logic.isWorking()) {
                    this.color.set(pickerColor.intValue());
                    this.color.markDirty();
                }
                if ((canColor = TileEntityPaintMixer.getColor(can, true)) != null) {
                    this.canColor.set(canColor.intValue());
                    hasPaint = true;
                }
            }
            this.flags.set((Enum)Flags.hasPaint, hasPaint);
            this.sync();
            this.markUpdated();
        }
    }

    private boolean hasStack(Slots slot, ItemStack stack) {
        ItemStack gotStack = this.inventory.getStackInSlot((Enum)slot);
        if (gotStack == null) {
            return false;
        }
        return gotStack.func_77969_a(stack);
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public IColorChanger createRpcProxy() {
        return (IColorChanger)this.createClientRpcProxy(IColorChanger.class, new Class[0]);
    }

    static {
        ALLOWED_COLORS.put(Slots.dyeBlack, OreDictionary.getOreID((String)"dyeBlack"));
        ALLOWED_COLORS.put(Slots.dyeCyan, OreDictionary.getOreID((String)"dyeCyan"));
        ALLOWED_COLORS.put(Slots.dyeMagenta, OreDictionary.getOreID((String)"dyeMagenta"));
        ALLOWED_COLORS.put(Slots.dyeYellow, OreDictionary.getOreID((String)"dyeYellow"));
    }

    public static enum Flags {
        hasPaint;

    }

    public static enum DyeSlot {
        cyan,
        magenta,
        yellow,
        black;

    }

    public static enum Slots {
        paint,
        reserved,
        dyeCyan,
        dyeMagenta,
        dyeYellow,
        dyeBlack;

    }
}

