/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.Config;
import openblocks.shapes.GuideShape;
import openmods.api.IActivateAwareTile;
import openmods.api.INeighbourAwareTile;
import openmods.shapes.IShapeable;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableBoolean;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.CollectionUtils;
import openmods.utils.ColorUtils;
import openmods.utils.Coord;

public class TileEntityGuide
extends SyncedTileEntity
implements IShapeable,
IActivateAwareTile,
ISyncListener,
INeighbourAwareTile {
    private Set<Coord> shape;
    private Set<Coord> previousShape;
    private float timeSinceChange = 0.0f;
    protected SyncableInt width;
    protected SyncableInt height;
    protected SyncableInt depth;
    protected SyncableInt mode;
    protected SyncableInt color;
    protected SyncableBoolean active;

    public TileEntityGuide() {
        this.syncMap.addUpdateListener((ISyncListener)this);
    }

    protected void createSyncedFields() {
        this.width = new SyncableInt(8);
        this.height = new SyncableInt(8);
        this.depth = new SyncableInt(8);
        this.mode = new SyncableInt(0);
        this.color = new SyncableInt(0xFFFFFF);
        this.active = new SyncableBoolean();
    }

    public int getWidth() {
        return this.width.get();
    }

    public int getHeight() {
        return this.height.get();
    }

    public int getDepth() {
        return this.depth.get();
    }

    public int getColor() {
        return this.color.get();
    }

    public void setWidth(int w) {
        this.width.set(w);
    }

    public void setDepth(int d) {
        this.depth.set(d);
    }

    public void setHeight(int h) {
        this.height.set(h);
    }

    public GuideShape getCurrentMode() {
        return GuideShape.values()[this.mode.get()];
    }

    public boolean shouldRender() {
        return Config.guideRedstone == 0 || Config.guideRedstone < 0 ^ this.active.get();
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K && (double)this.timeSinceChange < 1.0) {
            this.timeSinceChange = (float)Math.min(1.0, (double)this.timeSinceChange + 0.1);
        }
    }

    public float getTimeSinceChange() {
        return this.timeSinceChange;
    }

    private void recreateShape() {
        this.previousShape = this.shape;
        this.shape = Sets.newHashSet();
        this.getCurrentMode().generator.generateShape(this.getWidth(), this.getHeight(), this.getDepth(), (IShapeable)this);
    }

    public void setBlock(int x, int y, int z) {
        this.shape.add(new Coord(x, y, z));
    }

    public Set<Coord> getShape() {
        return this.shape;
    }

    public Set<Coord> getPreviousShape() {
        return this.previousShape;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB box = super.getRenderBoundingBox();
        return box.func_72314_b((double)this.getWidth(), (double)this.getHeight(), (double)this.getDepth());
    }

    private void switchMode(EntityPlayer player) {
        this.switchMode();
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("openblocks.misc.change_mode", new Object[]{this.getCurrentMode().getLocalizedName()}));
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("openblocks.misc.total_blocks", new Object[]{this.shape.size()}));
    }

    private void switchMode() {
        int nextMode = this.mode.get() + 1;
        if (nextMode >= GuideShape.values().length) {
            nextMode = 0;
        }
        this.mode.set(nextMode);
        if (this.getCurrentMode().fixedRatio) {
            this.setHeight(this.getWidth());
            this.setDepth(this.getWidth());
        }
        this.recreateShape();
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    private void changeDimensions(EntityPlayer player, ForgeDirection orientation) {
        this.changeDimensions(orientation);
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("openblocks.misc.change_size", new Object[]{this.width.get(), this.height.get(), this.depth.get()}));
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("openblocks.misc.total_blocks", new Object[]{this.shape.size()}));
    }

    private static void inc(SyncableInt v) {
        v.modify(1);
    }

    private static void dec(SyncableInt v) {
        if (v.get() > 0) {
            v.modify(-1);
        }
    }

    private void changeDimensions(ForgeDirection orientation) {
        switch (orientation) {
            case EAST: {
                TileEntityGuide.dec(this.width);
                break;
            }
            case WEST: {
                TileEntityGuide.inc(this.width);
                break;
            }
            case SOUTH: {
                TileEntityGuide.dec(this.depth);
                break;
            }
            case NORTH: {
                TileEntityGuide.inc(this.depth);
                break;
            }
            case DOWN: {
                TileEntityGuide.dec(this.height);
                break;
            }
            case UP: {
                TileEntityGuide.inc(this.height);
                break;
            }
            default: {
                return;
            }
        }
        if (this.getCurrentMode().fixedRatio) {
            int h = this.getHeight();
            int w = this.getWidth();
            int d = this.getDepth();
            if (w != h && w != d) {
                this.setHeight(w);
                this.setDepth(w);
            } else if (h != w && h != d) {
                this.depth.set(h);
                this.width.set(h);
            } else if (d != w && d != h) {
                this.width.set(d);
                this.height.set(d);
            }
        }
        this.recreateShape();
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    public void onSync(Set<ISyncableObject> changes) {
        if (changes.contains(this.depth) || changes.contains(this.height) || changes.contains(this.width) || changes.contains(this.mode)) {
            this.recreateShape();
            this.timeSinceChange = 0.0f;
        }
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            this.switchMode(player);
        } else {
            ItemStack heldStack = player.func_70694_bm();
            if (heldStack == null || !this.tryUseItem(player, heldStack)) {
                this.changeDimensions(player, ForgeDirection.getOrientation((int)side));
            }
        }
        return true;
    }

    protected boolean tryUseItem(EntityPlayer player, ItemStack heldStack) {
        Item heldItem;
        if (player.field_71075_bZ.field_75098_d && this.isInFillMode() && (heldItem = heldStack.func_77973_b()) instanceof ItemBlock) {
            this.replaceBlocks(heldStack, heldItem);
            return true;
        }
        Set colors = ColorUtils.stackToColor((ItemStack)heldStack);
        if (!colors.isEmpty()) {
            ColorUtils.ColorMeta selected = (ColorUtils.ColorMeta)CollectionUtils.getRandom((Collection)colors);
            this.changeColor(selected.rgb);
            return true;
        }
        return false;
    }

    protected void replaceBlocks(ItemStack heldStack, Item heldItem) {
        if (this.shape == null) {
            this.recreateShape();
        }
        ItemBlock itemBlock = (ItemBlock)heldItem;
        Block block = itemBlock.field_150939_a;
        int blockMeta = itemBlock.func_77647_b(heldStack.func_77960_j());
        for (Coord coord : this.shape) {
            this.field_145850_b.func_147465_d(this.field_145851_c + coord.x, this.field_145848_d + coord.y, this.field_145849_e + coord.z, block, blockMeta, 3);
        }
    }

    protected void changeColor(int color) {
        this.color.set(color);
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    private boolean isInFillMode() {
        return this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == Blocks.field_150343_Z;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void onNeighbourChanged(Block block) {
        if (Config.guideRedstone != 0) {
            boolean redstoneState = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.active.set(redstoneState);
            this.sync();
        }
    }
}

