/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import openmods.api.INeighbourAwareTile;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.sync.SyncableBoolean;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;
import openmods.utils.InventoryUtils;

public class TileEntityBlockBreaker
extends SyncedTileEntity
implements INeighbourAwareTile,
IExtendable,
IInventoryProvider {
    private static final int SLOT_BUFFER = 0;
    private int redstoneAnimTimer;
    private SyncableBoolean activated;
    private final GenericInventory inventory = this.registerInventoryCallback(new GenericInventory("blockbreaker", true, 1){

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return false;
        }
    });

    public TileEntityBlockBreaker() {
        this.syncMap.addUpdateListener(this.createRenderUpdateListener());
    }

    protected void createSyncedFields() {
        this.activated = new SyncableBoolean(false);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isActivated() {
        return this.activated.get();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.activated.get()) {
            if (this.redstoneAnimTimer <= 0) {
                this.activated.set(false);
                this.sync();
            } else {
                --this.redstoneAnimTimer;
            }
        }
    }

    private void setRedstoneSignal(boolean redstoneSignal) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (redstoneSignal && !this.activated.get()) {
            this.redstoneAnimTimer = 5;
            this.activated.set(true);
            this.sync();
            this.breakBlock();
        }
    }

    private void breakBlock() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ForgeDirection direction = this.getRotation();
        int x = this.field_145851_c + direction.offsetX;
        int y = this.field_145848_d + direction.offsetY;
        int z = this.field_145849_e + direction.offsetZ;
        if (this.field_145850_b.func_72899_e(x, y, z)) {
            Block block = this.field_145850_b.func_147439_a(x, y, z);
            if (block != null) {
                int metadata = this.field_145850_b.func_72805_g(x, y, z);
                if (block != Blocks.field_150357_h && block.func_149712_f(this.field_145850_b, z, y, z) > -1.0f) {
                    this.breakBlock(direction, x, y, z, block, metadata);
                }
            }
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "tile.piston.in", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.15f + 0.6f);
        }
    }

    private void breakBlock(final ForgeDirection direction, final int x, final int y, final int z, final Block block, final int metadata) {
        if (!(this.field_145850_b instanceof WorldServer)) {
            return;
        }
        FakePlayerPool.instance.executeOnPlayer((WorldServer)this.field_145850_b, new FakePlayerPool.PlayerUser(){

            public void usePlayer(OpenModsFakePlayer fakePlayer) {
                fakePlayer.field_71071_by.field_70461_c = 0;
                fakePlayer.field_71071_by.func_70299_a(0, new ItemStack(Items.field_151046_w, 0, 0));
                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(x, y, z, TileEntityBlockBreaker.this.field_145850_b, block, TileEntityBlockBreaker.this.field_145847_g, (EntityPlayer)fakePlayer);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return;
                }
                if (ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)fakePlayer, (int)metadata)) {
                    TileEntityBlockBreaker.this.field_145850_b.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (metadata << 12));
                    TileEntityBlockBreaker.this.field_145850_b.func_147468_f(x, y, z);
                    ArrayList items = block.getDrops(TileEntityBlockBreaker.this.field_145850_b, x, y, z, metadata, 0);
                    if (items != null) {
                        ForgeDirection back = direction.getOpposite();
                        TileEntityBlockBreaker.this.ejectAt(TileEntityBlockBreaker.this.field_145850_b, TileEntityBlockBreaker.this.field_145851_c + back.offsetX, TileEntityBlockBreaker.this.field_145848_d + back.offsetY, TileEntityBlockBreaker.this.field_145849_e + back.offsetZ, back, items);
                    }
                }
            }
        });
    }

    private void ejectAt(World world, int x, int y, int z, ForgeDirection direction, List<ItemStack> itemStacks) {
        TileEntity targetInventory = this.getTileInDirection(direction);
        ItemStack currentStack = this.inventory.func_70301_a(0);
        if (currentStack != null) {
            BlockUtils.ejectItemInDirection((World)world, (double)x, (double)y, (double)z, (ForgeDirection)direction, (ItemStack)currentStack);
        }
        for (ItemStack stack : itemStacks) {
            if (stack == null) continue;
            if (targetInventory != null) {
                this.inventory.func_70299_a(0, stack);
                int amount = InventoryUtils.moveItemInto((IInventory)this.inventory, (int)0, (Object)targetInventory, (int)-1, (int)64, (ForgeDirection)direction, (boolean)true);
                this.inventory.func_70299_a(0, null);
                stack.field_77994_a -= amount;
            }
            if (stack.field_77994_a <= 0) continue;
            BlockUtils.ejectItemInDirection((World)world, (double)x, (double)y, (double)z, (ForgeDirection)direction, (ItemStack)stack);
        }
    }

    public void onNeighbourChanged(Block block) {
        if (!this.field_145850_b.field_72995_K) {
            this.setRedstoneSignal(this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }
}

