/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Random;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiAutoEnchantmentTable;
import openblocks.common.container.ContainerAutoEnchantmentTable;
import openblocks.rpc.ILevelChanger;
import openmods.api.IHasGui;
import openmods.api.IInventoryCallback;
import openmods.api.IValueProvider;
import openmods.api.IValueReceiver;
import openmods.gui.misc.IConfigurableGuiSlots;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.include.IncludeOverride;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.liquids.SidedFluidHandler;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableDirs;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableInt;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.EnchantmentUtils;
import openmods.utils.InventoryUtils;
import openmods.utils.MiscUtils;
import openmods.utils.SidedInventoryAdapter;
import openmods.utils.bitmap.BitMapUtils;
import openmods.utils.bitmap.IReadableBitMap;
import openmods.utils.bitmap.IRpcDirectionBitMap;
import openmods.utils.bitmap.IRpcIntBitMap;
import openmods.utils.bitmap.IWriteableBitMap;

public class TileEntityAutoEnchantmentTable
extends SyncedTileEntity
implements IInventoryProvider,
IHasGui,
IExtendable,
IConfigurableGuiSlots<AutoSlots>,
ILevelChanger,
IInventoryCallback {
    public static final int TANK_CAPACITY = EnchantmentUtils.getLiquidForLevel((int)30);
    private SyncableTank tank;
    private SyncableDirs inputSides;
    private SyncableDirs outputSides;
    private SyncableDirs xpSides;
    private SyncableInt targetLevel;
    private SyncableFlags automaticSlots;
    private SyncableInt maxLevel;
    private final GenericInventory inventory = new GenericInventory("autoenchant", true, 2){

        public boolean func_94041_b(int i, ItemStack itemstack) {
            if (i == Slots.input.ordinal()) {
                return !itemstack.func_77948_v();
            }
            return i == Slots.input.ordinal();
        }
    };
    @IncludeInterface(value=ISidedInventory.class)
    private final SidedInventoryAdapter slotSides = new SidedInventoryAdapter((IInventory)this.inventory);
    @IncludeInterface
    private final IFluidHandler tankWrapper = new SidedFluidHandler.Drain((IReadableBitMap)this.xpSides, (IFluidTank)this.tank);
    public int tickCount;
    public float pageFlip;
    public float pageFlipPrev;
    public float field_70373_d;
    public float field_70374_e;
    public float bookSpread;
    public float bookSpreadPrev;
    public float bookRotation2;
    public float bookRotationPrev;
    public float bookRotation;
    private static Random rand = new Random();

    public TileEntityAutoEnchantmentTable() {
        this.slotSides.registerSlot((Enum)Slots.input, (IReadableBitMap)this.inputSides, true, false);
        this.slotSides.registerSlot((Enum)Slots.output, (IReadableBitMap)this.outputSides, false, true);
        this.inventory.addCallback((IInventoryCallback)this);
    }

    protected void createSyncedFields() {
        this.tank = new SyncableTank(TANK_CAPACITY, new FluidStack[]{OpenBlocks.XP_FLUID});
        this.inputSides = new SyncableDirs();
        this.outputSides = new SyncableDirs();
        this.xpSides = new SyncableDirs();
        this.targetLevel = new SyncableInt(1);
        this.maxLevel = new SyncableInt();
        this.automaticSlots = SyncableFlags.create((int)AutoSlots.values().length);
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.handleBookRotation();
        if (!this.field_145850_b.field_72995_K) {
            int xpRequired;
            if (this.automaticSlots.get((Enum)AutoSlots.xp)) {
                this.tank.fillFromSides(80, this.field_145850_b, this.getPosition(), this.xpSides.getValue());
            }
            if (this.shouldAutoOutput() && this.hasStack(Slots.output)) {
                InventoryUtils.moveItemsToOneOfSides((TileEntity)this, (IInventory)this.inventory, (int)Slots.output.ordinal(), (int)1, (Set)this.outputSides.getValue());
            }
            if (this.shouldAutoInput() && !this.hasStack(Slots.input)) {
                InventoryUtils.moveItemsFromOneOfSides((TileEntity)this, (IInventory)this.inventory, (int)1, (int)Slots.input.ordinal(), (Set)this.inputSides.getValue());
            }
            if (this.hasStack(Slots.input) && this.inventory.func_94041_b(Slots.input.ordinal(), this.getStack(Slots.input)) && !this.hasStack(Slots.output) && (xpRequired = EnchantmentUtils.getLiquidForLevel((int)this.targetLevel.get())) > 0 && this.tank.getFluidAmount() >= xpRequired) {
                float power = EnchantmentUtils.getPower((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
                int enchantability = EnchantmentUtils.calcEnchantability((ItemStack)this.getStack(Slots.input), (int)((int)power), (boolean)true);
                if (enchantability >= this.targetLevel.get()) {
                    ItemStack inputStack = this.getStack(Slots.input);
                    if (inputStack == null) {
                        return;
                    }
                    ItemStack resultingStack = inputStack.func_77946_l();
                    resultingStack.field_77994_a = 1;
                    if (EnchantmentUtils.enchantItem((ItemStack)resultingStack, (int)this.targetLevel.get(), (Random)this.field_145850_b.field_73012_v)) {
                        this.tank.drain(xpRequired, true);
                        --inputStack.field_77994_a;
                        if (inputStack.field_77994_a < 1) {
                            this.setStack(Slots.input, null);
                        }
                        this.setStack(Slots.output, resultingStack);
                        this.sync();
                    }
                }
            }
            if (this.tank.isDirty()) {
                this.sync();
            }
        }
    }

    private void handleBookRotation() {
        float f1;
        this.bookSpreadPrev = this.bookSpread;
        this.bookRotationPrev = this.bookRotation2;
        EntityPlayer entityplayer = this.field_145850_b.func_72977_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), 3.0);
        if (entityplayer != null) {
            double d0 = entityplayer.field_70165_t - (double)((float)this.field_145851_c + 0.5f);
            double d1 = entityplayer.field_70161_v - (double)((float)this.field_145849_e + 0.5f);
            this.bookRotation = (float)Math.atan2(d1, d0);
            this.bookSpread += 0.1f;
            if (this.bookSpread < 0.5f || rand.nextInt(40) == 0) {
                float f = this.field_70373_d;
                do {
                    this.field_70373_d += (float)(rand.nextInt(4) - rand.nextInt(4));
                } while (f == this.field_70373_d);
            }
        } else {
            this.bookRotation += 0.02f;
            this.bookSpread -= 0.1f;
        }
        while (this.bookRotation2 >= (float)Math.PI) {
            this.bookRotation2 -= (float)Math.PI * 2;
        }
        while (this.bookRotation2 < (float)(-Math.PI)) {
            this.bookRotation2 += (float)Math.PI * 2;
        }
        while (this.bookRotation >= (float)Math.PI) {
            this.bookRotation -= (float)Math.PI * 2;
        }
        while (this.bookRotation < (float)(-Math.PI)) {
            this.bookRotation += (float)Math.PI * 2;
        }
        for (f1 = this.bookRotation - this.bookRotation2; f1 >= (float)Math.PI; f1 -= (float)Math.PI * 2) {
        }
        while (f1 < (float)(-Math.PI)) {
            f1 += (float)Math.PI * 2;
        }
        this.bookRotation2 += f1 * 0.4f;
        if (this.bookSpread < 0.0f) {
            this.bookSpread = 0.0f;
        }
        if (this.bookSpread > 1.0f) {
            this.bookSpread = 1.0f;
        }
        ++this.tickCount;
        this.pageFlipPrev = this.pageFlip;
        float f2 = (this.field_70373_d - this.pageFlip) * 0.4f;
        float f3 = 0.2f;
        if (f2 < -f3) {
            f2 = -f3;
        }
        if (f2 > f3) {
            f2 = f3;
        }
        this.field_70374_e += (f2 - this.field_70374_e) * 0.9f;
        this.pageFlip += this.field_70374_e;
    }

    private boolean shouldAutoInput() {
        return this.automaticSlots.get((Enum)AutoSlots.input);
    }

    private boolean shouldAutoOutput() {
        return this.automaticSlots.get((Enum)AutoSlots.output);
    }

    private boolean hasStack(Enum<?> slot) {
        return this.getStack(slot) != null;
    }

    public void setStack(Enum<?> slot, ItemStack stack) {
        this.inventory.func_70299_a(slot.ordinal(), stack);
    }

    private ItemStack getStack(Enum<?> slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerAutoEnchantmentTable((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiAutoEnchantmentTable(new ContainerAutoEnchantmentTable((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    @IncludeOverride
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public IValueProvider<FluidStack> getFluidProvider() {
        return this.tank;
    }

    public IInventory getInventory() {
        return this.slotSides;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    private SyncableDirs selectSlotMap(AutoSlots slot) {
        switch (slot) {
            case input: {
                return this.inputSides;
            }
            case output: {
                return this.outputSides;
            }
            case xp: {
                return this.xpSides;
            }
        }
        throw MiscUtils.unhandledEnum((Enum)slot);
    }

    public IValueProvider<Set<ForgeDirection>> createAllowedDirectionsProvider(AutoSlots slot) {
        return this.selectSlotMap(slot);
    }

    public IWriteableBitMap<ForgeDirection> createAllowedDirectionsReceiver(AutoSlots slot) {
        SyncableDirs dirs = this.selectSlotMap(slot);
        return BitMapUtils.createRpcAdapter((IRpcDirectionBitMap)((IRpcDirectionBitMap)this.createRpcProxy((ISyncableObject)dirs, IRpcDirectionBitMap.class, new Class[0])));
    }

    public IValueProvider<Boolean> createAutoFlagProvider(AutoSlots slot) {
        return BitMapUtils.singleBitProvider((IReadableBitMap)this.automaticSlots, (Object)slot.ordinal());
    }

    public IValueReceiver<Boolean> createAutoSlotReceiver(AutoSlots slot) {
        IRpcIntBitMap bits = (IRpcIntBitMap)this.createRpcProxy((ISyncableObject)this.automaticSlots, IRpcIntBitMap.class, new Class[0]);
        return BitMapUtils.singleBitReceiver((IRpcIntBitMap)bits, (int)slot.ordinal());
    }

    @Override
    public void changeLevel(int level) {
        this.targetLevel.set(level);
        this.sync();
    }

    public IValueProvider<Integer> getLevelProvider() {
        return this.targetLevel;
    }

    public IValueProvider<Integer> getMaxLevelProvider() {
        return this.maxLevel;
    }

    public void onInventoryChanged(IInventory inventory, int slotNumber) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        float power = EnchantmentUtils.getPower((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        ItemStack stack = this.getStack(Slots.input);
        int enchantability = stack == null ? 30 : stack.func_77973_b().func_77619_b();
        int maxLevel = EnchantmentUtils.calcEnchantability((int)enchantability, (int)((int)power), (boolean)true);
        this.maxLevel.set(maxLevel);
        this.sync();
    }

    public static enum AutoSlots {
        input,
        output,
        xp;

    }

    public static enum Slots {
        input,
        output;

    }
}

