/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import com.google.common.base.Strings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.entity.EntityGoldenEye;
import openmods.Log;
import openmods.utils.ItemUtils;
import openmods.world.StructureRegistry;

public class ItemGoldenEye
extends Item {
    public static final int MAX_DAMAGE = 100;
    private static final String TAG_STRUCTURE = "Structure";

    public ItemGoldenEye() {
        this.func_77656_e(100);
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world instanceof WorldServer && player instanceof EntityPlayerMP) {
            EntityPlayerMP betterPlayer = (EntityPlayerMP)player;
            if (player.func_70093_af()) {
                ItemGoldenEye.tryLearnStructure(stack, (WorldServer)world, betterPlayer);
            } else if (ItemGoldenEye.trySpawnEntity(stack, (WorldServer)world, betterPlayer)) {
                stack.field_77994_a = 0;
            }
        }
        return stack;
    }

    private static void tryLearnStructure(ItemStack stack, WorldServer world, EntityPlayerMP player) {
        Map nearbyStructures = StructureRegistry.instance.getNearestStructures(world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        String structureName = "";
        double max = Double.MAX_VALUE;
        for (Map.Entry e : nearbyStructures.entrySet()) {
            double dz;
            double dy;
            double dx;
            double dist;
            ChunkPosition pos = (ChunkPosition)e.getValue();
            if (Config.eyeDebug) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("openblocks.misc.structure_pos", new Object[]{e.getKey(), pos.field_151329_a, pos.field_151327_b, pos.field_151328_c}));
            }
            if (!((dist = (dx = (double)pos.field_151329_a - player.field_70165_t) * dx + (dy = (double)pos.field_151327_b - player.field_70163_u) * dy + (dz = (double)pos.field_151328_c - player.field_70161_v) * dz) < max)) continue;
            max = dist;
            structureName = (String)e.getKey();
        }
        if (!Strings.isNullOrEmpty((String)structureName)) {
            Log.info((String)"Learned structure %s, d = %f", (Object[])new Object[]{structureName, max});
            NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
            tag.func_74778_a(TAG_STRUCTURE, structureName);
        }
    }

    private static boolean trySpawnEntity(ItemStack stack, WorldServer world, EntityPlayerMP player) {
        int damage = stack.func_77960_j();
        if (damage >= stack.func_77958_k()) {
            return false;
        }
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        String structureName = tag.func_74779_i(TAG_STRUCTURE);
        if (Strings.isNullOrEmpty((String)structureName)) {
            return false;
        }
        Map nearbyStructures = StructureRegistry.instance.getNearestStructures(world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        ChunkPosition structurePos = (ChunkPosition)nearbyStructures.get(structureName);
        if (structurePos != null) {
            if (Config.eyeDebug) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("openblocks.misc.structure_pos", new Object[]{structureName, structurePos.field_151329_a, structurePos.field_151327_b, structurePos.field_151328_c}));
            }
            stack.func_77964_b(damage + 1);
            EntityGoldenEye eye = new EntityGoldenEye((World)world, stack, (Entity)player, structurePos);
            world.func_72838_d((Entity)eye);
            world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List result) {
        result.add(new ItemStack(item, 1, 0));
        result.add(new ItemStack(item, 1, this.func_77612_l()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister registry) {
        this.field_77791_bV = registry.func_94245_a("openblocks:golden_eye");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List result, boolean expanded) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        if (tag.func_74764_b(TAG_STRUCTURE)) {
            result.add(StatCollector.func_74838_a((String)"openblocks.misc.locked"));
        }
    }
}

