/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import openblocks.Config;
import openmods.Log;
import openmods.inventory.GenericInventory;
import openmods.utils.TagUtils;
import org.apache.commons.lang3.StringUtils;

public class PlayerInventoryStore {
    private static final String TAG_INVENTORY = "Inventory";
    private static final DateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private static final Pattern SAFE_CHARS = Pattern.compile("[^A-Za-z0-9_-]");
    private static final String PREFIX = "inventory-";
    public static final PlayerInventoryStore instance = new PlayerInventoryStore();

    private PlayerInventoryStore() {
    }

    private static File getNewDumpFile(Date date, String player, World world, String type) {
        String dateStr = FORMATTER.format(date);
        int id = 0;
        while (true) {
            String filename = String.format("inventory-%s-%s-%s-%d", player, dateStr, type, id);
            File file = world.func_72860_G().func_75758_b(filename);
            if (!file.exists()) {
                return file;
            }
            ++id;
        }
    }

    private static String stripFilename(String name) {
        return StringUtils.removeEndIgnoreCase((String)StringUtils.removeStartIgnoreCase((String)name, (String)PREFIX), (String)".dat");
    }

    public static ExtrasFiller createDefaultExtrasFiller(final GameProfile profile, final double x, final double y, final double z) {
        return new ExtrasFiller(){

            @Override
            public void addExtras(NBTTagCompound meta) {
                meta.func_74778_a("PlayerName", profile.getName());
                meta.func_74778_a("PlayerUUID", profile.getId().toString());
                meta.func_74782_a("Location", (NBTBase)TagUtils.store((double)x, (double)y, (double)z));
            }
        };
    }

    public File storePlayerInventory(EntityPlayer player, String type) {
        GameProfile profile = player.func_146103_bH();
        return this.storeInventory((IInventory)player.field_71071_by, profile.getName(), type, player.field_70170_p, PlayerInventoryStore.createDefaultExtrasFiller(profile, player.field_70165_t, player.field_70163_u, player.field_70161_v));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File storeInventory(IInventory inventory, String name, String type, World world, ExtrasFiller filler) {
        GenericInventory copy = new GenericInventory("tmp", false, inventory.func_70302_i_());
        copy.copyFrom(inventory);
        Date now = new Date();
        Matcher matcher = SAFE_CHARS.matcher(name);
        String playerName = matcher.replaceAll("_");
        File dumpFile = PlayerInventoryStore.getNewDumpFile(now, playerName, world, type);
        NBTTagCompound invData = new NBTTagCompound();
        copy.writeToNBT(invData);
        NBTTagCompound root = new NBTTagCompound();
        root.func_74782_a(TAG_INVENTORY, (NBTBase)invData);
        root.func_74772_a("Created", now.getTime());
        root.func_74778_a("Type", type);
        filler.addExtras(root);
        try {
            FileOutputStream stream = new FileOutputStream(dumpFile);
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)root, (OutputStream)stream);
            }
            finally {
                ((OutputStream)stream).close();
            }
        }
        catch (IOException e) {
            Log.warn((String)"Failed to dump data for player %s, file %s", (Object[])new Object[]{name, dumpFile.getAbsoluteFile()});
        }
        return dumpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IInventory loadInventory(World world, String fileId) {
        NBTTagCompound tag;
        File file = world.func_72860_G().func_75758_b(PREFIX + PlayerInventoryStore.stripFilename(fileId));
        try {
            FileInputStream stream = new FileInputStream(file);
            try {
                tag = CompressedStreamTools.func_74796_a((InputStream)stream);
            }
            finally {
                ((InputStream)stream).close();
            }
        }
        catch (IOException e) {
            Log.warn((String)"Failed to read data from file %s", (Object[])new Object[]{file.getAbsoluteFile()});
            return null;
        }
        if (!tag.func_74764_b(TAG_INVENTORY)) {
            return null;
        }
        NBTTagCompound invTag = tag.func_74775_l(TAG_INVENTORY);
        GenericInventory result = new GenericInventory("tmp", false, 0);
        result.readFromNBT(invTag);
        return result;
    }

    public List<String> getMatchedDumps(World world, String prefix) {
        File dummy = world.func_72860_G().func_75758_b("dummy");
        File saveFolder = dummy.getParentFile();
        final String actualPrefix = StringUtils.startsWithIgnoreCase((CharSequence)prefix, (CharSequence)PREFIX) ? prefix : PREFIX + prefix;
        File[] files = saveFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(actualPrefix);
            }
        });
        ArrayList result = Lists.newArrayList();
        int toCut = PREFIX.length();
        for (File f : files) {
            String name = f.getName();
            result.add(name.substring(toCut, name.length() - 4));
        }
        return result;
    }

    public boolean restoreInventory(EntityPlayer player, String fileId) {
        IInventory restored = PlayerInventoryStore.loadInventory(player.field_70170_p, fileId);
        InventoryPlayer current = player.field_71071_by;
        if (current.func_70302_i_() < restored.func_70302_i_()) {
            Log.info((String)"Target inventory too small, %d < %d", (Object[])new Object[]{current.func_70302_i_(), restored.func_70302_i_()});
            return false;
        }
        for (int i = 0; i < restored.func_70302_i_(); ++i) {
            current.func_70299_a(i, restored.func_70301_a(i));
        }
        return true;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerDeath(LivingDeathEvent event) {
        if (Config.dumpStiffsStuff && event.entity instanceof EntityPlayerMP && !(event.entity instanceof FakePlayer)) {
            EntityPlayer player = (EntityPlayer)event.entity;
            String playerName = player.getDisplayName();
            try {
                File file = this.storePlayerInventory(player, "death");
                Log.info((String)"Storing post-mortem inventory into %s. It can be restored with command '/ob_inventory restore %s %s'", (Object[])new Object[]{file.getAbsolutePath(), playerName, PlayerInventoryStore.stripFilename(file.getName())});
            }
            catch (Exception e) {
                Log.severe((Throwable)e, (String)"Failed to store inventory for player %s", (Object[])new Object[]{playerName});
            }
        }
    }

    public static interface ExtrasFiller {
        public void addExtras(NBTTagCompound var1);
    }
}

