/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.inventory.Container;
import net.minecraft.util.StatCollector;
import openblocks.OpenBlocks;
import openblocks.client.ChangelogBuilder;
import openblocks.client.gui.ChangelogPage;
import openblocks.client.gui.page.IntroPage;
import openblocks.common.item.MetasGeneric;
import openmods.gui.ComponentGui;
import openmods.gui.DummyContainer;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.BaseComposite;
import openmods.gui.component.GuiComponentBook;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.page.PageBase;
import openmods.gui.component.page.SectionPage;
import openmods.gui.component.page.TitledPage;
import org.lwjgl.opengl.GL11;

public class GuiInfoBook
extends ComponentGui
implements GuiYesNoCallback {
    private static final String MODID = "openblocks";

    public GuiInfoBook() {
        super((Container)new DummyContainer(), 0, 0);
    }

    private static void setupBookmark(GuiComponentLabel label, GuiComponentBook book, int index) {
        label.setListener(book.createBookmarkListener(index));
    }

    private static int alignToEven(GuiComponentBook book) {
        int index = book.getNumberOfPages();
        if (index % 2 == 1) {
            book.addPage((BaseComponent)PageBase.BLANK_PAGE);
            ++index;
        }
        return index;
    }

    private static int tocLine(int index) {
        int tocStartHeight = 80;
        int tocLineHeight = 15;
        return 80 + index * 15;
    }

    protected BaseComposite createRoot() {
        GuiComponentBook book = new GuiComponentBook();
        TitledPage contentsPage = new TitledPage("openblocks.gui.welcome.title", "openblocks.gui.welcome.content");
        GuiComponentLabel lblBlocks = new GuiComponentLabel(27, GuiInfoBook.tocLine(0), "- " + StatCollector.func_74838_a((String)"openblocks.gui.blocks"));
        contentsPage.addComponent((BaseComponent)lblBlocks);
        GuiComponentLabel lblItems = new GuiComponentLabel(27, GuiInfoBook.tocLine(1), "- " + StatCollector.func_74838_a((String)"openblocks.gui.items"));
        contentsPage.addComponent((BaseComponent)lblItems);
        GuiComponentLabel lblMisc = new GuiComponentLabel(27, GuiInfoBook.tocLine(2), "- " + StatCollector.func_74838_a((String)"openblocks.gui.misc"));
        contentsPage.addComponent((BaseComponent)lblMisc);
        GuiComponentLabel lblChangelogs = new GuiComponentLabel(27, GuiInfoBook.tocLine(3), "- " + StatCollector.func_74838_a((String)"openblocks.gui.changelogs"));
        contentsPage.addComponent((BaseComponent)lblChangelogs);
        book.addPage((BaseComponent)PageBase.BLANK_PAGE);
        book.addPage((BaseComponent)new IntroPage());
        book.addPage((BaseComponent)new TitledPage("openblocks.gui.credits.title", "openblocks.gui.credits.content"));
        book.addPage((BaseComponent)contentsPage);
        GuiInfoBook.setupBookmark(lblBlocks, book, book.getNumberOfPages());
        book.addPage((BaseComponent)PageBase.BLANK_PAGE);
        book.addPage((BaseComponent)new SectionPage("openblocks.gui.blocks"));
        book.addStandardRecipePage(MODID, "elevator", (Object)OpenBlocks.Blocks.elevator);
        book.addStandardRecipePage(MODID, "sprinkler", (Object)OpenBlocks.Blocks.sprinkler);
        book.addStandardRecipePage(MODID, "paintmixer", (Object)OpenBlocks.Blocks.paintMixer);
        book.addStandardRecipePage(MODID, "beartrap", (Object)OpenBlocks.Blocks.bearTrap);
        book.addStandardRecipePage(MODID, "guide", (Object)OpenBlocks.Blocks.guide);
        book.addStandardRecipePage(MODID, "canvas", (Object)OpenBlocks.Blocks.canvas);
        book.addStandardRecipePage(MODID, "vacuumhopper", (Object)OpenBlocks.Blocks.vacuumHopper);
        book.addStandardRecipePage(MODID, "tank", (Object)OpenBlocks.Blocks.tank);
        book.addStandardRecipePage(MODID, "path", (Object)OpenBlocks.Blocks.path);
        book.addStandardRecipePage(MODID, "fan", (Object)OpenBlocks.Blocks.fan);
        book.addStandardRecipePage(MODID, "blockbreaker", (Object)OpenBlocks.Blocks.blockBreaker);
        book.addStandardRecipePage(MODID, "blockPlacer", (Object)OpenBlocks.Blocks.blockPlacer);
        book.addStandardRecipePage(MODID, "itemDropper", (Object)OpenBlocks.Blocks.itemDropper);
        book.addStandardRecipePage(MODID, "bigbutton", (Object)OpenBlocks.Blocks.bigButton);
        book.addStandardRecipePage(MODID, "autoanvil", (Object)OpenBlocks.Blocks.autoAnvil);
        book.addStandardRecipePage(MODID, "autoenchantmenttable", (Object)OpenBlocks.Blocks.autoEnchantmentTable);
        book.addStandardRecipePage(MODID, "sponge", (Object)OpenBlocks.Blocks.sponge);
        book.addStandardRecipePage(MODID, "ropeladder", (Object)OpenBlocks.Blocks.ropeLadder);
        book.addStandardRecipePage(MODID, "village_highlighter", (Object)OpenBlocks.Blocks.villageHighlighter);
        book.addStandardRecipePage(MODID, "xpbottler", (Object)OpenBlocks.Blocks.xpBottler);
        book.addStandardRecipePage(MODID, "xpdrain", (Object)OpenBlocks.Blocks.xpDrain);
        book.addStandardRecipePage(MODID, "drawingtable", (Object)OpenBlocks.Blocks.drawingTable);
        book.addStandardRecipePage(MODID, "sky.normal", (Object)OpenBlocks.Blocks.sky);
        book.addStandardRecipePage(MODID, "xpshower", (Object)OpenBlocks.Blocks.xpShower);
        int itemsIndex = GuiInfoBook.alignToEven(book);
        GuiInfoBook.setupBookmark(lblItems, book, itemsIndex);
        book.addPage((BaseComponent)PageBase.BLANK_PAGE);
        book.addPage((BaseComponent)new SectionPage("openblocks.gui.items"));
        book.addStandardRecipePage(MODID, "luggage", (Object)OpenBlocks.Items.luggage);
        book.addStandardRecipePage(MODID, "sonicglasses", (Object)OpenBlocks.Items.sonicGlasses);
        book.addStandardRecipePage(MODID, "hangglider", (Object)OpenBlocks.Items.hangGlider);
        book.addStandardRecipePage(MODID, "cursor", (Object)OpenBlocks.Items.cursor);
        book.addStandardRecipePage(MODID, "unprepared_stencil", (Object)MetasGeneric.unpreparedStencil.newItemStack());
        book.addStandardRecipePage(MODID, "sleepingbag", (Object)OpenBlocks.Items.sleepingBag);
        book.addStandardRecipePage(MODID, "devnull", (Object)OpenBlocks.Items.devNull);
        book.addStandardRecipePage(MODID, "paintbrush", (Object)OpenBlocks.Items.paintBrush);
        book.addStandardRecipePage(MODID, "squeegee", (Object)OpenBlocks.Items.squeegee);
        book.addStandardRecipePage(MODID, "slimalyzer", (Object)OpenBlocks.Items.slimalyzer);
        book.addStandardRecipePage(MODID, "spongeonastick", (Object)OpenBlocks.Items.spongeonastick);
        int miscIndex = GuiInfoBook.alignToEven(book);
        GuiInfoBook.setupBookmark(lblMisc, book, miscIndex);
        book.addPage((BaseComponent)PageBase.BLANK_PAGE);
        book.addPage((BaseComponent)new SectionPage("openblocks.gui.misc"));
        book.addPage((BaseComponent)new TitledPage("openblocks.gui.config.title", "openblocks.gui.config.content"));
        book.addPage((BaseComponent)new TitledPage("openblocks.gui.bkey.title", "openblocks.gui.bkey.content"));
        if (OpenBlocks.Enchantments.explosive != null) {
            book.addPage((BaseComponent)new TitledPage("openblocks.gui.unstable.title", "openblocks.gui.unstable.content"));
        }
        if (OpenBlocks.Enchantments.lastStand != null) {
            book.addPage((BaseComponent)new TitledPage("openblocks.gui.laststand.title", "openblocks.gui.laststand.content"));
        }
        if (OpenBlocks.Enchantments.flimFlam != null) {
            book.addPage((BaseComponent)new TitledPage("openblocks.gui.flimflam.title", "openblocks.gui.flimflam.content"));
        }
        int changelogsIndex = GuiInfoBook.alignToEven(book);
        book.addPage((BaseComponent)PageBase.BLANK_PAGE);
        GuiInfoBook.setupBookmark(lblChangelogs, book, changelogsIndex);
        book.addPage((BaseComponent)new SectionPage("openblocks.gui.changelogs"));
        GuiInfoBook.createChangelogPages(book);
        book.enablePages();
        this.field_146999_f = book.getWidth();
        this.field_147000_g = book.getHeight();
        return book;
    }

    private static void createChangelogPages(GuiComponentBook book) {
        String prevVersion = null;
        int prevIndex = 0;
        ArrayList prevPages = Lists.newArrayList();
        List<ChangelogBuilder.Changelog> changelogs = ChangelogBuilder.readChangeLogs();
        for (int i = 0; i < changelogs.size(); ++i) {
            ChangelogBuilder.Changelog changelog = changelogs.get(i);
            String currentVersion = changelog.version;
            int currentPage = book.getNumberOfPages();
            for (ChangelogPage prevPage : prevPages) {
                prevPage.addNextVersionBookmark(book, currentVersion, currentPage);
            }
            prevPages.clear();
            for (ChangelogBuilder.ChangelogSection section : changelog.sections) {
                ChangelogPage page = new ChangelogPage(currentVersion, section.title, section.lines);
                book.addPage((BaseComponent)page);
                prevPages.add(page);
                if (i <= 0) continue;
                page.addPrevVersionBookmark(book, prevVersion, prevIndex);
            }
            GuiInfoBook.alignToEven(book);
            prevVersion = currentVersion;
            prevIndex = currentPage;
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        this.prepareRenderState();
        GL11.glPushMatrix();
        this.root.renderOverlay(this.field_146297_k, this.field_147003_i, this.field_147009_r, par1 - this.field_147003_i, par2 - this.field_147009_r);
        GL11.glPopMatrix();
        this.restoreRenderState();
    }
}

