/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.common.blocks.logic;

import mcp.mobius.betterbarrels.common.blocks.IBarrelStorage;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;
import mcp.mobius.betterbarrels.common.items.upgrades.UpgradeSide;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public enum LogicHopper {
    INSTANCE;


    private boolean isStorage(TileEntity inventory) {
        if (inventory instanceof IDeepStorageUnit) {
            return true;
        }
        return inventory instanceof IInventory;
    }

    public boolean run(TileEntityBarrel barrel) {
        boolean transaction = false;
        IBarrelStorage store = barrel.getStorage();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            ItemStack pulledStack;
            TileEntity targetEntity;
            if (barrel.sideUpgrades[side.ordinal()] != UpgradeSide.HOPPER || barrel.sideMetadata[side.ordinal()] == UpgradeSide.RS_FULL && (!store.hasItem() || store.getAmount() == 0) || barrel.sideMetadata[side.ordinal()] == UpgradeSide.RS_EMPT && store.getAmount() == store.getMaxStoredCount() || !this.isStorage(targetEntity = barrel.func_145831_w().func_147438_o(barrel.field_145851_c + side.offsetX, barrel.field_145848_d + side.offsetY, barrel.field_145849_e + side.offsetZ))) continue;
            if (barrel.sideMetadata[side.ordinal()] == UpgradeSide.RS_FULL) {
                ItemStack stack = store.func_70301_a(1);
                if (this.isFull(targetEntity, side.getOpposite()) || (stack = barrel.getStorage().func_70301_a(1)) == null || stack.field_77994_a <= 0 || !this.pushItemToInventory(targetEntity, side.getOpposite(), stack)) continue;
                barrel.getStorage().func_70296_d();
                transaction = true;
                targetEntity.func_70296_d();
                continue;
            }
            if (store.getAmount() == store.getMaxStoredCount() || (pulledStack = this.pullMatchingItemFromInventory(store, targetEntity, side.getOpposite())) == null) continue;
            if (store.hasItem()) {
                store.setStoredItemCount(store.getAmount() + 1);
            } else {
                store.setStoredItemType(pulledStack, 1);
            }
            transaction = true;
            targetEntity.func_70296_d();
        }
        return transaction;
    }

    private boolean isFull(TileEntity inventory, ForgeDirection side) {
        if (inventory instanceof IDeepStorageUnit) {
            IDeepStorageUnit dsu = (IDeepStorageUnit)inventory;
            ItemStack is = dsu.getStoredItemType();
            return is != null && is.field_77994_a == dsu.getMaxStoredCount();
        }
        if (inventory instanceof ISidedInventory && side.ordinal() > -1) {
            int[] islots;
            ISidedInventory sinv = (ISidedInventory)inventory;
            for (int index : islots = sinv.func_94128_d(side.ordinal())) {
                ItemStack is = sinv.func_70301_a(index);
                if (is != null && is.field_77994_a == is.func_77976_d()) continue;
                return false;
            }
            return true;
        }
        if (inventory instanceof IInventory) {
            IInventory inv = (IInventory)inventory;
            for (int index = 0; index < inv.func_70302_i_(); ++index) {
                ItemStack is = inv.func_70301_a(index);
                if (is != null && is.field_77994_a == is.func_77976_d()) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean pushItemToInventory(TileEntity inventory, ForgeDirection side, ItemStack stack) {
        block7: {
            block8: {
                int[] islots;
                block6: {
                    if (!(inventory instanceof IDeepStorageUnit)) break block6;
                    IDeepStorageUnit dsu = (IDeepStorageUnit)inventory;
                    ItemStack is = dsu.getStoredItemType();
                    if (is == null) {
                        is = stack.func_77946_l();
                        dsu.setStoredItemType(is, 1);
                        --stack.field_77994_a;
                        return true;
                    }
                    if (is.func_77969_a(stack) && is.field_77994_a < dsu.getMaxStoredCount()) {
                        dsu.setStoredItemCount(is.field_77994_a + 1);
                        --stack.field_77994_a;
                        return true;
                    }
                    break block7;
                }
                if (!(inventory instanceof ISidedInventory) || side.ordinal() <= -1) break block8;
                ISidedInventory sinv = (ISidedInventory)inventory;
                for (int slot : islots = sinv.func_94128_d(side.ordinal())) {
                    if (!sinv.func_102007_a(slot, stack, side.ordinal())) continue;
                    ItemStack targetStack = sinv.func_70301_a(slot);
                    if (targetStack == null) {
                        targetStack = stack.func_77946_l();
                        targetStack.field_77994_a = 1;
                        sinv.func_70299_a(slot, targetStack);
                        --stack.field_77994_a;
                        return true;
                    }
                    if (!targetStack.func_77969_a(stack) || targetStack.field_77994_a >= targetStack.func_77976_d()) continue;
                    ++targetStack.field_77994_a;
                    --stack.field_77994_a;
                    return true;
                }
                break block7;
            }
            if (!(inventory instanceof IInventory)) break block7;
            IInventory inv = (IInventory)inventory;
            int nslots = inv.func_70302_i_();
            for (int slot = 0; slot < nslots; ++slot) {
                ItemStack targetStack = inv.func_70301_a(slot);
                if (targetStack == null) {
                    targetStack = stack.func_77946_l();
                    targetStack.field_77994_a = 1;
                    inv.func_70299_a(slot, targetStack);
                    --stack.field_77994_a;
                    return true;
                }
                if (!targetStack.func_77969_a(stack) || targetStack.field_77994_a >= targetStack.func_77976_d()) continue;
                ++targetStack.field_77994_a;
                --stack.field_77994_a;
                return true;
            }
        }
        return false;
    }

    private ItemStack pullMatchingItemFromInventory(IBarrelStorage barrel, TileEntity source, ForgeDirection side) {
        block4: {
            block5: {
                int[] islots;
                block3: {
                    if (!(source instanceof IDeepStorageUnit)) break block3;
                    IDeepStorageUnit dsu = (IDeepStorageUnit)source;
                    ItemStack stack = dsu.getStoredItemType();
                    if (stack != null && barrel.sameItem(stack) && stack.field_77994_a > 0) {
                        dsu.setStoredItemCount(stack.field_77994_a - 1);
                        stack = stack.func_77946_l();
                        stack.field_77994_a = 1;
                        return stack;
                    }
                    break block4;
                }
                if (!(source instanceof ISidedInventory) || side.ordinal() <= -1) break block5;
                ISidedInventory sinv = (ISidedInventory)source;
                for (int slot : islots = sinv.func_94128_d(side.ordinal())) {
                    ItemStack stack;
                    if (!sinv.func_102008_b(slot, barrel.getItem(), side.ordinal()) || (stack = sinv.func_70301_a(slot)) == null || !barrel.sameItem(stack) || stack.field_77994_a <= 0) continue;
                    return sinv.func_70298_a(slot, 1);
                }
                break block4;
            }
            if (!(source instanceof IInventory)) break block4;
            IInventory inv = (IInventory)source;
            int nslots = inv.func_70302_i_();
            for (int slot = 0; slot < nslots; ++slot) {
                ItemStack stack = inv.func_70301_a(slot);
                if (stack == null || !barrel.sameItem(stack) || stack.field_77994_a <= 0) continue;
                return inv.func_70298_a(slot, 1);
            }
        }
        return null;
    }
}

