/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.common.blocks;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import mcp.mobius.betterbarrels.BetterBarrels;
import mcp.mobius.betterbarrels.common.blocks.IBarrelStorage;
import mcp.mobius.betterbarrels.common.blocks.logic.Coordinates;
import mcp.mobius.betterbarrels.common.blocks.logic.ItemImmut;
import mcp.mobius.betterbarrels.common.blocks.logic.OreDictPair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class StorageLocal
implements IBarrelStorage {
    private ItemStack inputStack = null;
    private ItemStack outputStack = null;
    private ItemStack prevOutputStack = null;
    private ItemStack itemTemplate = null;
    private ItemStack renderingTemplate = null;
    private int totalAmount = 0;
    private int stackAmount = 64;
    private int basestacks = BetterBarrels.stacksSize;
    private int maxstacks = BetterBarrels.stacksSize;
    private int totalCapacity = 64 * this.maxstacks;
    private int upgCapacity = 0;
    private boolean keepLastItem = false;
    private boolean deleteExcess = false;
    private boolean alwaysProvide = false;
    private Set<Coordinates> linkedStorages = new HashSet<Coordinates>();
    private ItemImmut cachedBarrelOreItem = null;
    private static HashMap<OreDictPair, Boolean> oreDictCache = new HashMap();

    public StorageLocal() {
        this.func_70296_d();
    }

    public StorageLocal(NBTTagCompound tag) {
        this.readTagCompound(tag);
        this.func_70296_d();
    }

    public StorageLocal(int nupgrades) {
        for (int i = 0; i < nupgrades; ++i) {
            this.addStorageUpgrade();
        }
        this.func_70296_d();
    }

    private ItemStack getStackFromSlot(int slot) {
        return slot == 0 ? this.inputStack : this.outputStack;
    }

    private int getFreeSpace() {
        return this.totalCapacity - (this.deleteExcess ? 0 : this.totalAmount);
    }

    @Override
    public boolean hasItem() {
        return this.itemTemplate != null;
    }

    @Override
    public ItemStack getItem() {
        return this.itemTemplate;
    }

    @Override
    public ItemStack getItemForRender() {
        if (this.renderingTemplate == null) {
            this.renderingTemplate = this.itemTemplate.func_77946_l();
            if (this.renderingTemplate.func_77942_o() && this.renderingTemplate.func_77978_p().func_74764_b("ench")) {
                this.renderingTemplate.func_77978_p().func_82580_o("ench");
            }
            if (this.renderingTemplate.func_77942_o() && this.renderingTemplate.func_77978_p().func_74764_b("CustomPotionEffects")) {
                this.renderingTemplate.func_77978_p().func_82580_o("CustomPotionEffects");
            }
            if (this.renderingTemplate.func_77973_b() == Items.field_151068_bn) {
                this.renderingTemplate.func_77964_b(0);
            }
            if (this.renderingTemplate.func_77973_b() == Items.field_151062_by) {
                this.renderingTemplate = new ItemStack((Item)Items.field_151068_bn, 0, 0);
            }
        }
        return this.renderingTemplate;
    }

    @Override
    public void setItem(ItemStack stack) {
        if (stack != null) {
            this.itemTemplate = stack.func_77946_l();
            this.itemTemplate.field_77994_a = 0;
            this.stackAmount = stack.func_77976_d();
            this.totalCapacity = this.maxstacks * this.stackAmount;
            this.cachedBarrelOreItem = new ItemImmut(Item.func_150891_b((Item)this.itemTemplate.func_77973_b()), this.itemTemplate.func_77960_j());
        } else {
            this.itemTemplate = null;
            this.renderingTemplate = null;
            this.stackAmount = 64;
            this.totalCapacity = this.maxstacks * 64;
            this.cachedBarrelOreItem = null;
        }
    }

    @Override
    public boolean sameItem(ItemStack stack) {
        if (this.itemTemplate == null) {
            return !this.keepLastItem;
        }
        if (stack == null) {
            return false;
        }
        if (!this.itemTemplate.func_77969_a(stack)) {
            OreDictPair orePair = new OreDictPair(this.cachedBarrelOreItem, new ItemImmut(Item.func_150891_b((Item)stack.func_77973_b()), stack.func_77960_j()));
            if (!oreDictCache.containsKey(orePair)) {
                int[] oreIDsBarrel = OreDictionary.getOreIDs((ItemStack)this.itemTemplate);
                int[] oreIDsStack = OreDictionary.getOreIDs((ItemStack)stack);
                boolean equivalent = false;
                if (oreIDsBarrel.length > 0 && oreIDsStack.length > 0) {
                    for (int barrelOreID : oreIDsBarrel) {
                        boolean stackIsMetal;
                        String oreNameBarrel = OreDictionary.getOreName((int)barrelOreID);
                        boolean bl = stackIsMetal = oreNameBarrel.startsWith("ingot") || oreNameBarrel.startsWith("ore") || oreNameBarrel.startsWith("dust") || oreNameBarrel.startsWith("nugget");
                        if (!stackIsMetal) continue;
                        for (int stackOreID : oreIDsStack) {
                            boolean bl2 = equivalent = barrelOreID == stackOreID;
                            if (equivalent) break;
                        }
                        if (equivalent) break;
                    }
                }
                oreDictCache.put(orePair, equivalent);
            }
            return oreDictCache.get(orePair);
        }
        return ItemStack.func_77970_a((ItemStack)this.itemTemplate, (ItemStack)stack);
    }

    @Override
    public NBTTagCompound writeTagCompound() {
        NBTTagCompound retTag = new NBTTagCompound();
        retTag.func_74768_a("amount", this.totalAmount);
        retTag.func_74768_a("maxstacks", this.maxstacks);
        retTag.func_74768_a("upgCapacity", this.upgCapacity);
        if (this.itemTemplate != null) {
            NBTTagCompound var3 = new NBTTagCompound();
            this.itemTemplate.func_77955_b(var3);
            retTag.func_74782_a("current_item", (NBTBase)var3);
        }
        if (this.keepLastItem) {
            retTag.func_74757_a("keepLastItem", this.keepLastItem);
        }
        if (this.deleteExcess) {
            retTag.func_74757_a("deleteExcess", this.deleteExcess);
        }
        if (this.alwaysProvide) {
            retTag.func_74757_a("alwaysProvide", this.alwaysProvide);
        }
        return retTag;
    }

    @Override
    public void readTagCompound(NBTTagCompound tag) {
        this.totalAmount = tag.func_74762_e("amount");
        this.maxstacks = tag.func_74762_e("maxstacks");
        this.upgCapacity = tag.func_74762_e("upgCapacity");
        this.itemTemplate = tag.func_74764_b("current_item") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("current_item")) : null;
        this.keepLastItem = tag.func_74764_b("keepLastItem") ? tag.func_74767_n("keepLastItem") : false;
        this.deleteExcess = tag.func_74764_b("deleteExcess") ? tag.func_74767_n("deleteExcess") : false;
        this.alwaysProvide = tag.func_74764_b("alwaysProvide") ? tag.func_74767_n("alwaysProvide") : false;
        this.setItem(this.itemTemplate);
        if (this.itemTemplate != null && this.totalAmount < 0) {
            this.totalAmount = 0;
            if (!this.keepLastItem) {
                this.keepLastItem = true;
            }
        }
    }

    @Override
    public int addStack(ItemStack stack) {
        int deposit;
        boolean skip;
        boolean bl = skip = stack == null || !this.sameItem(stack);
        if (this.itemTemplate == null && this.keepLastItem && stack != null) {
            skip = false;
        }
        if (skip) {
            return 0;
        }
        if (!this.hasItem()) {
            this.setItem(stack);
            this.totalAmount = stack.field_77994_a;
            deposit = stack.field_77994_a;
            stack.field_77994_a -= deposit;
        } else {
            deposit = Math.min(stack.field_77994_a, this.totalCapacity - this.totalAmount);
            stack.field_77994_a -= deposit;
            this.totalAmount += deposit;
        }
        if (this.deleteExcess) {
            deposit += stack.field_77994_a;
            stack.field_77994_a = 0;
        }
        this.func_70296_d();
        return deposit;
    }

    @Override
    public ItemStack getStack() {
        if (this.itemTemplate != null) {
            return this.getStack(this.stackAmount);
        }
        return null;
    }

    @Override
    public ItemStack getStack(int amount) {
        this.func_70296_d();
        ItemStack retStack = null;
        if (this.itemTemplate != null) {
            amount = Math.min(amount, this.stackAmount);
            if (!this.alwaysProvide) {
                amount = Math.min(amount, this.totalAmount);
            }
            retStack = this.itemTemplate.func_77946_l();
            if (!this.alwaysProvide) {
                this.totalAmount -= amount;
            }
            retStack.field_77994_a = amount;
        }
        this.func_70296_d();
        return retStack;
    }

    @Override
    public boolean switchGhosting() {
        this.keepLastItem = !this.keepLastItem;
        this.func_70296_d();
        return this.keepLastItem;
    }

    @Override
    public boolean isGhosting() {
        return this.keepLastItem;
    }

    @Override
    public void setGhosting(boolean locked) {
        this.keepLastItem = locked;
        if (this.totalAmount <= 0) {
            this.setItem(null);
        }
    }

    @Override
    public boolean isVoid() {
        return this.deleteExcess;
    }

    @Override
    public void setVoid(boolean delete) {
        this.deleteExcess = delete;
    }

    @Override
    public boolean isCreative() {
        return this.alwaysProvide;
    }

    @Override
    public void setCreative(boolean infinite) {
        this.alwaysProvide = infinite;
    }

    @Override
    public int getAmount() {
        return this.totalAmount;
    }

    @Override
    public void setAmount(int amount) {
        this.totalAmount = amount;
    }

    @Override
    public void setBaseStacks(int basestacks) {
        this.basestacks = basestacks;
        this.maxstacks = basestacks * (this.upgCapacity + 1);
        this.totalCapacity = this.maxstacks * this.stackAmount;
    }

    @Override
    public int getMaxStacks() {
        return this.maxstacks;
    }

    @Override
    public void addStorageUpgrade() {
        ++this.upgCapacity;
        this.maxstacks = this.basestacks * (this.upgCapacity + 1);
        this.totalCapacity = this.maxstacks * this.stackAmount;
    }

    @Override
    public void rmStorageUpgrade() {
        --this.upgCapacity;
        this.maxstacks = this.basestacks * (this.upgCapacity + 1);
        this.totalCapacity = this.maxstacks * this.stackAmount;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        if (slot == 1) {
            return false;
        }
        if (this.getFreeSpace() <= 0) {
            return false;
        }
        return this.sameItem(itemstack);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        if (slot == 0) {
            return false;
        }
        if (!this.hasItem()) {
            return false;
        }
        if (itemstack == null) {
            return true;
        }
        return this.sameItem(itemstack);
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        this.func_70296_d();
        return this.getStackFromSlot(slot);
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        int stackSize;
        if (slot == 0) {
            throw new RuntimeException("[JABBA] Tried to decr the stack size of the input slot");
        }
        ItemStack stack = this.outputStack.func_77946_l();
        stack.field_77994_a = stackSize = Math.min(quantity, stack.field_77994_a);
        this.outputStack.field_77994_a -= stackSize;
        this.func_70296_d();
        return stack;
    }

    @Override
    public ItemStack decrStackSize_Hopper(int slot, int quantity) {
        int stackSize;
        if (slot == 0) {
            throw new RuntimeException("[JABBA] Tried to decr the stack size of the input slot");
        }
        ItemStack stack = this.outputStack.func_77946_l();
        stack.field_77994_a = stackSize = Math.min(quantity, stack.field_77994_a);
        this.outputStack.field_77994_a -= stackSize;
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        return this.getStackFromSlot(slot);
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        if (slot == 0) {
            this.inputStack = itemstack;
        } else {
            this.outputStack = itemstack;
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "jabba.localstorage";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        if (BetterBarrels.exposeFullStorageSize) {
            return this.totalCapacity;
        }
        return 64;
    }

    public void func_70296_d() {
        if (this.inputStack != null) {
            if (this.itemTemplate == null) {
                this.setItem(this.inputStack);
            }
            if (this.totalCapacity - this.totalAmount > 0) {
                this.totalAmount += this.inputStack.field_77994_a;
                if (this.totalAmount > this.totalCapacity) {
                    this.totalAmount = this.totalCapacity;
                }
            }
            this.inputStack = null;
        }
        if (!this.alwaysProvide && this.prevOutputStack != null) {
            this.totalAmount = this.outputStack != null ? (this.totalAmount -= this.prevOutputStack.field_77994_a - this.outputStack.field_77994_a) : (this.totalAmount -= this.prevOutputStack.field_77994_a);
        }
        if (this.itemTemplate != null) {
            if (this.outputStack == null) {
                this.outputStack = this.itemTemplate.func_77946_l();
            }
            int n = this.outputStack.field_77994_a = this.alwaysProvide ? this.totalCapacity : this.totalAmount;
            if (!BetterBarrels.exposeFullStorageSize) {
                this.outputStack.field_77994_a = Math.min(this.outputStack.field_77994_a, this.stackAmount);
            }
        }
        if (this.totalAmount <= 0 && !this.keepLastItem) {
            this.setItem(null);
            this.outputStack = null;
            this.prevOutputStack = null;
            this.inputStack = null;
        }
        this.prevOutputStack = this.outputStack != null ? this.outputStack.func_77946_l() : null;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this.sameItem(itemstack);
    }

    @Override
    public ItemStack getStoredItemType() {
        if (this.itemTemplate != null) {
            ItemStack stack = this.itemTemplate.func_77946_l();
            stack.field_77994_a = this.alwaysProvide ? this.totalCapacity : this.totalAmount;
            return stack;
        }
        if (this.keepLastItem) {
            return new ItemStack(Blocks.field_150384_bq, 0);
        }
        return null;
    }

    @Override
    public void setStoredItemCount(int amount) {
        if (amount > this.totalCapacity) {
            amount = this.totalCapacity;
        }
        this.totalAmount = amount;
        this.func_70296_d();
    }

    @Override
    public void setStoredItemType(ItemStack type, int amount) {
        this.setItem(type);
        if (amount > this.totalCapacity) {
            amount = this.totalCapacity;
        }
        this.totalAmount = amount;
        this.func_70296_d();
    }

    @Override
    public int getMaxStoredCount() {
        return this.deleteExcess ? this.totalCapacity + this.stackAmount : this.totalCapacity;
    }
}

