/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.client;

import cpw.mods.fml.common.registry.LanguageRegistry;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import mcp.mobius.betterbarrels.BetterBarrels;
import mcp.mobius.betterbarrels.Utils;
import mcp.mobius.betterbarrels.common.StructuralLevel;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class StructuralLevelClientData {
    private AccessibleTextureAtlasSprite iconBlockSide;
    private AccessibleTextureAtlasSprite iconBlockLabel;
    private AccessibleTextureAtlasSprite iconBlockTop;
    private AccessibleTextureAtlasSprite iconBlockTopLabel;
    private AccessibleTextureAtlasSprite iconItem;
    private ItemStack materialStack;
    private StructuralLevel level;
    private int textColor = -1;
    private String name;
    private int colorOverride = -1;
    private static BaseTextures baseTexturePixels;

    public StructuralLevelClientData(StructuralLevel inlevel) {
        this.level = inlevel;
    }

    public IIcon getIconSide() {
        return this.iconBlockSide;
    }

    public IIcon getIconTop() {
        return this.iconBlockTop;
    }

    public IIcon getIconLabel() {
        return this.iconBlockLabel;
    }

    public IIcon getIconLabelTop() {
        return this.iconBlockTopLabel;
    }

    public IIcon getIconItem() {
        return this.iconItem;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public String getMaterialName() {
        return this.name;
    }

    public void setColorOverride(int override) {
        this.colorOverride = override;
    }

    public void cacheStackAndName() {
        BetterBarrels.debug("15 - Looking up user friendly name for " + (this.level.material.isOreDict() ? this.level.material.name : this.level.material.modDomain + ":" + this.level.material.name + ":" + this.level.material.meta));
        this.materialStack = this.level.material.getStack();
        this.name = this.materialStack.func_82833_r();
        if (this.name.indexOf(".name") > 0) {
            this.name = LanguageRegistry.instance().getStringLocalization(this.name);
        }
        BetterBarrels.debug("16 - Found: " + this.name);
    }

    public static void loadBaseTextureData() {
        BetterBarrels.debug("08 - Pre-loading component texture data.");
        baseTexturePixels = new BaseTextures();
        StructuralLevelClientData.baseTexturePixels.labelBorder = StructuralLevelClientData.getPixelsForTexture(false, "JABBA:barrel_label_border");
        StructuralLevelClientData.baseTexturePixels.labelBackground = StructuralLevelClientData.getPixelsForTexture(false, "JABBA:barrel_label_background");
        StructuralLevelClientData.baseTexturePixels.topBorder = StructuralLevelClientData.getPixelsForTexture(false, "JABBA:barrel_top_border");
        StructuralLevelClientData.baseTexturePixels.topBackground = StructuralLevelClientData.getPixelsForTexture(false, "JABBA:barrel_top_background");
        StructuralLevelClientData.baseTexturePixels.topLabel = StructuralLevelClientData.getPixelsForTexture(false, "JABBA:barrel_top_label");
        StructuralLevelClientData.baseTexturePixels.sideBorder = StructuralLevelClientData.getPixelsForTexture(false, "JABBA:barrel_side_border");
        StructuralLevelClientData.baseTexturePixels.sideBackground = StructuralLevelClientData.getPixelsForTexture(false, "JABBA:barrel_side_background");
        StructuralLevelClientData.baseTexturePixels.item = StructuralLevelClientData.getPixelsForTexture(true, "JABBA:capaupg_base");
        StructuralLevelClientData.baseTexturePixels.itemArrow = StructuralLevelClientData.getPixelsForTexture(true, "JABBA:capaupg_color");
    }

    public static void unloadBaseTextureData() {
        BetterBarrels.debug("39 - Unloading preloaded texture data");
        baseTexturePixels = null;
    }

    private static AccessibleTextureAtlasSprite registerIcon(IIconRegister par1IconRegister, String key) {
        TextureMap texmap = (TextureMap)par1IconRegister;
        AccessibleTextureAtlasSprite ret = new AccessibleTextureAtlasSprite(key, texmap.func_130086_a());
        if (texmap.setTextureEntry(key, (TextureAtlasSprite)ret)) {
            return ret;
        }
        return (AccessibleTextureAtlasSprite)texmap.getTextureExtry(key);
    }

    public void registerItemIcon(IIconRegister par1IconRegister, int ordinal) {
        this.iconItem = StructuralLevelClientData.registerIcon(par1IconRegister, "JABBA:blanks/capacity/" + String.valueOf(ordinal));
    }

    public void registerBlockIcons(IIconRegister par1IconRegister, int ordinal) {
        this.iconBlockSide = StructuralLevelClientData.registerIcon(par1IconRegister, "JABBA:barrel_side_" + String.valueOf(ordinal));
        this.iconBlockTop = StructuralLevelClientData.registerIcon(par1IconRegister, "JABBA:barrel_top_" + String.valueOf(ordinal));
        this.iconBlockLabel = StructuralLevelClientData.registerIcon(par1IconRegister, "JABBA:barrel_label_" + String.valueOf(ordinal));
        this.iconBlockTopLabel = StructuralLevelClientData.registerIcon(par1IconRegister, "JABBA:barrel_labeltop_" + String.valueOf(ordinal));
    }

    private void grainMergeArrayWithColor(int[] pixels, PixelARGB color) {
        BetterBarrels.debug("35 - Running grain merge on material with color");
        for (int i = 0; i < pixels.length; ++i) {
            PixelARGB pix = new PixelARGB(pixels[i]);
            pixels[i] = pix.A == 0 ? 0 : (StructuralLevelClientData)this.new PixelARGB((int)255, (int)Math.max((int)0, (int)Math.min((int)255, (int)(pix.R + color.R - 128))), (int)Math.max((int)0, (int)Math.min((int)255, (int)(pix.G + color.G - 128))), (int)Math.max((int)0, (int)Math.min((int)255, (int)(pix.B + color.B - 128)))).combined;
        }
        BetterBarrels.debug("36 - sanity check, pixels.length:" + pixels.length);
    }

    private void mergeArraysBasedOnAlpha(int[] target, int[] merge) {
        for (int i = 0; i < merge.length; ++i) {
            PixelARGB targetPixel = new PixelARGB(target[i]);
            PixelARGB mergePixel = new PixelARGB(merge[i]);
            target[i] = mergePixel.A == 0 ? targetPixel.combined : mergePixel.combined;
        }
    }

    private PixelARGB averageColorFromArray(int[] pixels) {
        PixelARGB totals = new PixelARGB(0);
        for (int pixel : pixels) {
            totals.alphaAdd(new PixelARGB(pixel));
        }
        return totals.normalize();
    }

    private PixelARGB averageColorFromArrayB(int[] pixels) {
        PixelARGB totals = new PixelARGB(0);
        for (int pixel : pixels) {
            totals.addSkipTransparent(new PixelARGB(pixel));
        }
        return totals.normalizeIgnoreAlpha();
    }

    private static int[] getPixelsForTexture(boolean item, ResourceLocation resourcelocation) {
        BetterBarrels.debug("09 - Entering texture load method for texture : " + resourcelocation.toString());
        ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.func_110624_b(), String.format("%s/%s%s", item ? "textures/items" : "textures/blocks", resourcelocation.func_110623_a(), ".png"));
        BetterBarrels.debug("11 - Modified resource path : " + resourcelocation1.toString());
        int[] pixels = null;
        try {
            pixels = TextureUtil.func_110986_a((IResourceManager)Minecraft.func_71410_x().func_110442_L(), (ResourceLocation)resourcelocation1);
        }
        catch (Throwable t) {
            BetterBarrels.log.warn("JABBA-Debug Problem loading texture: " + resourcelocation);
        }
        BetterBarrels.debug("12 - read texture data of length : " + (pixels != null ? Integer.valueOf(pixels.length) : "(null)"));
        return pixels;
    }

    private static int[] getPixelsForTexture(boolean item, String location) {
        return StructuralLevelClientData.getPixelsForTexture(item, new ResourceLocation(location));
    }

    private static int[] getPixelsForTexture(boolean item, IIcon icon) {
        return StructuralLevelClientData.getPixelsForTexture(item, new ResourceLocation(icon.func_94215_i()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generateIcons() {
        block19: {
            boolean foundSourceMaterial;
            int[] materialPixels;
            int[] itemRomanPixels;
            int[] itemArrowPixels;
            int[] itemBasePixels;
            int[] sideBackgroundPixels;
            int[] sideBorderPixels;
            int[] topLabelBackgroundPixels;
            int[] topLabelBorderPixels;
            int[] topBackgroundPixels;
            int[] topBorderPixels;
            int[] labelBackgroundPixels;
            int[] labelBorderPixels;
            int previousTextureID;
            int itemTextureId;
            int terrainTextureId;
            block18: {
                block20: {
                    block16: {
                        BetterBarrels.debug("17 - Entering Texture Generation for Structural Tier: " + this.level);
                        terrainTextureId = Minecraft.func_71410_x().field_71446_o.func_110581_b(TextureMap.field_110575_b).func_110552_b();
                        itemTextureId = Minecraft.func_71410_x().field_71446_o.func_110581_b(TextureMap.field_110576_c).func_110552_b();
                        if (terrainTextureId == 0 || itemTextureId == 0) break block19;
                        previousTextureID = GL11.glGetInteger((int)32873);
                        labelBorderPixels = (int[])StructuralLevelClientData.baseTexturePixels.labelBorder.clone();
                        BetterBarrels.debug("18 - " + labelBorderPixels.length);
                        labelBackgroundPixels = (int[])StructuralLevelClientData.baseTexturePixels.labelBackground.clone();
                        BetterBarrels.debug("19 - " + labelBackgroundPixels.length);
                        topBorderPixels = (int[])StructuralLevelClientData.baseTexturePixels.topBorder.clone();
                        BetterBarrels.debug("20 - " + topBorderPixels.length);
                        topBackgroundPixels = (int[])StructuralLevelClientData.baseTexturePixels.topBackground.clone();
                        BetterBarrels.debug("21 - " + topBackgroundPixels.length);
                        topLabelBorderPixels = (int[])StructuralLevelClientData.baseTexturePixels.topBorder.clone();
                        BetterBarrels.debug("22 - " + topLabelBorderPixels.length);
                        topLabelBackgroundPixels = (int[])StructuralLevelClientData.baseTexturePixels.topLabel.clone();
                        BetterBarrels.debug("23 - " + topLabelBackgroundPixels.length);
                        sideBorderPixels = (int[])StructuralLevelClientData.baseTexturePixels.sideBorder.clone();
                        BetterBarrels.debug("24 - " + sideBorderPixels.length);
                        sideBackgroundPixels = (int[])StructuralLevelClientData.baseTexturePixels.sideBackground.clone();
                        BetterBarrels.debug("25 - " + sideBackgroundPixels.length);
                        itemBasePixels = (int[])StructuralLevelClientData.baseTexturePixels.item.clone();
                        BetterBarrels.debug("26 - " + itemBasePixels.length);
                        itemArrowPixels = (int[])StructuralLevelClientData.baseTexturePixels.itemArrow.clone();
                        BetterBarrels.debug("27 - " + itemArrowPixels.length);
                        itemRomanPixels = StructuralLevelClientData.getPixelsForTexture(true, (IIcon)this.iconItem);
                        BetterBarrels.debug("28 - " + itemRomanPixels.length);
                        materialPixels = null;
                        foundSourceMaterial = false;
                        if (this.colorOverride != -1) break block20;
                        try {
                            while (this.level.material.meta >= 0) {
                                this.cacheStackAndName();
                                Block materialBlock = Block.func_149634_a((Item)this.materialStack.func_77973_b());
                                Item materialItem = this.materialStack.func_77973_b();
                                if (materialBlock != Blocks.field_150350_a && !materialBlock.func_149739_a().equalsIgnoreCase("tile.ForgeFiller")) {
                                    BetterBarrels.debug("32 - Block found");
                                    materialPixels = StructuralLevelClientData.getPixelsForTexture(false, materialBlock.func_149691_a(0, this.materialStack.func_77960_j()));
                                    foundSourceMaterial = true;
                                    BetterBarrels.debug("33 - Loaded texture data for [" + this.name + "]: read an array of length: " + (materialPixels != null ? Integer.valueOf(materialPixels.length) : "(null)"));
                                } else if (materialItem != null) {
                                    BetterBarrels.debug("30 - Item found, attempting to load");
                                    materialPixels = StructuralLevelClientData.getPixelsForTexture(true, materialItem.func_77617_a(this.materialStack.func_77960_j()));
                                    foundSourceMaterial = true;
                                    BetterBarrels.debug("30 - Loaded texture data for [" + this.name + "]: read an array of length: " + (materialPixels != null ? Integer.valueOf(materialPixels.length) : "(null)"));
                                }
                                if (materialPixels != null || !this.level.material.isOreDict()) break;
                                if (this.level.material.meta == -1) continue;
                                ++this.level.material.meta;
                            }
                            if (foundSourceMaterial) break block16;
                            BetterBarrels.log.error("Encountered an issue while locating the requested source material[" + (this.level.material.isOreDict() ? this.level.material.name : this.level.material.modDomain + ":" + this.level.material.name + ":" + this.level.material.meta) + "].  Ore Dictionary returned " + this.materialStack.func_77977_a() + " as the first itemStack for that request.");
                        }
                        catch (Throwable t) {
                            block17: {
                                try {
                                    BetterBarrels.debug("34 - MATERIAL LOOKUP ERROR");
                                    BetterBarrels.log.error("Error loading resource material texture: " + t.getMessage());
                                    t.printStackTrace();
                                    if (foundSourceMaterial) break block17;
                                    BetterBarrels.log.error("Encountered an issue while locating the requested source material[" + (this.level.material.isOreDict() ? this.level.material.name : this.level.material.modDomain + ":" + this.level.material.name + ":" + this.level.material.meta) + "].  Ore Dictionary returned " + this.materialStack.func_77977_a() + " as the first itemStack for that request.");
                                }
                                catch (Throwable throwable) {
                                    if (!foundSourceMaterial) {
                                        BetterBarrels.log.error("Encountered an issue while locating the requested source material[" + (this.level.material.isOreDict() ? this.level.material.name : this.level.material.modDomain + ":" + this.level.material.name + ":" + this.level.material.meta) + "].  Ore Dictionary returned " + this.materialStack.func_77977_a() + " as the first itemStack for that request.");
                                    } else if (materialPixels == null) {
                                        materialPixels = new int[1];
                                        BetterBarrels.debug("13 - No texture data read, creating empty array of for color black");
                                    }
                                    throw throwable;
                                }
                                break block18;
                            }
                            if (materialPixels == null) {
                                materialPixels = new int[1];
                                BetterBarrels.debug("13 - No texture data read, creating empty array of for color black");
                            }
                            break block18;
                        }
                        break block18;
                    }
                    if (materialPixels == null) {
                        materialPixels = new int[1];
                        BetterBarrels.debug("13 - No texture data read, creating empty array of for color black");
                    }
                    break block18;
                }
                materialPixels = new int[]{this.colorOverride};
                foundSourceMaterial = true;
            }
            if (foundSourceMaterial) {
                PixelARGB color = this.averageColorFromArrayB(materialPixels);
                BetterBarrels.debug("Calculated Color for [" + this.name + "]: {R: " + color.R + ", G: " + color.G + ", B: " + color.B + "}");
                this.textColor = color.YIQContrastTextColor().combined;
                this.grainMergeArrayWithColor(labelBorderPixels, color);
                this.grainMergeArrayWithColor(topBorderPixels, color);
                this.grainMergeArrayWithColor(topLabelBorderPixels, color);
                this.grainMergeArrayWithColor(sideBorderPixels, color);
                this.grainMergeArrayWithColor(itemArrowPixels, color);
                this.textColor = this.averageColorFromArrayB((int[])labelBorderPixels).YIQContrastTextColor().combined;
                int mipmapLevels = Utils.ReflectionHelper.getFieldValue(Integer.class, Minecraft.func_71410_x().field_71474_y.field_151442_I, Minecraft.func_71410_x().func_147117_R(), TextureMap.class, new String[]{"j", "field_147636_j", "mipmapLevels"}, Level.WARN, "Unable to reflect Block TextureMap mipmapLevels. Defaulting to GameSettings mipmapLevels");
                try {
                    this.mergeArraysBasedOnAlpha(labelBorderPixels, labelBackgroundPixels);
                    this.mergeArraysBasedOnAlpha(topBorderPixels, topBackgroundPixels);
                    this.mergeArraysBasedOnAlpha(topLabelBorderPixels, topLabelBackgroundPixels);
                    this.mergeArraysBasedOnAlpha(sideBorderPixels, sideBackgroundPixels);
                    this.mergeArraysBasedOnAlpha(itemBasePixels, itemArrowPixels);
                    this.mergeArraysBasedOnAlpha(itemBasePixels, itemRomanPixels);
                    GL11.glPushAttrib((int)1048575);
                    GL11.glBindTexture((int)3553, (int)terrainTextureId);
                    this.iconBlockLabel.replaceTextureData(labelBorderPixels, mipmapLevels);
                    this.iconBlockTop.replaceTextureData(topBorderPixels, mipmapLevels);
                    this.iconBlockTopLabel.replaceTextureData(topLabelBorderPixels, mipmapLevels);
                    this.iconBlockSide.replaceTextureData(sideBorderPixels, mipmapLevels);
                    GL11.glBindTexture((int)3553, (int)itemTextureId);
                    this.iconItem.replaceTextureData(itemBasePixels, 0);
                    GL11.glBindTexture((int)3553, (int)previousTextureID);
                    GL11.glPopAttrib();
                    return true;
                }
                catch (Exception e) {
                    BetterBarrels.log.error("caught exception while generating icons: " + e.toString() + e.getMessage());
                }
            }
        }
        return false;
    }

    private class PixelARGB {
        int A;
        int R;
        int G;
        int B;
        int combined;
        private int addCount = 0;

        PixelARGB(int pixel) {
            this.A = pixel >> 24 & 0xFF;
            this.R = pixel >> 16 & 0xFF;
            this.G = pixel >> 8 & 0xFF;
            this.B = pixel & 0xFF;
            this.combined = pixel;
        }

        PixelARGB(int alpha, int red, int green, int blue) {
            this.A = alpha;
            this.R = red;
            this.G = green;
            this.B = blue;
            this.combined = ((this.A & 0xFF) << 24) + ((this.R & 0xFF) << 16) + ((this.G & 0xFF) << 8) + (this.B & 0xFF);
        }

        PixelARGB alphaAdd(PixelARGB add) {
            ++this.addCount;
            this.A += add.A;
            this.R += add.R * add.A / 255;
            this.G += add.G * add.G / 255;
            this.B += add.B * add.B / 255;
            this.combined = ((this.A & 0xFF) << 24) + ((this.R & 0xFF) << 16) + ((this.G & 0xFF) << 8) + (this.B & 0xFF);
            return this;
        }

        PixelARGB normalize() {
            if (this.addCount == 0) {
                return this;
            }
            this.R = this.R * 255 / this.A;
            this.G = this.G * 255 / this.A;
            this.B = this.B * 255 / this.A;
            this.A /= this.addCount;
            this.combined = ((this.A & 0xFF) << 24) + ((this.R & 0xFF) << 16) + ((this.G & 0xFF) << 8) + (this.B & 0xFF);
            this.addCount = 0;
            return this;
        }

        PixelARGB addIgnoreAlpha(PixelARGB add) {
            ++this.addCount;
            this.R += add.R;
            this.G += add.G;
            this.B += add.B;
            this.combined = ((this.A & 0xFF) << 24) + ((this.R & 0xFF) << 16) + ((this.G & 0xFF) << 8) + (this.B & 0xFF);
            return this;
        }

        PixelARGB addSkipTransparent(PixelARGB add) {
            if (add.A == 0) {
                return this;
            }
            ++this.addCount;
            this.R += add.R;
            this.G += add.G;
            this.B += add.B;
            this.combined = ((this.A & 0xFF) << 24) + ((this.R & 0xFF) << 16) + ((this.G & 0xFF) << 8) + (this.B & 0xFF);
            return this;
        }

        PixelARGB normalizeIgnoreAlpha() {
            if (this.addCount == 0) {
                return this;
            }
            this.R /= this.addCount;
            this.G /= this.addCount;
            this.B /= this.addCount;
            this.combined = ((this.A & 0xFF) << 24) + ((this.R & 0xFF) << 16) + ((this.G & 0xFF) << 8) + (this.B & 0xFF);
            this.addCount = 0;
            return this;
        }

        PixelARGB YIQContrastTextColor() {
            int color = (this.R * 299 + this.G * 587 + this.B * 114) / 1000 >= 128 ? 0 : 255;
            return new PixelARGB(255, color, color, color);
        }
    }

    private static class AccessibleTextureAtlasSprite
    extends TextureAtlasSprite {
        protected int textureType;
        private static Method fixPixels = Utils.ReflectionHelper.getMethod(TextureAtlasSprite.class, new String[]{"a", "func_147961_a", "fixTransparentPixels"}, new Class[]{int[][].class}, Level.ERROR, "Unable to locate required method 'fixTransparentPixels' for texture generation.  Please post this error at the error tracker along with a copy of your ForgeModLoader-client-0.log.");
        private static Method setupAnisotropic = Utils.ReflectionHelper.getMethod(TextureAtlasSprite.class, new String[]{"a", "func_147960_a", "prepareAnisotropicFiltering"}, new Class[]{int[][].class, Integer.TYPE, Integer.TYPE}, Level.ERROR, "Unable to locate required method 'prepareAnisotropicFiltering' for texture generation.  Please post this error at the error tracker along with a copy of your ForgeModLoader-client-0.log.");
        private static Field useAnisotropic = Utils.ReflectionHelper.getField(TextureAtlasSprite.class, new String[]{"k", "field_147966_k", "useAnisotropicFiltering"}, Level.ERROR, "Unable to locate required field 'useAnisotropicFiltering' for texture generation.  Please post this error at the error tracker along with a copy of your ForgeModLoader-client-0.log.");
        private static Field texmapMipMapLevels = Utils.ReflectionHelper.getField(TextureMap.class, new String[]{"j", "field_147636_j", "mipmapLevels"});
        private static Field texmapAnisotropic = Utils.ReflectionHelper.getField(TextureMap.class, new String[]{"k", "field_147637_k", "anisotropicFiltering"});

        AccessibleTextureAtlasSprite(String par1Str, int textype) {
            super(par1Str);
            this.textureType = textype;
        }

        public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
            return this.textureType != 1 && !location.func_110623_a().endsWith("0");
        }

        public boolean load(IResourceManager manager, ResourceLocation location) {
            try {
                boolean useanisotropicFiltering = this.textureType == 0 ? (float)texmapAnisotropic.getInt(Minecraft.func_71410_x().func_147117_R()) > 1.0f : false;
                int mipmapLevels = this.textureType == 0 ? texmapMipMapLevels.getInt(Minecraft.func_71410_x().func_147117_R()) : 0;
                BufferedImage[] abufferedimage = new BufferedImage[1 + mipmapLevels];
                abufferedimage[0] = ImageIO.read(manager.func_110536_a(new ResourceLocation(location.func_110624_b(), this.textureType == 0 ? "textures/blocks/barrel_top_border.png" : "textures/items/capaupg_base.png")).func_110527_b());
                this.func_147964_a(abufferedimage, null, useanisotropicFiltering);
                return false;
            }
            catch (Throwable t) {
                BetterBarrels.log.error((Object)t);
                return true;
            }
        }

        public void replaceTextureData(int[] pixels, int mipmapLevels) throws Exception {
            BetterBarrels.debug("37p1 - entering texture replacement with " + mipmapLevels + " mipmap levels.");
            Object aint = new int[1 + mipmapLevels][];
            aint[0] = pixels;
            fixPixels.invoke((Object)this, aint);
            boolean useAnisotropic = AccessibleTextureAtlasSprite.useAnisotropic.getBoolean((Object)this);
            aint = (int[][])setupAnisotropic.invoke((Object)this, aint, useAnisotropic ? this.field_130223_c - 16 : this.field_130223_c, useAnisotropic ? this.field_130224_d - 16 : this.field_130224_d);
            aint = TextureUtil.func_147949_a((int)mipmapLevels, (int)this.field_130223_c, (int[][])aint);
            BetterBarrels.debug("37 - Attempting to replace texture for [" + this.func_94215_i() + "] with an array of [" + (aint != null ? Integer.valueOf(aint[0].length) : "(null)") + "] pixels, current texture dims are [" + this.field_130223_c + "x" + this.field_130224_d + "] for a total size of " + this.field_130223_c * this.field_130224_d);
            BetterBarrels.debug(this.toString());
            if (aint[0].length != this.field_130224_d * this.field_130223_c) {
                throw new Exception("Attempting to replace texture image data with " + (aint[0].length > this.field_130224_d * this.field_130223_c ? "too much" : "too little") + " data.");
            }
            BetterBarrels.debug("38 - Calling Minecraft Texture upload utility method");
            TextureUtil.func_147955_a((int[][])aint, (int)this.field_130223_c, (int)this.field_130224_d, (int)this.field_110975_c, (int)this.field_110974_d, (boolean)false, (boolean)false);
            this.func_130103_l();
        }
    }

    private static class BaseTextures {
        public int[] labelBackground;
        public int[] labelBorder;
        public int[] topBackground;
        public int[] topBorder;
        public int[] topLabel;
        public int[] sideBackground;
        public int[] sideBorder;
        public int[] item;
        public int[] itemArrow;

        private BaseTextures() {
        }
    }
}

