/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import mcp.mobius.betterbarrels.BetterBarrels;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class Utils {
    private static Field chunkCacheWorld = ReflectionHelper.getField(ChunkCache.class, new String[]{"e", "field_72815_e", "worldObj"});

    public static void dropItemInWorld(TileEntity source, EntityPlayer player, ItemStack stack, double speedfactor) {
        int hitOrientation = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        double stackCoordX = 0.0;
        double stackCoordY = 0.0;
        double stackCoordZ = 0.0;
        switch (hitOrientation) {
            case 0: {
                stackCoordX = (double)source.field_145851_c + 0.5;
                stackCoordY = (double)source.field_145848_d + 0.5;
                stackCoordZ = (double)source.field_145849_e - 0.25;
                break;
            }
            case 1: {
                stackCoordX = (double)source.field_145851_c + 1.25;
                stackCoordY = (double)source.field_145848_d + 0.5;
                stackCoordZ = (double)source.field_145849_e + 0.5;
                break;
            }
            case 2: {
                stackCoordX = (double)source.field_145851_c + 0.5;
                stackCoordY = (double)source.field_145848_d + 0.5;
                stackCoordZ = (double)source.field_145849_e + 1.25;
                break;
            }
            case 3: {
                stackCoordX = (double)source.field_145851_c - 0.25;
                stackCoordY = (double)source.field_145848_d + 0.5;
                stackCoordZ = (double)source.field_145849_e + 0.5;
            }
        }
        EntityItem droppedEntity = new EntityItem(source.func_145831_w(), stackCoordX, stackCoordY, stackCoordZ, stack);
        if (player != null) {
            Vec3 motion = Vec3.func_72443_a((double)(player.field_70165_t - stackCoordX), (double)(player.field_70163_u - stackCoordY), (double)(player.field_70161_v - stackCoordZ));
            motion.func_72432_b();
            droppedEntity.field_70159_w = motion.field_72450_a;
            droppedEntity.field_70181_x = motion.field_72448_b;
            droppedEntity.field_70179_y = motion.field_72449_c;
            double offset = 0.25;
            droppedEntity.func_70091_d(motion.field_72450_a * offset, motion.field_72448_b * offset, motion.field_72449_c * offset);
        }
        droppedEntity.field_70159_w *= speedfactor;
        droppedEntity.field_70181_x *= speedfactor;
        droppedEntity.field_70179_y *= speedfactor;
        source.func_145831_w().func_72838_d((Entity)droppedEntity);
    }

    public static ForgeDirection getDirectionFacingEntity(EntityLivingBase player, boolean allowVertical) {
        Vec3 playerLook = player.func_70040_Z();
        if (allowVertical) {
            if (playerLook.field_72448_b <= (double)(-BetterBarrels.verticalPlacementRange)) {
                return ForgeDirection.UP;
            }
            if (playerLook.field_72448_b >= (double)BetterBarrels.verticalPlacementRange) {
                return ForgeDirection.DOWN;
            }
        }
        if (Math.abs(playerLook.field_72450_a) >= Math.abs(playerLook.field_72449_c)) {
            if (playerLook.field_72450_a > 0.0) {
                return ForgeDirection.WEST;
            }
            return ForgeDirection.EAST;
        }
        if (playerLook.field_72449_c > 0.0) {
            return ForgeDirection.NORTH;
        }
        return ForgeDirection.SOUTH;
    }

    public static String romanNumeral(int num) {
        LinkedHashMap<String, Integer> numeralConversion = new LinkedHashMap<String, Integer>();
        numeralConversion.put("M", 1000);
        numeralConversion.put("CM", 900);
        numeralConversion.put("D", 500);
        numeralConversion.put("CD", 400);
        numeralConversion.put("C", 100);
        numeralConversion.put("XC", 90);
        numeralConversion.put("L", 50);
        numeralConversion.put("XL", 40);
        numeralConversion.put("X", 10);
        numeralConversion.put("IX", 9);
        numeralConversion.put("V", 5);
        numeralConversion.put("IV", 4);
        numeralConversion.put("I", 1);
        String result = new String();
        while (numeralConversion.size() > 0) {
            String romanKey = (String)numeralConversion.keySet().toArray()[0];
            Integer arabicValue = (Integer)numeralConversion.values().toArray()[0];
            if (num < arabicValue) {
                numeralConversion.remove(romanKey);
                continue;
            }
            num -= arabicValue.intValue();
            result = result + romanKey;
        }
        return result;
    }

    public static TileEntity getTileEntityPreferNotCreating(IBlockAccess blockAccess, int x, int y, int z) {
        if (blockAccess instanceof World) {
            return Utils.getTileEntityWithoutCreating((World)blockAccess, x, y, z);
        }
        if (blockAccess instanceof ChunkCache) {
            return Utils.getTileEntityWithoutCreating((ChunkCache)blockAccess, x, y, z);
        }
        return blockAccess.func_147438_o(x, y, z);
    }

    public static TileEntity getTileEntityWithoutCreating(ChunkCache chunkCache, int x, int y, int z) {
        try {
            return Utils.getTileEntityWithoutCreating((World)chunkCacheWorld.get(chunkCache), x, y, z);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static TileEntity getTileEntityWithoutCreating(World world, int x, int y, int z) {
        return world.func_72938_d(x, z).getTileEntityUnsafe(x & 0xF, y, z & 0xF);
    }

    public static class ReflectionHelper {
        public static Method getMethod(Class targetClass, String[] targetNames, Class[] targetParams) {
            return ReflectionHelper.getMethod(targetClass, targetNames, targetParams, Level.ERROR, "Unable to reflect requested method[" + targetNames.toString() + "] with a paramter signature of [" + targetParams.toString() + "] in class[" + targetClass.getCanonicalName() + "]");
        }

        public static Method getMethod(Class targetClass, String[] targetNames, Class[] targetParams, Level errorLevel, String errorMessage) {
            Method foundMethod = null;
            for (String methodName : targetNames) {
                try {
                    foundMethod = targetClass.getDeclaredMethod(methodName, targetParams);
                    if (foundMethod == null) continue;
                    foundMethod.setAccessible(true);
                    break;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (foundMethod == null && errorMessage != null) {
                BetterBarrels.log.log(errorLevel, errorMessage);
            }
            return foundMethod;
        }

        public static Field getField(Class targetClass, String[] targetNames) {
            return ReflectionHelper.getField(targetClass, targetNames, Level.ERROR, "Unable to reflect requested field[" + targetNames.toString() + "] in class[" + targetClass.getCanonicalName() + "]");
        }

        public static Field getField(Class targetClass, String[] targetNames, Level errorLevel, String errorMessage) {
            Field foundField = null;
            for (String fieldName : targetNames) {
                try {
                    foundField = targetClass.getDeclaredField(fieldName);
                    if (foundField == null) continue;
                    foundField.setAccessible(true);
                    break;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (foundField == null && errorMessage != null) {
                BetterBarrels.log.log(errorLevel, errorMessage);
            }
            return foundField;
        }

        public static <T> T getFieldValue(Class<T> returnType, Object targetObject, Class targetClass, String[] targetNames) {
            if (!returnType.isPrimitive()) {
                return ReflectionHelper.getFieldValue(returnType, null, targetObject, targetClass, targetNames, Level.ERROR, "Unable to reflect and return value for requested field[" + targetNames.toString() + "] in class[" + targetClass.getCanonicalName() + "], defaulting to null or 0");
            }
            return ReflectionHelper.getFieldValue(returnType, returnType.cast(0), targetObject, targetClass, targetNames, Level.ERROR, "Unable to reflect and return value for requested field[" + targetNames.toString() + "] in class[" + targetClass.getCanonicalName() + "], defaulting to null or 0");
        }

        public static <T> T getFieldValue(Class<T> returnType, T errorValue, Object targetObject, Class targetClass, String[] targetNames, Level errorLevel, String errorMessage) {
            T returnValue = errorValue;
            Field foundField = ReflectionHelper.getField(targetClass, targetNames, errorLevel, errorMessage);
            if (foundField != null) {
                try {
                    returnValue = returnType.cast(foundField.get(targetObject));
                    BetterBarrels.debug("Reflected field [" + foundField.getName() + "] and found value [" + returnValue + "], had a backup value of " + errorValue);
                }
                catch (Throwable t) {
                    BetterBarrels.log.error("Unable to cast found field [" + foundField.getName() + "] to return type [" + returnType.getName() + "]. Defaulting to provided error value.");
                }
            }
            return returnValue;
        }
    }

    public static class Material {
        public String name;
        public String modDomain;
        public int meta = 0;
        ArrayList<ItemStack> ores = null;
        static final ItemStack portalStack = new ItemStack((Block)Blocks.field_150427_aO);

        public Material(String in) {
            if (in.contains("Ore.")) {
                this.name = in.split("\\.")[1];
            } else if (in.contains(":")) {
                int splitCh = in.indexOf(58);
                this.modDomain = in.substring(0, splitCh);
                String itemStr = in.substring(splitCh + 1, in.length());
                int metaCh = itemStr.indexOf(58);
                int wildCh = itemStr.indexOf(42);
                if (metaCh >= 0) {
                    this.meta = wildCh == metaCh + 1 ? Short.MAX_VALUE : Integer.parseInt(itemStr.substring(metaCh + 1, itemStr.length()));
                    this.name = itemStr.substring(0, metaCh);
                } else {
                    this.name = itemStr;
                    this.meta = 0;
                }
            } else {
                BetterBarrels.log.error("Unable to parse input string into oreDict or item:" + in);
            }
        }

        public boolean isOreDict() {
            return this.name != null && this.modDomain == null;
        }

        public ItemStack getStack() {
            ItemStack ret = portalStack;
            if (this.isOreDict()) {
                if (this.ores == null) {
                    this.ores = OreDictionary.getOres((String)this.name);
                }
                if (this.ores.size() > 0) {
                    if (this.meta >= this.ores.size()) {
                        this.meta = -1;
                    }
                    ret = this.ores.get(this.meta >= 0 ? this.meta : 0);
                }
                BetterBarrels.debug("05 - Looking up [" + this.name + "] and found: " + ret.func_82833_r());
            } else {
                try {
                    ret = new ItemStack((Item)Item.field_150901_e.func_82594_a(this.modDomain + ":" + this.name), 1, this.meta);
                    BetterBarrels.debug("05 - Looking up [" + this.modDomain + ":" + this.name + ":" + this.meta + "] and found: " + ret.func_82833_r());
                }
                catch (Throwable t) {
                    BetterBarrels.log.error("Error while trying to initialize material with name " + this.modDomain + ":" + this.name + ":" + this.meta);
                }
            }
            return ret;
        }
    }
}

