/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Arrays;
import java.util.WeakHashMap;
import mcp.mobius.betterbarrels.BetterBarrels;
import mcp.mobius.betterbarrels.bspace.BSpaceStorageHandler;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;

public enum ServerTickHandler {
    INSTANCE;

    private WeakHashMap<TileEntityBarrel, Boolean> dirtyBarrels = new WeakHashMap();
    public Timer timer = new Timer(BetterBarrels.limiterDelay);

    @SubscribeEvent
    public void tickServer(TickEvent.ServerTickEvent event) {
        if (this.timer.isDone() && this.dirtyBarrels.size() > 0) {
            for (TileEntityBarrel barrel : (TileEntityBarrel[])Arrays.copyOf(this.dirtyBarrels.keySet().toArray(), this.dirtyBarrels.size(), TileEntityBarrel[].class)) {
                if (barrel == null) continue;
                barrel.markDirtyExec();
            }
            this.dirtyBarrels.clear();
        }
    }

    public void markDirty(TileEntityBarrel barrel) {
        this.markDirty(barrel, true);
    }

    public void markDirty(TileEntityBarrel barrel, boolean bspace) {
        this.dirtyBarrels.put(barrel, true);
        if (bspace && barrel.coreUpgrades.hasEnder && !barrel.func_145831_w().field_72995_K) {
            BSpaceStorageHandler.instance().markAllDirty(barrel.id);
        }
    }

    class Timer {
        private long interval;
        private long lastTick = System.nanoTime();

        public Timer(long interval) {
            this.interval = interval * 1000L * 1000L;
        }

        public boolean isDone() {
            boolean done;
            long time = System.nanoTime();
            long delta = time - this.lastTick - this.interval;
            boolean bl = done = delta >= 0L;
            if (!done) {
                return false;
            }
            this.lastTick = time - delta;
            return true;
        }
    }
}

