/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.railcraft;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;
import tonius.neiintegration.railcraft.RecipeHandlerRollingMachine;

public class RecipeHandlerRollingMachineShapeless
extends RecipeHandlerRollingMachine {
    private static int[][] INPUTS = new int[][]{{0, 0}, {1, 0}, {0, 1}, {1, 1}, {0, 2}, {1, 2}, {2, 0}, {2, 1}, {2, 2}};

    @Override
    public String getRecipeSubName() {
        return Utils.translate("shapeless");
    }

    private CachedRollingMachineShapelessRecipe getCachedRecipe(IRecipe irecipe, boolean genPerms) {
        CachedRollingMachineShapelessRecipe recipe = null;
        if (irecipe instanceof ShapelessRecipes) {
            recipe = new CachedRollingMachineShapelessRecipe(((ShapelessRecipes)irecipe).field_77579_b, ((ShapelessRecipes)irecipe).func_77571_b());
        } else if (irecipe instanceof ShapelessOreRecipe) {
            recipe = this.getCachedOreRecipe((ShapelessOreRecipe)irecipe, genPerms);
        }
        return recipe;
    }

    private CachedRollingMachineShapelessRecipe getCachedOreRecipe(ShapelessOreRecipe recipe, boolean genPerms) {
        ArrayList items = recipe.getInput();
        for (Object item : items) {
            if (!(item instanceof List) || !((List)item).isEmpty()) continue;
            return null;
        }
        return new CachedRollingMachineShapelessRecipe(items, recipe.func_77571_b(), genPerms);
    }

    @Override
    public void loadAllRecipes() {
        for (IRecipe irecipe : RailcraftCraftingManager.rollingMachine.getRecipeList()) {
            CachedRollingMachineShapelessRecipe recipe = this.getCachedRecipe(irecipe, true);
            if (recipe == null) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (IRecipe irecipe : RailcraftCraftingManager.rollingMachine.getRecipeList()) {
            CachedRollingMachineShapelessRecipe recipe;
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result) || (recipe = this.getCachedRecipe(irecipe, true)) == null) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRecipe irecipe : RailcraftCraftingManager.rollingMachine.getRecipeList()) {
            CachedRollingMachineShapelessRecipe recipe = this.getCachedRecipe(irecipe, false);
            if (recipe == null || !recipe.contains(recipe.inputs, ingredient)) continue;
            recipe.generatePermutations();
            recipe.setIngredientPermutation(recipe.inputs, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public class CachedRollingMachineShapelessRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedStack> inputs = new ArrayList<PositionedStack>();
        public PositionedStack output;

        public CachedRollingMachineShapelessRecipe(ItemStack output) {
            this.output = new PositionedStack((Object)output, 88, 16);
        }

        public CachedRollingMachineShapelessRecipe(List<?> input, ItemStack output, boolean genPerms) {
            this(output);
            this.setIngredients(input);
            if (genPerms) {
                this.generatePermutations();
            }
        }

        public CachedRollingMachineShapelessRecipe(List<?> input, ItemStack output) {
            this(input, output, false);
        }

        public CachedRollingMachineShapelessRecipe(Object[] input, ItemStack output, boolean genPerms) {
            this(Arrays.asList(input), output, genPerms);
        }

        public CachedRollingMachineShapelessRecipe(Object[] input, ItemStack output) {
            this(input, output, false);
        }

        public void setIngredients(List<?> items) {
            this.inputs.clear();
            for (int ingred = 0; ingred < items.size(); ++ingred) {
                PositionedStack stack = new PositionedStack(items.get(ingred), 25 + INPUTS[ingred][0] * 18, 6 + INPUTS[ingred][1] * 18);
                stack.setMaxSize(1);
                this.inputs.add(stack);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(RecipeHandlerRollingMachineShapeless.this.cycleticks / 20, this.inputs);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public void generatePermutations() {
            for (PositionedStack p : this.inputs) {
                p.generatePermutations();
            }
        }
    }
}

