/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.railcraft;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import tonius.neiintegration.PositionedStackAdv;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerRockCrusher
extends RecipeHandlerBase {
    private static final int[][] RESULTS = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};
    private static Class<? extends GuiContainer> guiClass;

    @Override
    public void prepare() {
        guiClass = Utils.getClass("mods.railcraft.client.gui.GuiRockCrusher");
        API.setGuiOffset(guiClass, (int)-3, (int)11);
    }

    public String getRecipeName() {
        return Utils.translate("tile.railcraft.machine.alpha.rock.crusher.name", false);
    }

    @Override
    public String getRecipeID() {
        return "railcraft.rockcrusher";
    }

    public String getGuiTexture() {
        return "railcraft:textures/gui/gui_crusher.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(68, 9, 29, 53);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiClass;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)9, (int)0, (int)5, (int)11, (int)146, (int)65);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(68, 9, 176, 0, 29, 53, 48, 0);
    }

    @Override
    public void loadAllRecipes() {
        for (IRockCrusherRecipe recipe : RailcraftCraftingManager.rockCrusher.getRecipes()) {
            this.arecipes.add(new CachedRockCrusherRecipe(recipe));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        block0: for (IRockCrusherRecipe recipe : RailcraftCraftingManager.rockCrusher.getRecipes()) {
            for (Map.Entry output : recipe.getOutputs()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ItemStack)output.getKey()), (ItemStack)result)) continue;
                this.arecipes.add(new CachedRockCrusherRecipe(recipe));
                continue block0;
            }
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRockCrusherRecipe irecipe : RailcraftCraftingManager.rockCrusher.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getInput(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new CachedRockCrusherRecipe(irecipe));
        }
    }

    public class CachedRockCrusherRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedStack input;
        public List<PositionedStack> outputs = new ArrayList<PositionedStack>();

        public CachedRockCrusherRecipe(IRockCrusherRecipe recipe) {
            this.input = new PositionedStack((Object)recipe.getInput(), 12, 10);
            this.setResults(recipe.getOutputs());
        }

        private void setResults(List<Map.Entry<ItemStack, Float>> outputs) {
            int i = 0;
            for (Map.Entry<ItemStack, Float> output : outputs) {
                if (i >= RESULTS.length) {
                    return;
                }
                this.outputs.add(new PositionedStackAdv(output.getKey(), 102 + RESULTS[i][0] * 18, 10 + RESULTS[i][1] * 18).setChance(output.getValue().floatValue()));
                ++i;
            }
        }

        public PositionedStack getIngredient() {
            this.randomRenderPermutation(this.input, RecipeHandlerRockCrusher.this.cycleticks / 20);
            return this.input;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

