/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.forestry;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import forestry.core.utils.ShapedRecipeCustom;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerShapedCustom
extends RecipeHandlerBase {
    @Override
    public String getRecipeID() {
        return "crafting";
    }

    public String getRecipeName() {
        return Utils.translate("handler.forestryShaped");
    }

    public String getGuiTexture() {
        return "minecraft:textures/gui/container/crafting_table.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(84, 23, 24, 18);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrafting.class;
    }

    public String getOverlayIdentifier() {
        return this.getRecipeID();
    }

    @Override
    public void loadAllRecipes() {
        for (Object recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!(recipe instanceof ShapedRecipeCustom)) continue;
            this.arecipes.add(new CachedShapedCustomRecipe((ShapedRecipeCustom)recipe, true));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (Object recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!(recipe instanceof ShapedRecipeCustom) || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ShapedRecipeCustom)recipe).func_77571_b(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedShapedCustomRecipe((ShapedRecipeCustom)recipe, true));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (Object recipe : CraftingManager.func_77594_a().func_77592_b()) {
            CachedShapedCustomRecipe crecipe;
            if (!(recipe instanceof ShapedRecipeCustom) || !(crecipe = new CachedShapedCustomRecipe((ShapedRecipeCustom)recipe)).contains(crecipe.inputs, ingredient)) continue;
            crecipe.generatePermutations();
            crecipe.setIngredientPermutationNBT(crecipe.inputs, ingredient);
            this.arecipes.add(crecipe);
        }
    }

    public class CachedShapedCustomRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedStack> inputs = new ArrayList<PositionedStack>();
        public PositionedStack output;

        public CachedShapedCustomRecipe(ShapedRecipeCustom recipe, boolean genPerms) {
            this.setIngredients(recipe.getWidth(), recipe.getHeight(), recipe.getIngredients());
            this.output = new PositionedStack((Object)recipe.func_77571_b(), 119, 24);
            if (genPerms) {
                this.generatePermutations();
            }
        }

        public CachedShapedCustomRecipe(ShapedRecipeCustom recipe) {
            this(recipe, false);
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.inputs.add(stack);
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(RecipeHandlerShapedCustom.this.cycleticks / 20, this.inputs);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public void generatePermutations() {
            for (PositionedStack p : this.inputs) {
                p.generatePermutations();
            }
        }
    }
}

