/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.forestry;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.factory.gadgets.MachineFabricator;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import tonius.neiintegration.PositionedFluidTank;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerFabricator
extends RecipeHandlerBase {
    private static Class<? extends GuiContainer> guiClass;
    private static Map<Fluid, List<ItemStack>> smeltingInputs;

    @Override
    public void prepare() {
        guiClass = Utils.getClass("forestry.factory.gui.GuiFabricator");
        for (MachineFabricator.Smelting smelting : MachineFabricator.RecipeManager.smeltings) {
            Fluid fluid = smelting.getProduct().getFluid();
            if (!smeltingInputs.containsKey(fluid)) {
                smeltingInputs.put(fluid, new ArrayList());
            }
            smeltingInputs.get(fluid).add(smelting.getResource());
        }
    }

    @Override
    public String getRecipeID() {
        return "forestry.fabricator";
    }

    public String getRecipeName() {
        return Utils.translate("tile.for.factory2.0.name", false);
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/fabricator.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(117, 44, 14, 13);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiClass;
    }

    @Override
    public void loadAllRecipes() {
        for (MachineFabricator.Recipe recipe : MachineFabricator.RecipeManager.recipes) {
            this.arecipes.add(new CachedFabricatorRecipe(recipe, true));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (MachineFabricator.Recipe recipe : MachineFabricator.RecipeManager.recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.asIRecipe().func_77571_b(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedFabricatorRecipe(recipe, true));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        super.loadUsageRecipes(ingred);
        for (MachineFabricator.Recipe recipe : MachineFabricator.RecipeManager.recipes) {
            CachedFabricatorRecipe crecipe = new CachedFabricatorRecipe(recipe);
            if (!crecipe.contains(crecipe.inputs, ingred) && !crecipe.contains(crecipe.smeltingInput, ingred)) continue;
            crecipe.generatePermutations();
            crecipe.setIngredientPermutation(crecipe.inputs, ingred);
            crecipe.setIngredientPermutation(crecipe.smeltingInput, ingred);
            this.arecipes.add(crecipe);
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        for (MachineFabricator.Recipe recipe : MachineFabricator.RecipeManager.recipes) {
            if (!Utils.areFluidsSameType(recipe.getLiquid(), ingredient)) continue;
            this.arecipes.add(new CachedFabricatorRecipe(recipe, true));
        }
    }

    static {
        smeltingInputs = new HashMap<Fluid, List<ItemStack>>();
    }

    public class CachedFabricatorRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedStack> smeltingInput = new ArrayList<PositionedStack>();
        public PositionedFluidTank tank;
        public List<PositionedStack> inputs = new ArrayList<PositionedStack>();
        public PositionedStack output;

        public CachedFabricatorRecipe(MachineFabricator.Recipe recipe, boolean genPerms) {
            List smeltingInput;
            this.tank = new PositionedFluidTank(recipe.getLiquid(), 2000, new Rectangle(21, 37, 16, 16));
            ShapedRecipeCustom irecipe = (ShapedRecipeCustom)recipe.asIRecipe();
            this.setIngredients(irecipe.getWidth(), irecipe.getHeight(), irecipe.getIngredients());
            if (recipe.getPlan() != null) {
                this.inputs.add(new PositionedStack((Object)recipe.getPlan(), 134, 6));
            }
            if ((smeltingInput = (List)smeltingInputs.get(recipe.getLiquid().getFluid())) != null && !smeltingInput.isEmpty()) {
                this.smeltingInput.add(new PositionedStack((Object)smeltingInput, 21, 10));
            }
            this.output = new PositionedStack((Object)recipe.asIRecipe().func_77571_b(), 134, 42);
            if (genPerms) {
                this.generatePermutations();
            }
        }

        public CachedFabricatorRecipe(MachineFabricator.Recipe recipe) {
            this(recipe, false);
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], 62 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.inputs.add(stack);
                }
            }
        }

        public List<PositionedStack> getOtherStacks() {
            return this.getCycledIngredients(RecipeHandlerFabricator.this.cycleticks / 40, this.smeltingInput);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(RecipeHandlerFabricator.this.cycleticks / 20, this.inputs);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.tank;
        }

        public void generatePermutations() {
            for (PositionedStack p : this.inputs) {
                p.generatePermutations();
            }
        }
    }
}

