/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.buildcraft;

import buildcraft.api.facades.IFacadeItem;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.recipes.IFlexibleRecipeViewable;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerAssemblyTable
extends RecipeHandlerBase {
    private static final int[][] INPUTS = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}, {0, 3}, {1, 3}, {2, 3}};
    private static Class<? extends GuiContainer> guiClass;

    @Override
    public void prepare() {
        guiClass = Utils.getClass("buildcraft.silicon.gui.GuiAssemblyTable");
        API.setGuiOffset(guiClass, (int)5, (int)29);
    }

    public String getRecipeName() {
        return Utils.translate("tile.assemblyTableBlock.name", false);
    }

    @Override
    public String getRecipeID() {
        return "buildcraft.assemblyTable";
    }

    public String getGuiTexture() {
        return "buildcraft:textures/gui/assembly_table.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(89, 7, 6, 72);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiClass;
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)5, (int)5, (int)33, (int)166, (int)76);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(90, 7, 176, 17, 4, 71, 100, 3);
        GuiDraw.drawStringC((String)(((CachedAssemblyTableRecipe)((Object)this.arecipes.get((int)recipe))).energy + " RF"), (int)93, (int)84, (int)0x808080, (boolean)false);
    }

    @Override
    public void loadAllRecipes() {
        for (IFlexibleRecipe recipe : BuildcraftRecipeRegistry.assemblyTable.getRecipes()) {
            ItemStack output;
            if (!(recipe instanceof IFlexibleRecipeViewable) || (output = (ItemStack)((IFlexibleRecipeViewable)recipe).getOutput()).func_77973_b() instanceof IFacadeItem) continue;
            this.arecipes.add(new CachedAssemblyTableRecipe((IFlexibleRecipeViewable)recipe, true));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (IFlexibleRecipe recipe : BuildcraftRecipeRegistry.assemblyTable.getRecipes()) {
            if (!(recipe instanceof IFlexibleRecipeViewable)) continue;
            IFlexibleRecipeViewable recipeViewable = (IFlexibleRecipeViewable)recipe;
            ItemStack output = (ItemStack)recipeViewable.getOutput();
            if ((output.field_77990_d == null || !NEIServerUtils.areStacksSameType((ItemStack)output, (ItemStack)result)) && (output.field_77990_d != null || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)output, (ItemStack)result))) continue;
            this.arecipes.add(new CachedAssemblyTableRecipe((IFlexibleRecipeViewable)recipe, true));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (IFlexibleRecipe recipe : BuildcraftRecipeRegistry.assemblyTable.getRecipes()) {
            CachedAssemblyTableRecipe crecipe;
            if (!(recipe instanceof IFlexibleRecipeViewable) || !(crecipe = new CachedAssemblyTableRecipe((IFlexibleRecipeViewable)recipe)).contains(crecipe.inputs, ingredient)) continue;
            crecipe.generatePermutations();
            crecipe.setIngredientPermutation(crecipe.inputs, ingredient);
            this.arecipes.add(crecipe);
        }
    }

    public class CachedAssemblyTableRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedStack> inputs = new ArrayList<PositionedStack>();
        public PositionedStack output;
        public int energy;

        public CachedAssemblyTableRecipe(IFlexibleRecipeViewable recipe, boolean generatePermutations) {
            this.setIngredients((List)recipe.getInputs());
            this.output = new PositionedStack(recipe.getOutput(), 129, 8);
            this.energy = recipe.getEnergyCost();
            if (generatePermutations) {
                this.generatePermutations();
            }
        }

        public CachedAssemblyTableRecipe(IFlexibleRecipeViewable recipe) {
            this(recipe, false);
        }

        public void setIngredients(List<Object> inputs) {
            int i = 0;
            for (Object o : inputs) {
                if (i >= INPUTS.length) {
                    return;
                }
                this.inputs.add(new PositionedStack(o, 3 + INPUTS[i][0] * 18, 8 + INPUTS[i][1] * 18, false));
                ++i;
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(RecipeHandlerAssemblyTable.this.cycleticks / 20, this.inputs);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public void generatePermutations() {
            for (PositionedStack p : this.inputs) {
                p.generatePermutations();
            }
        }
    }
}

