/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import openmods.integration.IIntegrationModule;
import openperipheral.api.ApiAccess;
import openperipheral.api.IAdapterRegistry;
import openperipheral.api.IEntityMetaBuilder;
import openperipheral.api.IEntityMetaProvider;
import openperipheral.api.IItemStackMetaBuilder;
import openperipheral.api.IItemStackMetaProvider;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.integration.vanilla.AdapterBeacon;
import openperipheral.integration.vanilla.AdapterBrewingStand;
import openperipheral.integration.vanilla.AdapterComparator;
import openperipheral.integration.vanilla.AdapterDaylightSensor;
import openperipheral.integration.vanilla.AdapterFluidHandler;
import openperipheral.integration.vanilla.AdapterFluidTank;
import openperipheral.integration.vanilla.AdapterFurnace;
import openperipheral.integration.vanilla.AdapterInventory;
import openperipheral.integration.vanilla.AdapterMobSpawner;
import openperipheral.integration.vanilla.AdapterNoteBlock;
import openperipheral.integration.vanilla.AdapterRecordPlayer;
import openperipheral.integration.vanilla.AdapterSign;
import openperipheral.integration.vanilla.AdapterWorldInventory;
import openperipheral.integration.vanilla.EnchantedBookMetaProvider;
import openperipheral.integration.vanilla.EnchantmentMetaProvider;
import openperipheral.integration.vanilla.EntityBatMetaProvider;
import openperipheral.integration.vanilla.EntityCreeperMetaProvider;
import openperipheral.integration.vanilla.EntityHorseMetaProvider;
import openperipheral.integration.vanilla.EntityLivingMetaProvider;
import openperipheral.integration.vanilla.EntityPigMetaProvider;
import openperipheral.integration.vanilla.EntityPlayerMetaProvider;
import openperipheral.integration.vanilla.EntitySheepMetaProvider;
import openperipheral.integration.vanilla.EntityTameableMetaProvider;
import openperipheral.integration.vanilla.EntityVillagerMetaProvider;
import openperipheral.integration.vanilla.EntityWitchMetaProvider;
import openperipheral.integration.vanilla.EntityWolfMetaProvider;
import openperipheral.integration.vanilla.EntityZombieMetaProvider;
import openperipheral.integration.vanilla.FluidContainerMetaProvider;

public class ModuleVanilla
implements IIntegrationModule {
    public static String DUMMY_VANILLA_MODID = "vanilla";

    public String name() {
        return "Vanilla CC integration module";
    }

    public boolean canLoad() {
        return true;
    }

    public void load() {
        IAdapterRegistry adapterRegistry = (IAdapterRegistry)ApiAccess.getApi(IAdapterRegistry.class);
        adapterRegistry.register((IPeripheralAdapter)new AdapterInventory());
        adapterRegistry.register((IPeripheralAdapter)new AdapterWorldInventory());
        adapterRegistry.register((IPeripheralAdapter)new AdapterNoteBlock());
        adapterRegistry.register((IPeripheralAdapter)new AdapterComparator());
        adapterRegistry.register((IPeripheralAdapter)new AdapterBeacon());
        adapterRegistry.register((IPeripheralAdapter)new AdapterBrewingStand());
        adapterRegistry.register((IPeripheralAdapter)new AdapterFluidHandler());
        adapterRegistry.register((IPeripheralAdapter)new AdapterFluidTank());
        adapterRegistry.register((IPeripheralAdapter)new AdapterFurnace());
        adapterRegistry.register((IPeripheralAdapter)new AdapterMobSpawner());
        adapterRegistry.register((IPeripheralAdapter)new AdapterRecordPlayer());
        adapterRegistry.register((IPeripheralAdapter)new AdapterSign());
        adapterRegistry.register((IPeripheralAdapter)new AdapterDaylightSensor());
        IItemStackMetaBuilder itemMeta = (IItemStackMetaBuilder)ApiAccess.getApi(IItemStackMetaBuilder.class);
        itemMeta.register((IItemStackMetaProvider)new EnchantedBookMetaProvider());
        itemMeta.register((IItemStackMetaProvider)new EnchantmentMetaProvider());
        itemMeta.register((IItemStackMetaProvider)new FluidContainerMetaProvider());
        IEntityMetaBuilder entityMeta = (IEntityMetaBuilder)ApiAccess.getApi(IEntityMetaBuilder.class);
        entityMeta.register((IEntityMetaProvider)new EntityBatMetaProvider());
        entityMeta.register((IEntityMetaProvider)new EntityCreeperMetaProvider());
        entityMeta.register((IEntityMetaProvider)new EntityHorseMetaProvider());
        entityMeta.register((IEntityMetaProvider)new EntityLivingMetaProvider());
        entityMeta.register((IEntityMetaProvider)new EntityPigMetaProvider());
        entityMeta.register((IEntityMetaProvider)new EntityPlayerMetaProvider());
        entityMeta.register((IEntityMetaProvider)new EntitySheepMetaProvider());
        entityMeta.register((IEntityMetaProvider)new EntityTameableMetaProvider());
        entityMeta.register((IEntityMetaProvider)new EntityVillagerMetaProvider());
        entityMeta.register((IEntityMetaProvider)new EntityWitchMetaProvider());
        entityMeta.register((IEntityMetaProvider)new EntityWolfMetaProvider());
        entityMeta.register((IEntityMetaProvider)new EntityZombieMetaProvider());
    }

    public static Object listEnchantments(NBTTagList ench) {
        ArrayList response = Lists.newArrayList();
        for (int i = 0; i < ench.func_74745_c(); ++i) {
            NBTTagCompound enchTag = ench.func_150305_b(i);
            short id = enchTag.func_74765_d("id");
            short lvl = enchTag.func_74765_d("lvl");
            Enchantment enchantment = Enchantment.field_77331_b[id];
            if (enchantment == null) continue;
            HashMap entry = Maps.newHashMap();
            entry.put("name", enchantment.func_77320_a());
            entry.put("level", lvl);
            entry.put("fullName", enchantment.func_77316_c((int)lvl));
            response.add(entry);
        }
        return response;
    }
}

