/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.entity.EntityLiving;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import openperipheral.api.helpers.EntityMetaProviderSimple;

public class EntityLivingMetaProvider
extends EntityMetaProviderSimple<EntityLiving> {
    public String getKey() {
        return "living";
    }

    public Object getMeta(EntityLiving target, Vec3 relativePos) {
        HashMap map = Maps.newHashMap();
        HashMap armor = Maps.newHashMap();
        armor.put("boots", target.func_71124_b(1));
        armor.put("leggings", target.func_71124_b(2));
        armor.put("chestplate", target.func_71124_b(3));
        armor.put("helmet", target.func_71124_b(4));
        map.put("armor", armor);
        map.put("heldItem", target.func_71124_b(0));
        HashMap potionEffects = Maps.newHashMap();
        Collection effects = target.func_70651_bq();
        int count = 1;
        for (PotionEffect effect : effects) {
            potionEffects.put(count++, effect.func_76453_d());
        }
        map.put("potionEffects", potionEffects);
        map.put("health", Float.valueOf(target.func_110143_aJ()));
        map.put("maxHealth", Float.valueOf(target.func_110138_aP()));
        map.put("isAirborne", target.field_70160_al);
        map.put("isBurning", target.func_70027_ad());
        map.put("isAlive", target.func_70089_S());
        map.put("isInWater", target.func_70090_H());
        map.put("isOnLadder", target.func_70617_f_());
        map.put("isSleeping", target.func_70608_bn());
        map.put("isRiding", target.func_70115_ae());
        map.put("isSneaking", target.func_70093_af());
        map.put("isSprinting", target.func_70051_ag());
        map.put("isWet", target.func_70026_G());
        map.put("isChild", target.func_70631_g_());
        map.put("isDead", target.field_70128_L);
        map.put("yaw", Float.valueOf(target.field_70177_z));
        map.put("pitch", Float.valueOf(target.field_70125_A));
        map.put("yawHead", Float.valueOf(target.field_70759_as));
        Vec3 posVec = Vec3.func_72443_a((double)target.field_70165_t, (double)(target.field_70163_u + (double)1.62f), (double)target.field_70161_v);
        Vec3 lookVec = target.func_70676_i(1.0f);
        Vec3 targetVec = posVec.func_72441_c(lookVec.field_72450_a * 10.0, lookVec.field_72448_b * 10.0, lookVec.field_72449_c * 10.0);
        MovingObjectPosition mop = target.field_70170_p.func_72933_a(posVec, targetVec);
        if (mop != null) {
            HashMap hit = Maps.newHashMap();
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                hit.put("type", "block");
                HashMap lookingAt = Maps.newHashMap();
                if (relativePos != null) {
                    lookingAt.put("x", (double)mop.field_72311_b - relativePos.field_72450_a);
                    lookingAt.put("y", (double)mop.field_72312_c - relativePos.field_72448_b);
                    lookingAt.put("z", (double)mop.field_72309_d - relativePos.field_72449_c);
                } else {
                    lookingAt.put("x", mop.field_72311_b);
                    lookingAt.put("y", mop.field_72312_c);
                    lookingAt.put("z", mop.field_72309_d);
                }
                hit.put("position", lookingAt);
            } else if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                hit.put("type", "entity");
                hit.put("id", mop.field_72308_g.func_145782_y());
            }
            map.put("lookingAt", hit);
        }
        return map;
    }
}

