/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.base.Preconditions;
import net.minecraft.tileentity.TileEntitySign;
import openperipheral.api.Arg;
import openperipheral.api.Asynchronous;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaReturnType;
import org.apache.commons.lang3.StringUtils;

public class AdapterSign
implements IPeripheralAdapter {
    public Class<?> getTargetClass() {
        return TileEntitySign.class;
    }

    public String getSourceId() {
        return "vanilla_sign";
    }

    private static void checkRange(int value, int max) {
        Preconditions.checkArgument((value >= 0 && value < max ? 1 : 0) != 0, (String)"Value must be in range [1,%s]", (Object[])new Object[]{max});
    }

    @LuaCallable(description="Sets the text on the sign")
    public void setLine(TileEntitySign sign, @Arg(name="line", description="The line number to set the text on the sign") int line, @Arg(name="text", description="The text to display on the sign") String text) {
        AdapterSign.checkRange(--line, sign.field_145915_a.length);
        sign.field_145915_a[line] = text.length() < 15 ? text : text.substring(0, 15);
        sign.func_145831_w().func_147471_g(sign.field_145851_c, sign.field_145848_d, sign.field_145849_e);
    }

    @Asynchronous
    @LuaCallable(returnTypes={LuaReturnType.STRING}, description="Gets the text from the supplied line of the sign")
    public String getLine(TileEntitySign sign, @Arg(name="line", description="The line number to get from the sign") int line) {
        AdapterSign.checkRange(--line, sign.field_145915_a.length);
        return sign.field_145915_a[line];
    }

    @LuaCallable(description="Sets the text on the sign")
    public void setText(TileEntitySign sign, @Arg(name="text", description="The text to display on the sign") String text) {
        String[] lines = text.split("\n");
        int currLength = lines.length;
        int maxLength = sign.field_145915_a.length;
        AdapterSign.checkRange(currLength, maxLength);
        for (int i = 0; i < maxLength; ++i) {
            this.setLine(sign, i + 1, i < currLength ? lines[i] : "");
        }
    }

    @Asynchronous
    @LuaCallable(returnTypes={LuaReturnType.STRING}, description="Gets the text on the sign")
    public String getText(TileEntitySign sign) {
        return StringUtils.join((Object[])sign.field_145915_a, (char)'\n');
    }
}

