/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.cofh.tileentity;

import cofh.api.tileentity.IReconfigurableFacing;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaReturnType;
import openperipheral.integration.cofh.tileentity.SecurityUtils;

public class AdapterReconfigurableFacing
implements IPeripheralAdapter {
    public Class<?> getTargetClass() {
        return IReconfigurableFacing.class;
    }

    public String getSourceId() {
        return "cofh_facing";
    }

    @LuaCallable(returnTypes={LuaReturnType.NUMBER}, description="Returns the current facing of the block")
    public int getFacing(IReconfigurableFacing target) {
        return target.getFacing();
    }

    @LuaCallable(returnTypes={LuaReturnType.BOOLEAN}, description="Returns whether or not the block's face can be aligned with the Y Axis.")
    public boolean allowYAxisFacing(IReconfigurableFacing target) {
        return target.allowYAxisFacing();
    }

    @LuaCallable(returnTypes={LuaReturnType.BOOLEAN}, description="Attempt to rotate the block. Arbitrary based on implementation. Returns true if rotation was successful")
    public boolean rotateBlock(IReconfigurableFacing target) {
        SecurityUtils.checkAccess(target);
        return target.rotateBlock();
    }

    @LuaCallable(returnTypes={LuaReturnType.BOOLEAN}, description="Set the facing of the block. Returns true if rotation was successful")
    public boolean setFacing(IReconfigurableFacing target, @Arg(name="side") int side) {
        SecurityUtils.checkAccess(target);
        return target.setFacing(side);
    }
}

