/*
 * Decompiled with CFR 0.152.
 */
package opisapache.math3.optim.nonlinear.vector;

import opisapache.math3.analysis.MultivariateMatrixFunction;
import opisapache.math3.exception.DimensionMismatchException;
import opisapache.math3.exception.TooManyEvaluationsException;
import opisapache.math3.optim.ConvergenceChecker;
import opisapache.math3.optim.OptimizationData;
import opisapache.math3.optim.PointVectorValuePair;
import opisapache.math3.optim.nonlinear.vector.ModelFunctionJacobian;
import opisapache.math3.optim.nonlinear.vector.MultivariateVectorOptimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JacobianMultivariateVectorOptimizer
extends MultivariateVectorOptimizer {
    private MultivariateMatrixFunction jacobian;

    protected JacobianMultivariateVectorOptimizer(ConvergenceChecker<PointVectorValuePair> checker) {
        super(checker);
    }

    protected double[][] computeJacobian(double[] params) {
        return this.jacobian.value(params);
    }

    @Override
    public PointVectorValuePair optimize(OptimizationData ... optData) throws TooManyEvaluationsException, DimensionMismatchException {
        return super.optimize(optData);
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optData) {
        super.parseOptimizationData(optData);
        for (OptimizationData data : optData) {
            if (!(data instanceof ModelFunctionJacobian)) continue;
            this.jacobian = ((ModelFunctionJacobian)data).getModelFunctionJacobian();
            break;
        }
    }
}

