/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.swing.panels.tracking;

import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import mcp.mobius.opis.api.ITabPanel;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.newtypes.DataBlockTileEntityPerClass;
import mcp.mobius.opis.helpers.ModIdentification;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.AccessLevel;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.swing.SelectedTab;
import mcp.mobius.opis.swing.actions.ActionAmountTileEnts;
import mcp.mobius.opis.swing.widgets.JButtonAccess;
import mcp.mobius.opis.swing.widgets.JPanelMsgHandler;
import mcp.mobius.opis.swing.widgets.JTableStats;
import net.miginfocom.swing.MigLayout;

public class PanelAmountTileEnts
extends JPanelMsgHandler
implements ITabPanel {
    private JButtonAccess btnRefresh;

    public PanelAmountTileEnts() {
        this.setLayout(new MigLayout("", "[][][grow][]", "[][grow][]"));
        this.btnRefresh = new JButtonAccess("Refresh", AccessLevel.NONE);
        this.add((Component)this.btnRefresh, "cell 3 0");
        this.btnRefresh.addActionListener(new ActionAmountTileEnts());
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "cell 0 1 4 1,grow");
        this.table = new JTableStats(new String[]{"Name", "Mod", "Amount"}, new Class[]{String.class, String.class, Integer.class}, new int[]{2, 0, 0});
        scrollPane.setViewportView(this.table);
    }

    public JButton getBtnRefresh() {
        return this.btnRefresh;
    }

    @Override
    public boolean handleMessage(Message msg, PacketBase rawdata) {
        switch (msg) {
            case LIST_AMOUNT_TILEENTS: {
                this.cacheData(msg, rawdata);
                this.getTable().setTableData(rawdata.array);
                DefaultTableModel model = this.table.getModel();
                int row = this.getTable().clearTable(DataBlockTileEntityPerClass.class);
                HashMap<String, DataBlockTileEntityPerClass> cumData = new HashMap<String, DataBlockTileEntityPerClass>();
                for (ISerializable o : rawdata.array) {
                    DataBlockTileEntityPerClass data = (DataBlockTileEntityPerClass)o;
                    String name = ModIdentification.getStackName(data.id, data.meta);
                    if (!cumData.containsKey(name)) {
                        cumData.put(name, new DataBlockTileEntityPerClass(data.id, data.meta));
                    }
                    ((DataBlockTileEntityPerClass)cumData.get(name)).add(data.amount, data.update.timing);
                }
                Iterator<ISerializable> i$ = cumData.keySet().iterator();
                while (i$.hasNext()) {
                    String s;
                    String name = s = (String)((Object)i$.next());
                    String modID = ModIdentification.getModStackName(((DataBlockTileEntityPerClass)cumData.get((Object)s)).id, ((DataBlockTileEntityPerClass)cumData.get((Object)s)).meta);
                    model.addRow(new Object[]{name, modID, ((DataBlockTileEntityPerClass)cumData.get((Object)s)).amount});
                }
                this.getTable().dataUpdated(row);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public SelectedTab getSelectedTab() {
        return SelectedTab.AMOUNTTES;
    }

    @Override
    public boolean refreshOnString() {
        return true;
    }
}

