/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.swing.panels.timingserver;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import mcp.mobius.opis.api.ITabPanel;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.basetypes.CoordinatesBlock;
import mcp.mobius.opis.data.holders.newtypes.DataBlockTileEntity;
import mcp.mobius.opis.data.holders.newtypes.DataTiming;
import mcp.mobius.opis.helpers.ModIdentification;
import mcp.mobius.opis.modOpis;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.AccessLevel;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.swing.SelectedTab;
import mcp.mobius.opis.swing.actions.ActionRunOpis;
import mcp.mobius.opis.swing.actions.ActionTimingTileEnts;
import mcp.mobius.opis.swing.widgets.JButtonAccess;
import mcp.mobius.opis.swing.widgets.JPanelMsgHandler;
import mcp.mobius.opis.swing.widgets.JTableStats;
import net.miginfocom.swing.MigLayout;

public class PanelTimingTileEnts
extends JPanelMsgHandler
implements ITabPanel {
    private JButtonAccess btnCenter;
    private JButtonAccess btnTeleport;
    private JButtonAccess btnReset;
    private JButtonAccess btnRun;
    private JLabel lblSummary;

    public PanelTimingTileEnts() {
        this.setLayout(new MigLayout("", "[][][][grow][]", "[][grow][]"));
        this.btnCenter = new JButtonAccess("Center Map", AccessLevel.NONE);
        this.add((Component)this.btnCenter, "cell 0 0");
        this.btnCenter.addActionListener(new ActionTimingTileEnts());
        this.btnTeleport = new JButtonAccess("Teleport", AccessLevel.PRIVILEGED);
        this.add((Component)this.btnTeleport, "cell 1 0");
        this.btnTeleport.addActionListener(new ActionTimingTileEnts());
        this.btnReset = new JButtonAccess("Reset Highlight", AccessLevel.PRIVILEGED);
        this.btnReset.setEnabled(false);
        this.add((Component)this.btnReset, "cell 2 0");
        this.btnReset.addActionListener(new ActionTimingTileEnts());
        this.btnRun = new JButtonAccess("Run Opis", AccessLevel.PRIVILEGED);
        this.add((Component)this.btnRun, "cell 4 0");
        this.btnRun.addActionListener(new ActionRunOpis());
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "cell 0 1 5 1,grow");
        this.table = new JTableStats(new String[]{"Type", "Mod", "Dim", "Pos", "Update Time"}, new Class[]{String.class, String.class, Integer.class, Object.class, DataTiming.class});
        scrollPane.setViewportView(this.table);
        this.lblSummary = new JLabel("New label");
        this.add((Component)this.lblSummary, "cell 0 2 5 1,alignx center");
    }

    public JButton getBtnCenter() {
        return this.btnCenter;
    }

    public JButton getBtnTeleport() {
        return this.btnTeleport;
    }

    public JButton getBtnReset() {
        return this.btnReset;
    }

    public JButton getBtnRun() {
        return this.btnRun;
    }

    public JLabel getLblSummary() {
        return this.lblSummary;
    }

    @Override
    public boolean handleMessage(Message msg, PacketBase rawdata) {
        switch (msg) {
            case LIST_TIMING_TILEENTS: {
                this.cacheData(msg, rawdata);
                this.getTable().setTableData(rawdata.array);
                DefaultTableModel model = this.table.getModel();
                int row = this.getTable().clearTable(DataBlockTileEntity.class);
                for (ISerializable o : rawdata.array) {
                    DataBlockTileEntity data = (DataBlockTileEntity)o;
                    String name = ModIdentification.getStackName(data.id, data.meta);
                    String modID = ModIdentification.getModStackName(data.id, data.meta);
                    model.addRow(new Object[]{name, modID, data.pos.dim, String.format("[ %4d %4d %4d ]", data.pos.x, data.pos.y, data.pos.z), data.update});
                }
                this.getTable().dataUpdated(row);
                break;
            }
            case VALUE_TIMING_TILEENTS: {
                this.getLblSummary().setText(String.format("Total update time : %s", ((DataTiming)rawdata.value).toString()));
                break;
            }
            case STATUS_START: {
                this.getBtnRun().setText("Running...");
                break;
            }
            case STATUS_STOP: {
                this.getBtnRun().setText("Run Opis");
                break;
            }
            case STATUS_RUNNING: {
                this.getBtnRun().setText("Running...");
                break;
            }
            case CLIENT_HIGHLIGHT_BLOCK: {
                modOpis.selectedBlock = (CoordinatesBlock)rawdata.value;
                this.getBtnReset().setEnabled(true);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public SelectedTab getSelectedTab() {
        return SelectedTab.TIMINGTILEENTS;
    }

    @Override
    public boolean refreshOnString() {
        return true;
    }
}

