/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import mcp.mobius.mobiuscore.profiler.ProfilerSection;
import mcp.mobius.opis.data.holders.basetypes.SerialInt;
import mcp.mobius.opis.data.holders.basetypes.SerialLong;
import mcp.mobius.opis.data.holders.newtypes.DataDimension;
import mcp.mobius.opis.data.holders.newtypes.DataPacket;
import mcp.mobius.opis.data.holders.newtypes.DataPacket250;
import mcp.mobius.opis.data.holders.newtypes.DataThread;
import mcp.mobius.opis.data.holders.newtypes.DataTiming;
import mcp.mobius.opis.data.holders.stats.StatsChunk;
import mcp.mobius.opis.data.managers.ChunkManager;
import mcp.mobius.opis.data.managers.EntityManager;
import mcp.mobius.opis.data.managers.StringCache;
import mcp.mobius.opis.data.managers.TileEntityManager;
import mcp.mobius.opis.data.profilers.ProfilerPacket;
import mcp.mobius.opis.data.profilers.ProfilerTick;
import mcp.mobius.opis.events.EventTimer;
import mcp.mobius.opis.events.PlayerTracker;
import mcp.mobius.opis.gui.overlay.OverlayStatus;
import mcp.mobius.opis.modOpis;
import mcp.mobius.opis.network.PacketManager;
import mcp.mobius.opis.network.enums.AccessLevel;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.network.packets.server.NetDataCommand;
import mcp.mobius.opis.network.packets.server.NetDataList;
import mcp.mobius.opis.network.packets.server.NetDataValue;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.DimensionManager;

public enum OpisServerTickHandler {
    INSTANCE;

    public long profilerUpdateTickCounter = 0L;
    public int profilerRunningTicks;
    public EventTimer timer500 = new EventTimer(500L);
    public EventTimer timer1000 = new EventTimer(1000L);
    public EventTimer timer2000 = new EventTimer(2000L);
    public EventTimer timer5000 = new EventTimer(5000L);
    public EventTimer timer10000 = new EventTimer(10000L);
    public HashMap<EntityPlayerMP, AccessLevel> cachedAccess = new HashMap();

    @SubscribeEvent
    public void tickEnd(TickEvent.ServerTickEvent event) {
        StringCache.INSTANCE.syncNewCache();
        if (this.timer1000.isDone()) {
            PacketManager.sendPacketToAllSwing(new NetDataValue(Message.VALUE_AMOUNT_UPLOAD, new SerialLong(((ProfilerPacket)ProfilerSection.PACKET_OUTBOUND.getProfiler()).dataAmount)));
            PacketManager.sendPacketToAllSwing(new NetDataValue(Message.VALUE_AMOUNT_DOWNLOAD, new SerialLong(((ProfilerPacket)ProfilerSection.PACKET_INBOUND.getProfiler()).dataAmount)));
            PacketManager.sendPacketToAllSwing(new NetDataValue(Message.VALUE_CHUNK_FORCED, new SerialInt(ChunkManager.INSTANCE.getForcedChunkAmount())));
            PacketManager.sendPacketToAllSwing(new NetDataValue(Message.VALUE_CHUNK_LOADED, new SerialInt(ChunkManager.INSTANCE.getLoadedChunkAmount())));
            PacketManager.sendPacketToAllSwing(new NetDataValue(Message.VALUE_TIMING_TICK, new DataTiming(((ProfilerTick)ProfilerSection.TICK.getProfiler()).data.getGeometricMean())));
            PacketManager.sendPacketToAllSwing(new NetDataValue(Message.VALUE_AMOUNT_TILEENTS, new SerialInt(TileEntityManager.INSTANCE.getAmountTileEntities())));
            PacketManager.sendPacketToAllSwing(new NetDataValue(Message.VALUE_AMOUNT_ENTITIES, new SerialInt(EntityManager.INSTANCE.getAmountEntities())));
            for (EntityPlayerMP player : PlayerTracker.INSTANCE.playersSwing) {
                if (this.cachedAccess.containsKey(player) && this.cachedAccess.get(player) == PlayerTracker.INSTANCE.getPlayerAccessLevel(player)) continue;
                PacketManager.validateAndSend(new NetDataValue(Message.STATUS_ACCESS_LEVEL, new SerialInt(PlayerTracker.INSTANCE.getPlayerAccessLevel(player).ordinal())), player);
                this.cachedAccess.put(player, PlayerTracker.INSTANCE.getPlayerAccessLevel(player));
            }
            ArrayList<DataThread> threads = new ArrayList<DataThread>();
            for (Thread t : Thread.getAllStackTraces().keySet()) {
                threads.add(new DataThread().fill(t));
            }
            PacketManager.sendPacketToAllSwing(new NetDataList(Message.LIST_THREADS, threads));
            ArrayList<DataDimension> dimData = new ArrayList<DataDimension>();
            Integer[] arr$ = DimensionManager.getIDs();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int dim = arr$[i$];
                dimData.add(new DataDimension().fill(dim));
            }
            PacketManager.sendPacketToAllSwing(new NetDataList(Message.LIST_DIMENSION_DATA, dimData));
            if (modOpis.profilerRun) {
                PacketManager.sendPacketToAllSwing(new NetDataValue(Message.STATUS_RUNNING, new SerialInt(modOpis.profilerMaxTicks)));
                PacketManager.sendPacketToAllSwing(new NetDataValue(Message.STATUS_RUN_UPDATE, new SerialInt(this.profilerRunningTicks)));
            }
            ((ProfilerPacket)ProfilerSection.PACKET_INBOUND.getProfiler()).dataAmount = 0L;
            ((ProfilerPacket)ProfilerSection.PACKET_OUTBOUND.getProfiler()).dataAmount = 0L;
        }
        if (this.timer2000.isDone()) {
            PacketManager.sendPacketToAllSwing(new NetDataList(Message.LIST_PLAYERS, EntityManager.INSTANCE.getAllPlayers()));
        }
        if (this.timer5000.isDone()) {
            this.updatePlayers();
            PacketManager.sendPacketToAllSwing(new NetDataList(Message.LIST_PACKETS_OUTBOUND, new ArrayList<DataPacket>(((ProfilerPacket)ProfilerSection.PACKET_OUTBOUND.getProfiler()).data.values())));
            PacketManager.sendPacketToAllSwing(new NetDataList(Message.LIST_PACKETS_INBOUND, new ArrayList<DataPacket>(((ProfilerPacket)ProfilerSection.PACKET_INBOUND.getProfiler()).data.values())));
            PacketManager.sendPacketToAllSwing(new NetDataList(Message.LIST_PACKETS_OUTBOUND_250, new ArrayList<DataPacket250>(((ProfilerPacket)ProfilerSection.PACKET_OUTBOUND.getProfiler()).data250.values())));
            PacketManager.sendPacketToAllSwing(new NetDataList(Message.LIST_PACKETS_INBOUND_250, new ArrayList<DataPacket250>(((ProfilerPacket)ProfilerSection.PACKET_INBOUND.getProfiler()).data250.values())));
            ((ProfilerPacket)ProfilerSection.PACKET_OUTBOUND.getProfiler()).startInterval();
            ((ProfilerPacket)ProfilerSection.PACKET_INBOUND.getProfiler()).startInterval();
        }
        ++this.profilerUpdateTickCounter;
        if (this.profilerRunningTicks < modOpis.profilerMaxTicks && modOpis.profilerRun) {
            ++this.profilerRunningTicks;
        } else if (this.profilerRunningTicks >= modOpis.profilerMaxTicks && modOpis.profilerRun) {
            this.profilerRunningTicks = 0;
            modOpis.profilerRun = false;
            ProfilerSection.desactivateAll((Side)Side.SERVER);
            PacketManager.sendPacketToAllSwing(new NetDataValue(Message.STATUS_STOP, new SerialInt(modOpis.profilerMaxTicks)));
            for (EntityPlayerMP player : PlayerTracker.INSTANCE.playersSwing) {
                PacketManager.sendFullUpdate(player);
            }
        }
    }

    private void updatePlayers() {
        for (EntityPlayerMP player : PlayerTracker.INSTANCE.playerOverlayStatus.keySet()) {
            if (PlayerTracker.INSTANCE.playerOverlayStatus.get(player) == OverlayStatus.CHUNKSTATUS) {
                PacketManager.validateAndSend(new NetDataCommand(Message.LIST_CHUNK_LOADED_CLEAR), player);
                PacketManager.splitAndSend(Message.LIST_CHUNK_LOADED, ChunkManager.INSTANCE.getLoadedChunks(PlayerTracker.INSTANCE.playerDimension.get(player)), player);
            }
            if (PlayerTracker.INSTANCE.playerOverlayStatus.get(player) != OverlayStatus.MEANTIME) continue;
            ArrayList<StatsChunk> timingChunks = ChunkManager.INSTANCE.getTopChunks(100);
            PacketManager.validateAndSend(new NetDataList(Message.LIST_TIMING_CHUNK, timingChunks), player);
        }
    }
}

