/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.data.profilers;

import com.google.common.collect.HashBasedTable;
import cpw.mods.fml.common.ModContainer;
import mcp.mobius.opis.data.profilers.Clock;
import mcp.mobius.opis.data.profilers.ProfilerAbstract;
import opisapache.math3.stat.descriptive.DescriptiveStatistics;

public class ProfilerEvent
extends ProfilerAbstract {
    private Clock.IClock clock = Clock.getNewClock();
    public HashBasedTable<Class, String, DescriptiveStatistics> data = HashBasedTable.create();
    public HashBasedTable<Class, String, String> dataMod = HashBasedTable.create();
    public HashBasedTable<Class, String, DescriptiveStatistics> dataTick = HashBasedTable.create();
    public HashBasedTable<Class, String, String> dataModTick = HashBasedTable.create();

    @Override
    public void reset() {
        this.data.clear();
    }

    @Override
    public void start() {
        this.clock.start();
    }

    @Override
    public void stop(Object event, Object pkg, Object handler, Object mod) {
        this.clock.stop();
        String eventName = event.getClass().getSimpleName();
        if (eventName.contains("TickEvent")) {
            try {
                String name = (String)pkg + "|" + handler.getClass().getSimpleName();
                ((DescriptiveStatistics)this.dataTick.get(event.getClass(), (Object)name)).addValue(this.clock.getDelta());
            }
            catch (Exception e) {
                String name = (String)pkg + "|" + handler.getClass().getSimpleName();
                this.dataTick.put(event.getClass(), (Object)name, (Object)new DescriptiveStatistics(250));
                this.dataModTick.put(event.getClass(), (Object)name, (Object)((ModContainer)mod).getName());
                ((DescriptiveStatistics)this.dataTick.get(event.getClass(), (Object)name)).addValue(this.clock.getDelta());
            }
        } else {
            try {
                String name = (String)pkg + "|" + handler.getClass().getSimpleName();
                ((DescriptiveStatistics)this.data.get(event.getClass(), (Object)name)).addValue(this.clock.getDelta());
            }
            catch (Exception e) {
                String name = (String)pkg + "|" + handler.getClass().getSimpleName();
                this.data.put(event.getClass(), (Object)name, (Object)new DescriptiveStatistics(250));
                this.dataMod.put(event.getClass(), (Object)name, (Object)((ModContainer)mod).getName());
                ((DescriptiveStatistics)this.data.get(event.getClass(), (Object)name)).addValue(this.clock.getDelta());
            }
        }
    }
}

