/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.data.managers;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import mcp.mobius.opis.api.IMessageHandler;
import mcp.mobius.opis.api.TabPanelRegistrar;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.newtypes.DataStringUpdate;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.PacketManager;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.network.packets.server.NetDataList;
import mcp.mobius.opis.network.packets.server.NetDataValue;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public enum StringCache implements IMessageHandler
{
    INSTANCE;

    private int currentIndex = -1;
    private BiMap<Integer, String> cache = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
    private ConcurrentLinkedQueue<DataStringUpdate> fullsync = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<DataStringUpdate> unsynced = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int index) {
        BiMap<Integer, String> biMap = this.cache;
        synchronized (biMap) {
            String retVal = (String)this.cache.get((Object)index);
            if (retVal == null) {
                return "<ERROR>";
            }
            return retVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndex(String str) {
        BiMap<Integer, String> biMap = this.cache;
        synchronized (biMap) {
            if (this.cache.inverse().containsKey((Object)str)) {
                return (Integer)this.cache.inverse().get((Object)str);
            }
            ++this.currentIndex;
            this.cache.put((Object)this.currentIndex, (Object)str);
            DataStringUpdate upd = new DataStringUpdate(str, this.currentIndex);
            this.fullsync.add(upd);
            this.unsynced.add(upd);
            return this.currentIndex;
        }
    }

    public void syncCache(EntityPlayerMP player) {
        ArrayList<DataStringUpdate> toSendCopy = new ArrayList<DataStringUpdate>(this.fullsync);
        for (int i = 0; i < toSendCopy.size(); i += 50) {
            PacketManager.sendToPlayer(new NetDataList(Message.STATUS_STRINGUPD_FULL, toSendCopy.subList(i, Math.min(i + 50, toSendCopy.size()))), (EntityPlayer)player);
        }
    }

    public void syncNewCache() {
        while (!this.unsynced.isEmpty()) {
            PacketManager.sendToAll(new NetDataValue(Message.STATUS_STRINGUPD, this.unsynced.poll()));
        }
    }

    @Override
    public boolean handleMessage(Message msg, PacketBase rawdata) {
        switch (msg) {
            case STATUS_STRINGUPD: {
                DataStringUpdate data = (DataStringUpdate)rawdata.value;
                try {
                    this.cache.put((Object)data.index, (Object)data.str);
                }
                catch (IllegalArgumentException e) {
                    this.cache.remove((Object)data.index);
                    this.cache.inverse().remove((Object)data.str);
                    this.cache.put((Object)data.index, (Object)data.str);
                }
                TabPanelRegistrar.INSTANCE.refreshAll();
                break;
            }
            case STATUS_STRINGUPD_FULL: {
                for (ISerializable idata : rawdata.array) {
                    DataStringUpdate data = (DataStringUpdate)idata;
                    try {
                        this.cache.put((Object)data.index, (Object)data.str);
                    }
                    catch (IllegalArgumentException e) {
                        this.cache.remove((Object)data.index);
                        this.cache.inverse().remove((Object)data.str);
                        this.cache.put((Object)data.index, (Object)data.str);
                    }
                }
                TabPanelRegistrar.INSTANCE.refreshAll();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

