/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.moofluids.common.entity;

import com.robrit.moofluids.common.entity.EntityTypeData;
import com.robrit.moofluids.common.util.EntityHelper;
import com.robrit.moofluids.common.util.damage.AttackDamageSource;
import com.robrit.moofluids.common.util.damage.BurnDamageSource;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class EntityFluidCow
extends EntityCow
implements IEntityAdditionalSpawnData {
    private static final int DATA_WATCHER_ID_CURRENT_USE_COOLDOWN = 23;
    public static final String NBT_TAG_FLUID_NAME = "FluidName";
    public static final String NBT_TAG_CURRENT_USE_COOLDOWN = "CurrentUseCooldown";
    private int currentUseCooldown;
    private Fluid entityFluid;
    private EntityTypeData entityTypeData;

    public EntityFluidCow(World world) {
        super(world);
        this.setEntityTypeData(EntityHelper.getEntityData(this.getEntityFluid().getName()));
        this.setCurrentUseCooldown(this.entityTypeData.getMaxUseCooldown());
        if (this.entityTypeData.canCauseFireDamage()) {
            this.field_70178_ae = true;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.currentUseCooldown > 0) {
            this.setCurrentUseCooldown(this.currentUseCooldown - 1);
        }
    }

    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (!this.func_70631_g_()) {
            ItemStack currentItemStack = entityPlayer.field_71071_by.func_70448_g();
            if (this.getCurrentUseCooldown() == 0) {
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    this.setCurrentUseCooldown(this.entityTypeData.getMaxUseCooldown());
                }
                if (this.attemptToGetFluidFromCow(currentItemStack, entityPlayer)) {
                    return true;
                }
                if (this.attemptToHealCowWithFluidContainer(currentItemStack, entityPlayer)) {
                    return true;
                }
                if (this.attemptToBreedCow(currentItemStack, entityPlayer)) {
                    return true;
                }
            }
        }
        return false;
    }

    public void func_82167_n(Entity entity) {
        if (this.entityTypeData.canDamageEntities() && !(entity instanceof EntityFluidCow)) {
            this.applyDamagesToEntity(entity);
        }
    }

    public void func_70100_b_(EntityPlayer entityPlayer) {
        if (this.entityTypeData.canDamagePlayers()) {
            this.applyDamagesToEntity((Entity)entityPlayer);
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damageAmount) {
        EntityPlayer entityPlayer;
        if (damageSource.func_76346_g() instanceof EntityPlayer && (entityPlayer = (EntityPlayer)damageSource.func_76346_g()).func_71045_bC() == null) {
            this.applyDamagesToEntity((Entity)entityPlayer);
        }
        return super.func_70097_a(damageSource, damageAmount);
    }

    public boolean func_70877_b(ItemStack currentItemStack) {
        return currentItemStack != null && currentItemStack.func_77973_b() == this.entityTypeData.getBreedingItem().func_77973_b();
    }

    public boolean func_70878_b(EntityAnimal entityAnimal) {
        if (entityAnimal != this && this.func_70880_s() && entityAnimal.func_70880_s() && entityAnimal instanceof EntityFluidCow) {
            Fluid mateEntityFluid = ((EntityFluidCow)entityAnimal).getEntityFluid();
            if (this.getEntityFluid().getName().equals(mateEntityFluid.getName())) {
                return true;
            }
        }
        return false;
    }

    public EntityFluidCow createChild(EntityAgeable entityAgeable) {
        EntityFluidCow childEntity = new EntityFluidCow(this.field_70170_p);
        childEntity.setEntityFluid(this.entityFluid);
        return childEntity;
    }

    private void applyDamagesToEntity(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            if (this.entityTypeData.canCauseFireDamage()) {
                int ticksOfDamage = 8;
                if (entity instanceof EntityPlayer) {
                    EntityPlayer entityPlayer = (EntityPlayer)entity;
                    int armorInventoryLength = entityPlayer.field_71071_by.field_70460_b.length;
                    for (int currentArmorSlot = 0; currentArmorSlot < armorInventoryLength; ++currentArmorSlot) {
                        if (entityPlayer.field_71071_by.func_70440_f(currentArmorSlot) == null) continue;
                        ticksOfDamage = (byte)(ticksOfDamage - 2);
                    }
                }
                entity.func_70097_a((DamageSource)new BurnDamageSource("burn", (Entity)this), (float)this.entityTypeData.getFireDamageAmount());
                entity.func_70015_d(ticksOfDamage);
            }
            if (this.entityTypeData.canCauseNormalDamage()) {
                entity.func_70097_a((DamageSource)new AttackDamageSource("whacked", (Entity)this), (float)this.entityTypeData.getNormalDamageAmount());
            }
        }
    }

    private boolean attemptToGetFluidFromCow(ItemStack currentItemStack, EntityPlayer entityPlayer) {
        boolean canGetFluid = false;
        if (currentItemStack != null && FluidContainerRegistry.isEmptyContainer((ItemStack)currentItemStack) && this.entityFluid != null && FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(this.entityFluid, 1000), (ItemStack)currentItemStack) != null) {
            ItemStack filledItemStack = FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(this.entityFluid, 1000), (ItemStack)currentItemStack);
            if (currentItemStack.field_77994_a-- == 1) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, filledItemStack.func_77946_l());
            } else if (!entityPlayer.field_71071_by.func_70441_a(filledItemStack.func_77946_l())) {
                entityPlayer.func_71019_a(filledItemStack.func_77946_l(), false);
            }
            canGetFluid = true;
        }
        return canGetFluid;
    }

    private boolean attemptToHealCowWithFluidContainer(ItemStack currentItemStack, EntityPlayer entityPlayer) {
        boolean cowHealed = false;
        if (currentItemStack != null && FluidContainerRegistry.isFilledContainer((ItemStack)currentItemStack) && this.entityFluid != null) {
            for (FluidContainerRegistry.FluidContainerData containerData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (!containerData.fluid.getFluid().getName().equalsIgnoreCase(this.entityFluid.getName()) || !containerData.filledContainer.func_77969_a(currentItemStack)) continue;
                ItemStack emptyItemStack = containerData.emptyContainer;
                if (currentItemStack.field_77994_a-- == 1) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, emptyItemStack.func_77946_l());
                } else if (!entityPlayer.field_71071_by.func_70441_a(emptyItemStack.func_77946_l())) {
                    entityPlayer.func_71019_a(emptyItemStack.func_77946_l(), false);
                }
                this.func_70691_i(4.0f);
                cowHealed = true;
            }
        }
        return cowHealed;
    }

    private boolean attemptToBreedCow(ItemStack currentItemStack, EntityPlayer entityPlayer) {
        if (currentItemStack != null && this.func_70877_b(currentItemStack) && this.func_70874_b() == 0) {
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                --currentItemStack.field_77994_a;
                if (currentItemStack.field_77994_a <= 0) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, (ItemStack)null);
                }
            }
            this.func_146082_f(entityPlayer);
            return true;
        }
        return false;
    }

    public Fluid getEntityFluid() {
        return this.entityFluid;
    }

    public void setEntityFluid(Fluid entityFluid) {
        this.entityFluid = entityFluid;
    }

    public int getCurrentUseCooldown() {
        return this.currentUseCooldown;
    }

    public void setCurrentUseCooldown(int currentUseCooldown) {
        this.field_70180_af.func_75692_b(23, (Object)currentUseCooldown);
        this.currentUseCooldown = currentUseCooldown;
    }

    public EntityTypeData getEntityTypeData() {
        return this.entityTypeData;
    }

    public void setEntityTypeData(EntityTypeData entityTypeData) {
        this.entityTypeData = entityTypeData;
    }

    @SideOnly(value=Side.CLIENT)
    public int getOverlay() {
        return this.entityTypeData.getOverlay();
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74778_a(NBT_TAG_FLUID_NAME, this.getEntityFluid().getName());
        nbtTagCompound.func_74768_a(NBT_TAG_CURRENT_USE_COOLDOWN, this.getCurrentUseCooldown());
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setEntityFluid(EntityHelper.getContainableFluid(nbtTagCompound.func_74779_i(NBT_TAG_FLUID_NAME)));
        this.setCurrentUseCooldown(nbtTagCompound.func_74762_e(NBT_TAG_CURRENT_USE_COOLDOWN));
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.entityFluid.getName());
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)this.currentUseCooldown, (int)4);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.setEntityFluid(EntityHelper.getContainableFluid(ByteBufUtils.readUTF8String((ByteBuf)additionalData)));
        this.setCurrentUseCooldown(ByteBufUtils.readVarInt((ByteBuf)additionalData, (int)4));
        this.entityTypeData = EntityHelper.getEntityData(this.getEntityFluid().getName());
    }
}

