/*
 * Decompiled with CFR 0.152.
 */
package infiniteinvo.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import infiniteinvo.achievements.InvoAchievements;
import infiniteinvo.core.II_Settings;
import infiniteinvo.core.InfiniteInvo;
import infiniteinvo.handlers.EventHandler;
import infiniteinvo.inventory.SlotLockable;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Level;

public class InvoPacket
implements IMessage {
    NBTTagCompound tags = new NBTTagCompound();

    public InvoPacket() {
    }

    public InvoPacket(NBTTagCompound tags) {
        this.tags = tags;
    }

    public void fromBytes(ByteBuf buf) {
        this.tags = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tags);
    }

    public static class HandleClient
    implements IMessageHandler<InvoPacket, IMessage> {
        public IMessage onMessage(InvoPacket message, MessageContext ctx) {
            if (message.tags.func_74764_b("ID") && message.tags.func_74762_e("ID") == 0) {
                EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                player.getEntityData().func_74768_a("INFINITE_INVO_UNLOCKED", message.tags.func_74762_e("Unlocked"));
                if (message.tags.func_74764_b("Settings")) {
                    InfiniteInvo.logger.log(Level.INFO, "Loading serverside settings...");
                    II_Settings.LoadFromTags(message.tags.func_74775_l("Settings"));
                }
            }
            return null;
        }
    }

    public static class HandleServer
    implements IMessageHandler<InvoPacket, IMessage> {
        public IMessage onMessage(InvoPacket message, MessageContext ctx) {
            if (message.tags.func_74764_b("ID")) {
                if (message.tags.func_74762_e("ID") == 0) {
                    WorldServer world = MinecraftServer.func_71276_C().func_71218_a(message.tags.func_74762_e("World"));
                    EntityPlayer player = world.func_72924_a(message.tags.func_74779_i("Player"));
                    if (player.field_71068_ca >= II_Settings.unlockCost + player.getEntityData().func_74762_e("INFINITE_INVO_UNLOCKED") * II_Settings.unlockIncrease) {
                        int unlocked = player.getEntityData().func_74762_e("INFINITE_INVO_UNLOCKED") + 1;
                        player.getEntityData().func_74768_a("INFINITE_INVO_UNLOCKED", unlocked);
                        player.func_82242_a(-(II_Settings.unlockCost + player.getEntityData().func_74762_e("INFINITE_INVO_UNLOCKED") * II_Settings.unlockIncrease));
                        EventHandler.unlockCache.put(player.func_70005_c_(), unlocked);
                        if (unlocked > 0 || !II_Settings.xpUnlock) {
                            player.func_71064_a((StatBase)InvoAchievements.unlockFirst, 1);
                        }
                        if (unlocked + II_Settings.unlockedSlots == II_Settings.invoSize || !II_Settings.xpUnlock) {
                            player.func_71064_a((StatBase)InvoAchievements.unlockAll, 1);
                        }
                        NBTTagCompound replyTags = new NBTTagCompound();
                        replyTags.func_74768_a("ID", 0);
                        replyTags.func_74778_a("Player", player.func_70005_c_());
                        replyTags.func_74768_a("Unlocked", unlocked);
                        return new InvoPacket(replyTags);
                    }
                } else {
                    if (message.tags.func_74762_e("ID") == 1) {
                        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(message.tags.func_74762_e("World"));
                        EntityPlayer player = world.func_72924_a(message.tags.func_74779_i("Player"));
                        int unlocked = 0;
                        if (!player.getEntityData().func_74764_b("INFINITE_INVO_UNLOCKED") && EventHandler.unlockCache.containsKey(player.func_70005_c_())) {
                            unlocked = EventHandler.unlockCache.get(player.func_70005_c_());
                            player.getEntityData().func_74768_a("INFINITE_INVO_UNLOCKED", unlocked);
                        } else {
                            unlocked = player.getEntityData().func_74762_e("INFINITE_INVO_UNLOCKED");
                            EventHandler.unlockCache.put(player.func_70005_c_(), unlocked);
                        }
                        if (unlocked > 0 || !II_Settings.xpUnlock) {
                            player.func_71064_a((StatBase)InvoAchievements.unlockFirst, 1);
                        }
                        if (unlocked + II_Settings.unlockedSlots == II_Settings.invoSize || !II_Settings.xpUnlock) {
                            player.func_71064_a((StatBase)InvoAchievements.unlockAll, 1);
                        }
                        NBTTagCompound reply = new NBTTagCompound();
                        reply.func_74768_a("ID", 0);
                        reply.func_74778_a("Player", player.func_70005_c_());
                        reply.func_74768_a("Unlocked", unlocked);
                        reply.func_74782_a("Settings", (NBTBase)II_Settings.cachedSettings);
                        return new InvoPacket(reply);
                    }
                    if (message.tags.func_74762_e("ID") == 2) {
                        int i;
                        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(message.tags.func_74762_e("World"));
                        EntityPlayer player = world.func_72924_a(message.tags.func_74779_i("Player"));
                        int scrollPos = message.tags.func_74762_e("Scroll");
                        int[] indexes = message.tags.func_74759_k("Indexes");
                        boolean resetSlots = message.tags.func_74767_n("Reset");
                        Slot[] invoSlots = new Slot[27];
                        Container container = player.field_71070_bA;
                        int index = 0;
                        for (i = 0; i < container.field_75151_b.size() && index < 27; ++i) {
                            int origIndex = indexes[index];
                            Slot s = (Slot)container.field_75151_b.get(i);
                            if (!(s.field_75224_c instanceof InventoryPlayer) || origIndex < 9 || origIndex >= 36) continue;
                            if (resetSlots) {
                                if (s.getClass() != Slot.class && s.getClass() != SlotLockable.class) {
                                    InfiniteInvo.logger.log(Level.WARN, "Container " + container.getClass().getSimpleName() + " is not supported by InfiniteInvo! Reason: Custom Slots (" + s.getClass().getSimpleName() + ") are being used!");
                                    return null;
                                }
                                SlotLockable r = new SlotLockable(s.field_75224_c, s.getSlotIndex(), s.field_75223_e, s.field_75221_f);
                                container.field_75151_b.set(i, r);
                                r.field_75222_d = i;
                                s = r;
                                container.field_75153_a.set(i, r.func_75211_c());
                                r.func_75218_e();
                            }
                            invoSlots[index] = s;
                            ++index;
                        }
                        for (i = 0; i < invoSlots.length; ++i) {
                            Slot s = invoSlots[i];
                            if (s == null || !(s instanceof SlotLockable)) continue;
                            ((SlotLockable)s).field_75225_a = i + 9 + scrollPos * 9;
                            s.func_75218_e();
                        }
                        container.func_75142_b();
                    }
                }
            }
            return null;
        }
    }
}

