/*
 * Decompiled with CFR 0.152.
 */
package infiniteinvo.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import infiniteinvo.achievements.InvoAchievements;
import infiniteinvo.client.inventory.GuiBigInventory;
import infiniteinvo.client.inventory.InvoScrollBar;
import infiniteinvo.core.II_Settings;
import infiniteinvo.core.InfiniteInvo;
import infiniteinvo.inventory.BigContainerPlayer;
import infiniteinvo.inventory.BigInventoryPlayer;
import infiniteinvo.network.InvoPacket;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.Level;

public class EventHandler {
    public static File worldDir;
    public static HashMap<String, Integer> unlockCache;
    public static HashMap<String, Container> lastOpened;

    @SubscribeEvent
    public void onPlayerLoad(PlayerEvent.LoadFromFile event) {
        EntityPlayer player = event.entityPlayer;
        player.field_71071_by = new BigInventoryPlayer(player);
        player.field_71070_bA = player.field_71069_bz = new BigContainerPlayer((BigInventoryPlayer)player.field_71071_by, !player.field_70170_p.field_72995_K, player);
        NBTTagCompound nbttagcompound = null;
        try {
            File file1 = new File(event.playerDirectory, player.func_110124_au().toString() + ".dat");
            if (file1.exists() && file1.isFile()) {
                nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file1));
            }
        }
        catch (Exception exception) {
            InfiniteInvo.logger.warn("Failed to load player data for " + player.func_70005_c_());
        }
        if (nbttagcompound != null) {
            player.field_71071_by.func_70443_b(nbttagcompound.func_150295_c("Inventory", 10));
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (!(player.field_71071_by instanceof BigInventoryPlayer)) {
                player.field_71071_by = new BigInventoryPlayer(player);
                player.field_71070_bA = player.field_71069_bz = new BigContainerPlayer((BigInventoryPlayer)player.field_71071_by, !player.field_70170_p.field_72995_K, player);
            }
            if (event.world.field_72995_K) {
                NBTTagCompound requestTags = new NBTTagCompound();
                requestTags.func_74768_a("ID", 1);
                requestTags.func_74768_a("World", event.world.field_73011_w.field_76574_g);
                requestTags.func_74778_a("Player", player.func_70005_c_());
                InfiniteInvo.instance.network.sendToServer((IMessage)new InvoPacket(requestTags));
            } else {
                II_Settings.LoadFromCache();
            }
        }
    }

    @SubscribeEvent
    public void onItemDropped(ItemTossEvent event) {
        if (event.entityItem.func_92059_d() != null && Item.field_150901_e.func_148750_c((Object)event.entityItem.func_92059_d().func_77973_b()).equals("exnihilo:silkworm")) {
            event.player.func_71064_a((StatBase)InvoAchievements.wormDrops, 1);
        }
    }

    @SubscribeEvent
    public void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        if (event.pickedUp != null && event.pickedUp.func_92059_d() != null && event.pickedUp.func_92059_d().func_77973_b() == Items.field_151103_aS && !event.pickedUp.field_70170_p.field_72995_K) {
            if (!event.player.func_70005_c_().equals(event.pickedUp.func_145800_j())) {
                // empty if block
            }
            if (event.pickedUp.func_145800_j() == null || event.pickedUp.func_145800_j().isEmpty()) {
                return;
            }
            System.out.println("Picking up bone from " + event.pickedUp.func_145800_j());
            EntityPlayer player = event.pickedUp.field_70170_p.func_72924_a(event.pickedUp.func_145800_j());
            if (player != null) {
                player.func_71064_a((StatBase)InvoAchievements.boneSanta, 1);
            }
        }
    }

    @SubscribeEvent
    public void onEntityLiving(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            boolean flag = true;
            for (int i = 9; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack stack = player.field_71071_by.field_70462_a[i];
                if (i >= ((BigInventoryPlayer)player.field_71071_by).getUnlockedSlots() && !event.entityLiving.field_70170_p.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                    if (stack != null) {
                        player.func_70099_a(stack.func_77946_l(), 0.0f);
                        player.field_71071_by.func_70299_a(i, null);
                        player.field_71071_by.func_70296_d();
                        stack = null;
                    }
                    flag = false;
                    continue;
                }
                if (stack != null && stack.func_77973_b() == Items.field_151157_am && stack.field_77994_a >= stack.func_77976_d()) continue;
                flag = false;
            }
            if (flag) {
                player.func_71064_a((StatBase)InvoAchievements.bacon, 1);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityPlayer && (!II_Settings.keepUnlocks || event.entityLiving.field_70170_p.func_82736_K().func_82766_b("keepInventory"))) {
            unlockCache.remove(event.entityLiving.func_70005_c_());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui != null && event.gui.getClass() == GuiInventory.class && !(event.gui instanceof GuiBigInventory)) {
            event.gui = new GuiBigInventory((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGuiPostInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.gui instanceof GuiBigInventory) {
            ((GuiBigInventory)event.gui).redoButtons = true;
        } else if (event.gui instanceof GuiContainer && !(event.gui instanceof GuiContainerCreative)) {
            GuiContainer gui = (GuiContainer)event.gui;
            Container container = gui.field_147002_h;
            event.buttonList.add(new InvoScrollBar(256, 0, 0, 1, 1, "", container, gui));
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K && worldDir == null && MinecraftServer.func_71276_C().func_71278_l()) {
            MinecraftServer server = MinecraftServer.func_71276_C();
            worldDir = InfiniteInvo.proxy.isClient() ? server.func_71209_f("saves/" + server.func_71270_I()) : server.func_71209_f(server.func_71270_I());
            new File(worldDir, "data/").mkdirs();
            EventHandler.LoadCache(new File(worldDir, "data/SlotUnlockCache"));
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (!event.world.field_72995_K && worldDir != null && MinecraftServer.func_71276_C().func_71278_l()) {
            new File(worldDir, "data/").mkdirs();
            EventHandler.SaveCache(new File(worldDir, "data/SlotUnlockCache"));
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.world.field_72995_K && MinecraftServer.func_71276_C().func_71278_l()) {
            new File(worldDir, "data/").mkdirs();
            EventHandler.SaveCache(new File(worldDir, "data/SlotUnlockCache"));
            worldDir = null;
            unlockCache.clear();
        }
    }

    public static void SaveCache(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(unlockCache);
            oos.close();
            fos.close();
        }
        catch (Exception e) {
            InfiniteInvo.logger.log(Level.ERROR, "Failed to save slot unlock cache", (Throwable)e);
        }
    }

    public static void LoadCache(File file) {
        try {
            FileInputStream fis;
            if (!file.exists()) {
                file.createNewFile();
            }
            if ((fis = new FileInputStream(file)).available() <= 0) {
                fis.close();
                return;
            }
            ObjectInputStream ois = new ObjectInputStream(fis);
            unlockCache = (HashMap)ois.readObject();
            ois.close();
            fis.close();
        }
        catch (Exception e) {
            InfiniteInvo.logger.log(Level.ERROR, "Failed to load slot unlock cache", (Throwable)e);
        }
    }

    static {
        unlockCache = new HashMap();
        lastOpened = new HashMap();
    }
}

