/*
 * Decompiled with CFR 0.152.
 */
package infiniteinvo.client.inventory;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import infiniteinvo.core.II_Settings;
import infiniteinvo.core.InfiniteInvo;
import infiniteinvo.inventory.BigInventoryPlayer;
import infiniteinvo.inventory.SlotLockable;
import infiniteinvo.network.InvoPacket;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Mouse;

public class InvoScrollBar
extends GuiButton {
    int maxScroll = 0;
    int scrollPos = 0;
    Container container;
    GuiContainer gui;
    int guiLeft = 0;
    int guiTop = 0;
    int[][] slotPos = new int[27][2];
    Slot[] invoSlots = new Slot[27];
    int[] slotIndex = new int[27];
    int scrollX = 0;
    int scrollY = Integer.MAX_VALUE;
    int dragging = 0;

    public InvoScrollBar(int id, int posX, int posY, int width, int height, String title, Container container, GuiContainer gui) {
        super(id, posX, posY, width, height, title);
        this.container = container;
        this.gui = gui;
        int index = 0;
        for (int i = 0; i < container.field_75151_b.size() && index < 27; ++i) {
            Slot s = (Slot)container.field_75151_b.get(i);
            if (!(s.field_75224_c instanceof InventoryPlayer) || s.getSlotIndex() < 9 || s.getSlotIndex() >= 36) continue;
            if (s.getClass() != Slot.class && s.getClass() != SlotLockable.class) {
                InfiniteInvo.logger.log(Level.WARN, "Container " + container.getClass().getSimpleName() + " is not supported by InfiniteInvo! Reason: Custom Slots are being used!");
                return;
            }
            SlotLockable r = new SlotLockable(s.field_75224_c, s.getSlotIndex(), s.field_75223_e, s.field_75221_f);
            container.field_75151_b.set(i, r);
            r.field_75222_d = i;
            s = r;
            container.field_75153_a.set(i, r.func_75211_c());
            r.func_75218_e();
            this.invoSlots[index] = s;
            this.slotIndex[index] = s.getSlotIndex();
            this.slotPos[index][0] = s.field_75223_e;
            this.slotPos[index][1] = s.field_75221_f;
            if (s.field_75223_e - 1 > this.scrollX) {
                this.scrollX = s.field_75223_e - 1;
            }
            if (s.field_75221_f - 1 < this.scrollY) {
                this.scrollY = s.field_75221_f - 1;
            }
            ++index;
        }
        container.func_75142_b();
        this.maxScroll = II_Settings.invoSize <= 27 ? 0 : MathHelper.func_76123_f((float)((float)(II_Settings.invoSize - 27) / 9.0f));
        NBTTagCompound scrollTags = new NBTTagCompound();
        scrollTags.func_74768_a("ID", 2);
        scrollTags.func_74778_a("Player", Minecraft.func_71410_x().field_71439_g.func_70005_c_());
        scrollTags.func_74768_a("World", Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73011_w.field_76574_g);
        scrollTags.func_74768_a("Scroll", 0);
        scrollTags.func_74783_a("Indexes", this.slotIndex);
        scrollTags.func_74757_a("Reset", true);
        InfiniteInvo.instance.network.sendToServer((IMessage)new InvoPacket(scrollTags));
        this.UpdateGuiPos();
    }

    public void UpdateGuiPos() {
        Field f2;
        Field f1;
        try {
            f1 = GuiContainer.class.getDeclaredField("field_147003_i");
            f2 = GuiContainer.class.getDeclaredField("field_147009_r");
        }
        catch (Exception e1) {
            try {
                f1 = GuiContainer.class.getDeclaredField("guiLeft");
                f2 = GuiContainer.class.getDeclaredField("guiTop");
            }
            catch (Exception e2) {
                InfiniteInvo.logger.log(Level.ERROR, "Unable to get gui positioning for GUI: ", (Throwable)e2);
                return;
            }
        }
        f1.setAccessible(true);
        f2.setAccessible(true);
        try {
            this.guiLeft = f1.getInt(this.gui);
            this.guiTop = f2.getInt(this.gui);
        }
        catch (Exception e) {
            InfiniteInvo.logger.log(Level.ERROR, "Unable to get gui positioning for GUI: ", (Throwable)e);
            return;
        }
    }

    public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
        BigInventoryPlayer pinvo;
        this.UpdateGuiPos();
        int scrollDX = (int)Math.signum(Mouse.getDWheel());
        if (scrollDX != 0) {
            this.doScroll(scrollDX);
        } else if (Mouse.isButtonDown((int)0)) {
            boolean flag;
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            int i = scaledresolution.func_78326_a();
            int j = scaledresolution.func_78328_b();
            int mouseX = Mouse.getX() * i / mc.field_71443_c;
            int mouseY = this.field_146121_g - Mouse.getY() * j / mc.field_71440_d - 1;
            int sx = this.guiLeft + this.scrollX + 20;
            int sy = this.guiTop + this.scrollY;
            boolean bl = flag = mouseX >= sx && mouseY >= sy && mouseX < sx + 8 && mouseY < sy + 54;
            if ((flag || this.dragging == 1) && this.dragging != -1) {
                this.dragging = 1;
                int preScroll = this.scrollPos;
                this.scrollPos = MathHelper.func_76125_a((int)Math.round((float)(mouseY - sy) / 54.0f * (float)this.maxScroll), (int)0, (int)this.maxScroll);
                if (this.scrollPos - preScroll != 0) {
                    this.doScroll(this.scrollPos - preScroll);
                }
            } else {
                this.dragging = -1;
            }
        } else {
            this.dragging = 0;
        }
        p_146112_1_.func_110434_K().func_110577_a(new ResourceLocation("infiniteinvo", "textures/gui/adjustable_gui.png"));
        if (this.maxScroll > 0) {
            this.func_73729_b(this.guiLeft + this.scrollX + 20, this.guiTop + this.scrollY, 52, 166, 8, 18);
            this.func_73729_b(this.guiLeft + this.scrollX + 20, this.guiTop + this.scrollY + 18, 44, 166, 8, 18);
            this.func_73729_b(this.guiLeft + this.scrollX + 20, this.guiTop + this.scrollY + 36, 36, 166, 8, 18);
            this.func_73729_b(this.guiLeft + this.scrollX + 20, this.guiTop + this.scrollY + Math.round((float)this.scrollPos / (float)this.maxScroll * 46.0f), 60, 166, 8, 8);
        }
        if (Minecraft.func_71410_x().field_71439_g.field_71071_by instanceof BigInventoryPlayer && (pinvo = (BigInventoryPlayer)Minecraft.func_71410_x().field_71439_g.field_71071_by).getUnlockedSlots() - 9 < 27) {
            for (int i = 0; i < this.invoSlots.length; ++i) {
                Slot s = this.invoSlots[i];
                if (s == null) continue;
                if (s.getSlotIndex() - 9 >= II_Settings.invoSize) {
                    s.field_75223_e = -99;
                    s.field_75221_f = -99;
                    this.func_73729_b(this.slotPos[i][0] + this.guiLeft - 1, this.slotPos[i][1] + this.guiTop - 1, 0, 166, 18, 18);
                    continue;
                }
                if (pinvo.getUnlockedSlots() <= s.getSlotIndex()) {
                    s.field_75223_e = -99;
                    s.field_75221_f = -99;
                    this.func_73729_b(this.slotPos[i][0] + this.guiLeft - 1, this.slotPos[i][1] + this.guiTop - 1, 18, 166, 18, 18);
                    continue;
                }
                s.field_75223_e = this.slotPos[i][0];
                s.field_75221_f = this.slotPos[i][1];
            }
        }
    }

    public void doScroll(int scrollDX) {
        int preScroll = this.scrollPos;
        this.scrollPos -= (int)Math.signum(scrollDX);
        this.scrollPos = MathHelper.func_76125_a((int)this.scrollPos, (int)0, (int)this.maxScroll);
        if (preScroll != this.scrollPos) {
            for (int i = 0; i < this.invoSlots.length; ++i) {
                Slot s = this.invoSlots[i];
                if (s instanceof SlotLockable) {
                    ((SlotLockable)s).field_75225_a = this.slotIndex[i] + this.scrollPos * 9;
                }
                s.func_75218_e();
            }
            this.container.func_75142_b();
            NBTTagCompound scrollTags = new NBTTagCompound();
            scrollTags.func_74768_a("ID", 2);
            scrollTags.func_74778_a("Player", Minecraft.func_71410_x().field_71439_g.func_70005_c_());
            scrollTags.func_74768_a("World", Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73011_w.field_76574_g);
            scrollTags.func_74768_a("Scroll", this.scrollPos);
            scrollTags.func_74783_a("Indexes", this.slotIndex);
            scrollTags.func_74757_a("Reset", false);
            InfiniteInvo.instance.network.sendToServer((IMessage)new InvoPacket(scrollTags));
        }
    }
}

