package portalgun.api;

import java.lang.reflect.Array;

public final class Api {
	
	/**
	 * Adds a blockID to the portalgun block grabbing blacklist. Non-metadata specific.
	 * @param blockID
	 */
	public static void addBlockIDToGrabList(int blockID) {
		addBlockIDToGrabList(blockID, new int[] { -1 });
	}
	
	/**
	 * Adds a blockID to the portalgun block grabbing blacklist. Metadata specific with metadata in the int[]. Set to null to remove from blacklist.
	 * @param blockID
	 * @param metadata
	 */
	public static void addBlockIDToGrabList(int blockID, int[] metadata) {
		try {
			Class.forName("portalgun.common.PortalGun").getMethod("addBlockIDToGrabList", Integer.class, Array.newInstance(Integer.class, 0).getClass()).invoke(null, blockID, metadata);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Adds an entity to the Sentry Turret exceptions. This will make Sentry Turrets ignore entities of this class. Must be instanceof EntityLiving. 
	 * @param entityClass
	 */
	public static void addEntityToTurretExceptions(Class entityClass) {
		try {
			Class.forName("portalgun.common.PortalGun").getMethod("addEntityToTurretExceptions", Class.class).invoke(null, entityClass);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
	
}
