/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.ServerUtils;
import codechicken.core.packet.PacketCustom;
import codechicken.core.vec.BlockCoord;
import codechicken.wirelessredstone.core.ITileWireless;
import codechicken.wirelessredstone.core.ItemWirelessFreq;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.WirelessBolt;
import java.util.ArrayList;
import java.util.Iterator;

public class WRCoreServerPacketHandler
implements PacketCustom.ICustomPacketHandler.IServerPacketHandler {
    public void handlePacket(PacketCustom packetCustom, iv nethandler, iq sender) {
        this.handlePacket((in)sender.p, sender, packetCustom);
    }

    private void handlePacket(in world, iq player, PacketCustom packet) {
        switch (packet.getType()) {
            case 1: {
                this.setTileFreq((qx)player, (yc)world, packet.readCoord(), packet.readShort());
                break;
            }
            case 2: {
                this.setItemFreq(player, packet.readShort(), packet.readShort());
                break;
            }
            case 4: {
                this.handleFreqInfo(packet);
                break;
            }
            case 5: {
                this.decrementSlot(player, packet.readShort());
                break;
            }
            case 9: {
                RedstoneEther.get(false).setFreqOwner(packet.readShort(), packet.readString());
            }
        }
    }

    private void decrementSlot(iq player, int slot) {
        try {
            ur item = player.bJ.a[slot];
            --item.a;
            if (item.a == 0) {
                player.bJ.a[slot] = null;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void setItemFreq(iq sender, int slot, int freq) {
        ur stack;
        if (RedstoneEther.get(false).canBroadcastOnFrequency((qx)sender, freq) && (stack = sender.bJ.a[slot]) != null && stack.b() instanceof ItemWirelessFreq) {
            ((ItemWirelessFreq)stack.b()).setFreq((qx)sender, slot, stack, freq);
        }
    }

    private void setTileFreq(qx sender, yc world, BlockCoord pos, int freq) {
        any tile;
        if (RedstoneEther.get(false).canBroadcastOnFrequency(sender, freq) && (tile = RedstoneEther.getTile(world, pos)) instanceof ITileWireless) {
            ((ITileWireless)tile).setFreq(freq);
        }
    }

    private void handleFreqInfo(PacketCustom packet) {
        int freq = packet.readUnsignedShort();
        String name = packet.readString();
        int colourid = packet.readUnsignedByte();
        RedstoneEther.get(false).setFreqName(freq, name);
        RedstoneEther.get(false).setFreqColour(freq, colourid);
        WRCoreServerPacketHandler.sendSetFreqInfoTo(null, freq, name, colourid);
    }

    public static void sendSetFrequencyRangeTo(qx player, int startfreq, int endfreq, boolean jam) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 3);
        packet.writeShort((int)((short)startfreq));
        packet.writeShort((int)((short)endfreq));
        packet.writeBoolean(jam);
        ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
    }

    public static void sendPublicFrequencyTo(qx player, int freq) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 2);
        packet.writeShort(freq);
        packet.writeByte(1);
        ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
    }

    public static void sendSharedFrequencyTo(qx player, int freq) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 2);
        packet.writeShort(freq);
        packet.writeByte(2);
        ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
    }

    public static void sendSetFreqInfoTo(qx player, int freq, String name, int colourid) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 4);
        packet.writeShort(freq);
        packet.writeByte(colourid);
        packet.writeString(name);
        ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
    }

    public static void sendJamPlayerPacketTo(qx player, boolean jam) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 7);
        packet.writeBoolean(jam);
        ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
    }

    public static void sendWirelessBolt(WirelessBolt bolt) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 8);
        packet.writeFloat((float)bolt.start.x);
        packet.writeFloat((float)bolt.start.y);
        packet.writeFloat((float)bolt.start.z);
        packet.writeFloat((float)bolt.end.x);
        packet.writeFloat((float)bolt.end.y);
        packet.writeFloat((float)bolt.end.z);
        packet.writeLong(bolt.seed);
        ServerUtils.sendPacketToPostion((int)((int)bolt.start.x), (int)((int)bolt.start.z), (ef)packet.toPacket());
    }

    public static void sendSetSlot(int slot, ur stack) {
    }

    public static void sendFreqInfoTo(qx player, ArrayList freqsWithInfo) {
        if (freqsWithInfo.size() == 0) {
            return;
        }
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 1);
        packet.writeShort(freqsWithInfo.size());
        Iterator iterator = freqsWithInfo.iterator();
        while (iterator.hasNext()) {
            int freq = (Integer)iterator.next();
            packet.writeShort(freq);
            packet.writeByte(RedstoneEther.get(false).getFreqColourId(freq));
            packet.writeString(RedstoneEther.get(false).getFreqName(freq));
        }
        ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
    }

    public static void sendFreqOwnerTo(qx player, ArrayList freqsWithOwners) {
        if (freqsWithOwners.size() == 0) {
            return;
        }
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 10);
        packet.writeShort(freqsWithOwners.size());
        Iterator iterator = freqsWithOwners.iterator();
        while (iterator.hasNext()) {
            int freq = (Integer)iterator.next();
            packet.writeShort(freq);
            packet.writeString(RedstoneEther.get(false).getFreqOwner(freq));
        }
        ServerUtils.sendPacketTo((qx)player, (ef)packet.toPacket());
    }

    public static void sendSetFreqOwner(int freq, String username) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 9);
        packet.writeShort(freq);
        packet.writeString(username);
        ServerUtils.sendPacketToAll((ef)packet.toPacket());
    }
}

